/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.controllers;

import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.network.SegmentMessage;
import com.yyon.grapplinghook.vec;
import java.util.LinkedList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SegmentHandler {
    public LinkedList<vec> segments = new LinkedList();
    public LinkedList<EnumFacing> segmentbottomsides;
    public LinkedList<EnumFacing> segmenttopsides;
    public World world;
    public grappleArrow arrow;
    vec prevhookpos = null;
    vec prevplayerpos = null;
    final double bendoffset = 0.05;
    final double intoblock = 0.05;
    double ropelen;

    public SegmentHandler(World w, grappleArrow arrow, vec hookpos, vec playerpos) {
        this.segments.add(hookpos);
        this.segments.add(playerpos);
        this.segmentbottomsides = new LinkedList();
        this.segmentbottomsides.add(null);
        this.segmentbottomsides.add(null);
        this.segmenttopsides = new LinkedList();
        this.segmenttopsides.add(null);
        this.segmenttopsides.add(null);
        this.world = w;
        this.arrow = arrow;
        this.prevhookpos = new vec(hookpos);
        this.prevplayerpos = new vec(playerpos);
    }

    public void forceSetPos(vec hookpos, vec playerpos) {
        this.prevhookpos = new vec(hookpos);
        this.prevplayerpos = new vec(playerpos);
        this.segments.set(0, new vec(hookpos));
        this.segments.set(this.segments.size() - 1, new vec(playerpos));
    }

    public void updatepos(vec hookpos, vec playerpos, double ropelen) {
        this.segments.set(0, hookpos);
        this.segments.set(this.segments.size() - 1, playerpos);
        this.ropelen = ropelen;
    }

    public void update(vec hookpos, vec playerpos, double ropelen, boolean movinghook) {
        if (this.prevhookpos == null) {
            this.prevhookpos = hookpos;
            this.prevplayerpos = playerpos;
        }
        this.segments.set(0, hookpos);
        this.segments.set(this.segments.size() - 1, playerpos);
        this.ropelen = ropelen;
        vec closest = this.segments.get(this.segments.size() - 2);
        while (this.segments.size() != 2) {
            int index = this.segments.size() - 2;
            closest = this.segments.get(index);
            EnumFacing bottomside = this.segmentbottomsides.get(index);
            EnumFacing topside = this.segmenttopsides.get(index);
            vec ropevec = playerpos.sub(closest);
            vec beforepoint = this.segments.get(index - 1);
            vec edgevec = this.getnormal(bottomside).cross(this.getnormal(topside));
            vec planenormal = beforepoint.sub(closest).cross(edgevec);
            if (!(ropevec.dot(planenormal) > 0.0)) break;
            this.removesegment(index);
        }
        vec farthest = this.segments.get(1);
        if (movinghook) {
            while (this.segments.size() != 2) {
                int index = 1;
                farthest = this.segments.get(index);
                EnumFacing bottomside = this.segmentbottomsides.get(index);
                EnumFacing topside = this.segmenttopsides.get(index);
                vec ropevec = farthest.sub(hookpos);
                vec beforepoint = this.segments.get(index + 1);
                vec edgevec = this.getnormal(bottomside).cross(this.getnormal(topside));
                vec planenormal = beforepoint.sub(farthest).cross(edgevec);
                if (!(ropevec.dot(planenormal) > 0.0) && !(ropevec.length() < 0.1)) break;
                this.removesegment(index);
            }
            while (this.getDistToFarthest() > ropelen) {
                this.removesegment(1);
            }
        }
        if (movinghook) {
            vec prevfarthest = farthest = this.segments.get(1);
            if (this.segments.size() == 2) {
                prevfarthest = this.prevplayerpos;
            }
            this.updatesegment(hookpos, this.prevhookpos, farthest, prevfarthest, 1, 0);
        }
        vec prevclosest = closest;
        if (this.segments.size() == 2) {
            prevclosest = this.prevhookpos;
        }
        this.updatesegment(closest, prevclosest, playerpos, this.prevplayerpos, this.segments.size() - 1, 0);
        this.prevhookpos = hookpos;
        this.prevplayerpos = playerpos;
    }

    public void removesegment(int index) {
        this.segments.remove(index);
        this.segmentbottomsides.remove(index);
        this.segmenttopsides.remove(index);
        if (!this.world.field_72995_K) {
            SegmentMessage addmessage = new SegmentMessage(this.arrow.func_145782_y(), false, index, new vec(0.0, 0.0, 0.0), EnumFacing.DOWN, EnumFacing.DOWN);
            vec playerpoint = vec.positionvec(this.arrow.shootingEntity);
            grapplemod.network.sendToAllAround((IMessage)addmessage, new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), playerpoint.x, playerpoint.y, playerpoint.z, 100.0));
        }
    }

    public void updatesegment(vec top, vec prevtop, vec bottom, vec prevbottom, int index, int numberrecursions) {
        RayTraceResult bottomraytraceresult = this.world.func_147447_a(bottom.toVec3d(), top.toVec3d(), false, true, false);
        if (bottomraytraceresult != null) {
            if (this.world.func_147447_a(prevbottom.toVec3d(), prevtop.toVec3d(), false, true, false) != null) {
                return;
            }
            vec bottomhitvec = new vec(bottomraytraceresult.field_72307_f.field_72450_a, bottomraytraceresult.field_72307_f.field_72448_b, bottomraytraceresult.field_72307_f.field_72449_c);
            EnumFacing bottomside = bottomraytraceresult.field_178784_b;
            vec bottomnormal = this.getnormal(bottomside);
            double prevropelen = prevtop.sub(prevbottom).length();
            vec cornerbound1 = bottomhitvec.add(bottomnormal.changelen(-0.05));
            vec bound_option1 = this.line_plane_intersection(prevtop, prevbottom, cornerbound1, bottomnormal);
            vec bound_option2 = this.line_plane_intersection(top, prevtop, cornerbound1, bottomnormal);
            vec bound_option3 = this.line_plane_intersection(prevbottom, bottom, cornerbound1, bottomnormal);
            for (vec cornerbound2 : new vec[]{bound_option1, bound_option2, bound_option3}) {
                RayTraceResult cornerraytraceresult;
                if (cornerbound2 == null || (cornerraytraceresult = this.world.func_147447_a(cornerbound2.toVec3d(), cornerbound1.toVec3d(), false, true, false)) == null) continue;
                vec cornerhitpos = new vec(cornerraytraceresult.field_72307_f.field_72450_a, cornerraytraceresult.field_72307_f.field_72448_b, cornerraytraceresult.field_72307_f.field_72449_c);
                EnumFacing cornerside = cornerraytraceresult.field_178784_b;
                if (cornerside == bottomside || cornerside.func_176734_d() == bottomside) continue;
                vec actualcorner = cornerhitpos.add(bottomnormal.changelen(0.05));
                vec bend = actualcorner.add(bottomnormal.changelen(0.05)).add(this.getnormal(cornerside).changelen(0.05));
                vec topropevec = bend.sub(top);
                vec bottomropevec = bend.sub(bottom);
                if (topropevec.length() < 0.05 && this.segmentbottomsides.get(index - 1) == bottomside && this.segmenttopsides.get(index - 1) == cornerside || bottomropevec.length() < 0.05 && this.segmentbottomsides.get(index) == bottomside && this.segmenttopsides.get(index) == cornerside) continue;
                this.actuallyaddsegment(index, bend, bottomside, cornerside);
                if (this.getDistToAnchor() + 0.2 > this.ropelen) {
                    this.removesegment(index);
                    continue;
                }
                double newropelen = topropevec.length() + bottomropevec.length();
                double prevtoptobend = topropevec.length() * prevropelen / newropelen;
                vec prevbend = prevtop.add(prevbottom.sub(prevtop).changelen(prevtoptobend));
                if (numberrecursions < 10) {
                    this.updatesegment(top, prevtop, bend, prevbend, index, numberrecursions + 1);
                    break;
                }
                System.out.println("Warning: number recursions exceeded");
                break;
            }
        }
    }

    public vec line_plane_intersection(vec linepoint1, vec linepoint2, vec planepoint, vec planenormal) {
        vec linevec = linepoint2.sub(linepoint1);
        if (linevec.dot(planenormal) == 0.0) {
            return null;
        }
        double d = planepoint.sub(linepoint1).dot(planenormal) / linevec.dot(planenormal);
        return linepoint1.add(linevec.mult(d));
    }

    public vec getnormal(EnumFacing facing) {
        Vec3i facingvec = facing.func_176730_m();
        return new vec(facingvec.func_177958_n(), facingvec.func_177956_o(), facingvec.func_177952_p());
    }

    public boolean hookpastbend(double ropelen) {
        return this.getDistToFarthest() > ropelen;
    }

    public BlockPos getbendblock(int index) {
        vec bendpos = this.segments.get(index);
        vec vec2 = this.getnormal(this.segmentbottomsides.get(index));
        this.getClass();
        bendpos.add_ip(vec2.changelen(-0.05 * 2.0));
        vec vec3 = this.getnormal(this.segmenttopsides.get(index));
        this.getClass();
        bendpos.add_ip(vec3.changelen(-0.05 * 2.0));
        return new BlockPos(bendpos.x, bendpos.y, bendpos.z);
    }

    public void actuallyaddsegment(int index, vec bendpoint, EnumFacing bottomside, EnumFacing topside) {
        this.segments.add(index, bendpoint);
        this.segmentbottomsides.add(index, bottomside);
        this.segmenttopsides.add(index, topside);
        if (!this.world.field_72995_K) {
            SegmentMessage addmessage = new SegmentMessage(this.arrow.func_145782_y(), true, index, bendpoint, topside, bottomside);
            vec playerpoint = vec.positionvec(this.arrow.shootingEntity);
            grapplemod.network.sendToAllAround((IMessage)addmessage, new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), playerpoint.x, playerpoint.y, playerpoint.z, 100.0));
        }
    }

    public void print() {
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            System.out.print(i);
            System.out.print(" ");
            System.out.print(this.segmenttopsides.get(i).toString());
            System.out.print(" ");
            System.out.print(this.segmentbottomsides.get(i).toString());
            System.out.print(" ");
            this.segments.get(i).print();
        }
    }

    public vec getclosest(vec hookpos) {
        this.segments.set(0, hookpos);
        return this.segments.get(this.segments.size() - 2);
    }

    public double getDistToAnchor() {
        double dist = 0.0;
        for (int i = 0; i < this.segments.size() - 2; ++i) {
            dist += this.segments.get(i).sub(this.segments.get(i + 1)).length();
        }
        return dist;
    }

    public vec getfarthest() {
        return this.segments.get(1);
    }

    public double getDistToFarthest() {
        double dist = 0.0;
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            dist += this.segments.get(i).sub(this.segments.get(i + 1)).length();
        }
        return dist;
    }

    public double getDist(vec hookpos, vec playerpos) {
        this.segments.set(0, hookpos);
        this.segments.set(this.segments.size() - 1, playerpos);
        double dist = 0.0;
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            dist += this.segments.get(i).sub(this.segments.get(i + 1)).length();
        }
        return dist;
    }

    public AxisAlignedBB getBoundingBox(vec hookpos, vec playerpos) {
        this.updatepos(hookpos, playerpos, this.ropelen);
        vec minvec = new vec(hookpos);
        vec maxvec = new vec(hookpos);
        for (int i = 1; i < this.segments.size(); ++i) {
            vec segpos = this.segments.get(i);
            if (segpos.x < minvec.x) {
                minvec.x = segpos.x;
            } else if (segpos.x > maxvec.x) {
                maxvec.x = segpos.x;
            }
            if (segpos.y < minvec.y) {
                minvec.y = segpos.y;
            } else if (segpos.y > maxvec.y) {
                maxvec.y = segpos.y;
            }
            if (segpos.z < minvec.z) {
                minvec.z = segpos.z;
                continue;
            }
            if (!(segpos.z > maxvec.z)) continue;
            maxvec.z = segpos.z;
        }
        AxisAlignedBB bb = new AxisAlignedBB(minvec.x, minvec.y, minvec.z, maxvec.x, maxvec.y, maxvec.z);
        return bb;
    }
}

