/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities;

import com.yyon.grapplinghook.GrappleConfig;
import com.yyon.grapplinghook.GrappleCustomization;
import com.yyon.grapplinghook.controllers.SegmentHandler;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.network.GrappleAttachMessage;
import com.yyon.grapplinghook.network.GrappleAttachPosMessage;
import com.yyon.grapplinghook.vec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class grappleArrow
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public Entity shootingEntity = null;
    public int shootingEntityID;
    private boolean firstattach = false;
    public vec thispos;
    public boolean righthand = true;
    public boolean attached = false;
    public double pull;
    public double taut = 1.0;
    public boolean field_70158_ak = true;
    public boolean isdouble = false;
    public double r;
    public SegmentHandler segmenthandler = null;
    public GrappleCustomization customization = null;
    public vec prevpos = null;
    public boolean foundblock = false;
    public boolean wasinair = false;
    public BlockPos magnetblock = null;
    public final int RenderBoundingBoxSize = 999;

    public grappleArrow(World worldIn) {
        super(worldIn);
        this.segmenthandler = new SegmentHandler(this.field_70170_p, this, vec.positionvec((Entity)this), vec.positionvec((Entity)this));
        this.customization = new GrappleCustomization();
    }

    public grappleArrow(World worldIn, EntityLivingBase shooter, boolean righthand, GrappleCustomization customization, boolean isdouble) {
        super(worldIn, shooter);
        this.shootingEntity = shooter;
        this.shootingEntityID = this.shootingEntity.func_145782_y();
        this.isdouble = isdouble;
        vec pos = vec.positionvec(this.shootingEntity).add(new vec(0.0, this.shootingEntity.func_70047_e(), 0.0));
        this.segmenthandler = new SegmentHandler(this.field_70170_p, this, new vec(pos), new vec(pos));
        this.customization = customization;
        this.r = customization.maxlen;
        this.righthand = righthand;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shootingEntityID == 0 || this.shootingEntity == null) {
            this.remove();
        }
        if (this.firstattach) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.firstattach = false;
            super.func_70107_b(this.thispos.x, this.thispos.y, this.thispos.z);
        }
        if (!this.field_70170_p.field_72995_K && this.shootingEntity != null && !this.attached) {
            double newdist;
            vec farthest;
            if (this.segmenthandler.hookpastbend(this.r)) {
                System.out.println("around bend");
                farthest = this.segmenthandler.getfarthest();
                this.serverAttach(this.segmenthandler.getbendblock(1), farthest, null);
            }
            if (!this.customization.phaserope) {
                this.segmenthandler.update(vec.positionvec((Entity)this), vec.positionvec(this.shootingEntity).add(new vec(0.0, this.shootingEntity.func_70047_e(), 0.0)), this.r, true);
                if (this.customization.sticky && this.segmenthandler.segments.size() > 2) {
                    int bendnumber = this.segmenthandler.segments.size() - 2;
                    vec closest = this.segmenthandler.segments.get(bendnumber);
                    BlockPos blockpos = this.segmenthandler.getbendblock(bendnumber);
                    for (int i = 1; i <= bendnumber; ++i) {
                        this.segmenthandler.removesegment(1);
                    }
                    this.serverAttach(blockpos, closest, null);
                }
            } else {
                this.segmenthandler.updatepos(vec.positionvec((Entity)this), vec.positionvec(this.shootingEntity).add(new vec(0.0, this.shootingEntity.func_70047_e(), 0.0)), this.r);
            }
            farthest = this.segmenthandler.getfarthest();
            double distToFarthest = this.segmenthandler.getDistToFarthest();
            vec ropevec = vec.positionvec((Entity)this).sub(farthest);
            double d = ropevec.length();
            if (this.customization.reelin && this.shootingEntity.func_70093_af() && (newdist = d + distToFarthest - 0.4) > 1.0 && newdist <= this.customization.maxlen) {
                this.r = newdist;
            }
            if (d + distToFarthest > this.r) {
                vec motion = vec.motionvec((Entity)this);
                if (motion.dot(ropevec) > 0.0) {
                    motion = motion.removealong(ropevec);
                }
                this.setVelocityActually(motion.x, motion.y, motion.z);
                ropevec.changelen_ip(this.r - distToFarthest);
                vec newpos = ropevec.add(farthest);
                this.func_70107_b(newpos.x, newpos.y, newpos.z);
            }
        }
        if (this.customization.attract && vec.positionvec((Entity)this).sub(vec.positionvec(this.shootingEntity)).length() > this.customization.attractradius) {
            if (this.shootingEntity == null) {
                return;
            }
            if (!this.foundblock && !this.field_70170_p.field_72995_K) {
                vec playerpos = vec.positionvec(this.shootingEntity);
                vec pos = vec.positionvec((Entity)this);
                if (this.magnetblock == null && this.prevpos != null) {
                    HashMap<BlockPos, Boolean> checkedset = new HashMap<BlockPos, Boolean>();
                    vec vector = pos.sub(this.prevpos);
                    vec normvector = vector.normalize();
                    int i = 0;
                    while ((double)i < vector.length()) {
                        double dist = this.prevpos.sub(playerpos).length();
                        int radius = (int)dist / 4;
                        BlockPos found = this.check(this.prevpos, checkedset);
                        if (found != null) {
                            vec distvec = new vec(found.func_177958_n(), found.func_177956_o(), found.func_177952_p());
                            distvec.sub_ip(this.prevpos);
                            if (distvec.length() < (double)radius) {
                                this.func_70634_a(this.prevpos.x, this.prevpos.y, this.prevpos.z);
                                pos = this.prevpos;
                                this.magnetblock = found;
                                break;
                            }
                        } else {
                            this.wasinair = true;
                        }
                        this.prevpos.add_ip(normvector);
                        ++i;
                    }
                }
                if (this.magnetblock != null) {
                    IBlockState blockstate = this.field_70170_p.func_180495_p(this.magnetblock);
                    AxisAlignedBB BB = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, this.magnetblock);
                    vec blockvec = new vec((double)this.magnetblock.func_177958_n() + (BB.field_72336_d + BB.field_72340_a) / 2.0, (double)this.magnetblock.func_177956_o() + (BB.field_72337_e + BB.field_72338_b) / 2.0, (double)this.magnetblock.func_177952_p() + (BB.field_72334_f + BB.field_72339_c) / 2.0);
                    vec newvel = blockvec.sub(pos);
                    double l = newvel.length();
                    newvel.changelen(this.getVelocity());
                    this.field_70159_w = newvel.x;
                    this.field_70181_x = newvel.y;
                    this.field_70179_y = newvel.z;
                    if (l < 0.2) {
                        this.serverAttach(this.magnetblock, blockvec, EnumFacing.UP);
                    }
                }
                this.prevpos = pos;
            }
        }
    }

    public void setVelocityActually(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        if (this.shootingEntity == null) {
            return super.func_184177_bl();
        }
        AxisAlignedBB bb = this.segmenthandler.getBoundingBox(vec.positionvec((Entity)this), vec.positionvec(this.shootingEntity).add(new vec(0.0, this.shootingEntity.func_70047_e(), 0.0)));
        return bb;
    }

    public void func_70107_b(double x, double y, double z) {
        if (this.thispos != null) {
            x = this.thispos.x;
            y = this.thispos.y;
            z = this.thispos.z;
        }
        super.func_70107_b(x, y, z);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.shootingEntity != null ? this.shootingEntity.func_145782_y() : 0);
        data.writeBoolean(this.righthand);
        data.writeBoolean(this.isdouble);
        if (this.customization == null) {
            System.out.println("error: customization null");
        }
        this.customization.writeToBuf(data);
    }

    public void readSpawnData(ByteBuf data) {
        this.shootingEntityID = data.readInt();
        this.shootingEntity = this.field_70170_p.func_73045_a(this.shootingEntityID);
        this.righthand = data.readBoolean();
        this.isdouble = data.readBoolean();
        this.customization = new GrappleCustomization();
        this.customization.readFromBuf(data);
    }

    public void remove() {
        this.func_70106_y();
    }

    public String toString() {
        return super.toString() + String.valueOf(System.identityHashCode((Object)this)) + "]";
    }

    protected void func_70184_a(RayTraceResult movingobjectposition) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.attached) {
                return;
            }
            if (this.shootingEntityID != 0) {
                Block block;
                BlockPos blockpos;
                if (movingobjectposition == null) {
                    return;
                }
                Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
                if (movingobjectposition.field_72313_a == RayTraceResult.Type.ENTITY && !GrappleConfig.getconf().hookaffectsentities) {
                    this.func_70184_a(this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false));
                    return;
                }
                if (grapplemod.anyignoresblocks && movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && (blockpos = movingobjectposition.func_178782_a()) != null && grapplemod.grapplingignoresblocks.contains(block = this.field_70170_p.func_180495_p(blockpos).func_177230_c())) {
                    System.out.println("ignore block");
                    this.func_70184_a(this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false));
                    return;
                }
                if (grapplemod.anybreakblocks && movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && (blockpos = movingobjectposition.func_178782_a()) != null && grapplemod.grapplingbreaksblocks.contains(block = this.field_70170_p.func_180495_p(blockpos).func_177230_c())) {
                    this.field_70170_p.func_175655_b(blockpos, true);
                    System.out.println("break block");
                    this.func_70184_a(this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false));
                    return;
                }
                if (movingobjectposition.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity entityhit = movingobjectposition.field_72308_g;
                    if (entityhit == this.shootingEntity) {
                        return;
                    }
                    vec playerpos = vec.positionvec(this.shootingEntity);
                    vec entitypos = vec.positionvec(entityhit);
                    vec yank = playerpos.sub(entitypos).mult(0.4);
                    entityhit.func_70024_g(yank.x, Math.min(yank.y, 2.0), yank.z);
                    this.removeServer();
                    return;
                }
                if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
                    blockpos = movingobjectposition.func_178782_a();
                    vec vec3 = new vec(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
                    this.serverAttach(blockpos, vec3, movingobjectposition.field_178784_b);
                } else {
                    System.out.println("unknown impact?");
                }
            }
        }
    }

    public void serverAttach(BlockPos blockpos, vec pos, EnumFacing sideHit) {
        if (this.attached) {
            return;
        }
        this.attached = true;
        if (blockpos != null && !grapplemod.anyblocks) {
            Block block = this.field_70170_p.func_180495_p(blockpos).func_177230_c();
            if (!grapplemod.removeblocks && !grapplemod.grapplingblocks.contains(block) || grapplemod.removeblocks && grapplemod.grapplingblocks.contains(block)) {
                this.removeServer();
                return;
            }
        }
        vec vec3 = vec.positionvec((Entity)this);
        vec3.add_ip(vec.motionvec((Entity)this));
        if (pos != null) {
            vec3 = pos;
            this.func_70634_a(vec3.x, vec3.y, vec3.z);
        }
        if (sideHit == EnumFacing.DOWN) {
            this.field_70163_u -= 0.3;
        } else if (sideHit == EnumFacing.WEST) {
            this.field_70165_t -= 0.05;
        } else if (sideHit == EnumFacing.NORTH) {
            this.field_70161_v -= 0.05;
        } else if (sideHit == EnumFacing.SOUTH) {
            this.field_70161_v += 0.05;
        } else if (sideHit == EnumFacing.EAST) {
            this.field_70165_t += 0.05;
        } else if (sideHit == EnumFacing.UP) {
            this.field_70163_u += 0.05;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.thispos = vec.positionvec((Entity)this);
        this.firstattach = true;
        grapplemod.attached.add(this.shootingEntityID);
        grapplemod.sendtocorrectclient(new GrappleAttachMessage(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getControlId(), this.shootingEntityID, blockpos, this.segmenthandler.segments, this.segmenthandler.segmenttopsides, this.segmenthandler.segmentbottomsides, this.customization), this.shootingEntityID, this.field_70170_p);
        if (this.shootingEntity instanceof EntityPlayerMP) {
            EntityPlayerMP sender = (EntityPlayerMP)this.shootingEntity;
            int dimension = sender.field_71093_bK;
            MinecraftServer minecraftServer = sender.field_71133_b;
            for (EntityPlayerMP player : minecraftServer.func_184103_al().func_181057_v()) {
                GrappleAttachPosMessage msg = new GrappleAttachPosMessage(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (dimension != player.field_71093_bK) continue;
                grapplemod.sendtocorrectclient(msg, player.func_145782_y(), player.field_70170_p);
            }
        }
    }

    public void clientAttach(double x, double y, double z) {
        this.setAttachPos(x, y, z);
        if (this.shootingEntity instanceof EntityPlayer) {
            grapplemod.proxy.resetlaunchertime(this.shootingEntityID);
        }
    }

    protected float func_70185_h() {
        return (float)this.customization.hookgravity * 0.1f;
    }

    public float getVelocity() {
        return (float)this.customization.throwspeed;
    }

    public void removeServer() {
        this.func_70106_y();
        this.shootingEntityID = 0;
    }

    public int getControlId() {
        return grapplemod.GRAPPLEID;
    }

    public void setAttachPos(double x, double y, double z) {
        this.func_70634_a(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.firstattach = true;
        this.attached = true;
        this.thispos = new vec(x, y, z);
    }

    public BlockPos check(vec p, HashMap<BlockPos, Boolean> checkedset) {
        int radius = (int)Math.floor(this.customization.attractradius);
        BlockPos closestpos = null;
        double closestdist = 0.0;
        for (int x = (int)p.x - radius; x <= (int)p.x + radius; ++x) {
            for (int y = (int)p.y - radius; y <= (int)p.y + radius; ++y) {
                for (int z = (int)p.z - radius; z <= (int)p.z + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos == null || !this.hasblock(pos, checkedset)) continue;
                    vec distvec = new vec(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    distvec.sub_ip(p);
                    double dist = distvec.length();
                    if (closestpos != null && !(dist < closestdist)) continue;
                    closestpos = pos;
                    closestdist = dist;
                }
            }
        }
        return closestpos;
    }

    public boolean hasblock(BlockPos pos, HashMap<BlockPos, Boolean> checkedset) {
        if (!checkedset.containsKey(pos)) {
            AxisAlignedBB BB;
            boolean isblock = false;
            IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
            Block b = blockstate.func_177230_c();
            if (!(!grapplemod.anyblocks && (!grapplemod.removeblocks && !grapplemod.grapplingblocks.contains(b) || grapplemod.removeblocks && grapplemod.grapplingblocks.contains(b)) || b.isAir(blockstate, (IBlockAccess)this.field_70170_p, pos) || (BB = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, pos)) == null)) {
                isblock = true;
            }
            checkedset.put(pos, isblock);
            return isblock;
        }
        return checkedset.get(pos);
    }
}

