/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.GrappleCustomization;
import com.yyon.grapplinghook.controllers.SegmentHandler;
import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.vec;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GrappleAttachMessage
implements IMessage {
    public int id;
    public double x;
    public double y;
    public double z;
    public int controlid;
    public int entityid;
    public BlockPos blockpos;
    public LinkedList<vec> segments;
    public LinkedList<EnumFacing> segmenttopsides;
    public LinkedList<EnumFacing> segmentbottomsides;
    public GrappleCustomization custom;

    public GrappleAttachMessage() {
    }

    public GrappleAttachMessage(int id, double x, double y, double z, int controlid, int entityid, BlockPos blockpos, LinkedList<vec> segments, LinkedList<EnumFacing> segmenttopsides, LinkedList<EnumFacing> segmentbottomsides, GrappleCustomization custom) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.controlid = controlid;
        this.entityid = entityid;
        this.blockpos = blockpos;
        this.segments = segments;
        this.segmenttopsides = segmenttopsides;
        this.segmentbottomsides = segmentbottomsides;
        this.custom = custom;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.controlid = buf.readInt();
        this.entityid = buf.readInt();
        int blockx = buf.readInt();
        int blocky = buf.readInt();
        int blockz = buf.readInt();
        this.blockpos = new BlockPos(blockx, blocky, blockz);
        this.custom = new GrappleCustomization();
        this.custom.readFromBuf(buf);
        int size = buf.readInt();
        this.segments = new LinkedList();
        this.segmentbottomsides = new LinkedList();
        this.segmenttopsides = new LinkedList();
        this.segments.add(new vec(0.0, 0.0, 0.0));
        this.segmentbottomsides.add(null);
        this.segmenttopsides.add(null);
        for (int i = 1; i < size - 1; ++i) {
            this.segments.add(new vec(buf.readDouble(), buf.readDouble(), buf.readDouble()));
            this.segmentbottomsides.add(EnumFacing.func_82600_a((int)buf.readInt()));
            this.segmenttopsides.add(EnumFacing.func_82600_a((int)buf.readInt()));
        }
        this.segments.add(new vec(0.0, 0.0, 0.0));
        this.segmentbottomsides.add(null);
        this.segmenttopsides.add(null);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.controlid);
        buf.writeInt(this.entityid);
        buf.writeInt(this.blockpos.func_177958_n());
        buf.writeInt(this.blockpos.func_177956_o());
        buf.writeInt(this.blockpos.func_177952_p());
        this.custom.writeToBuf(buf);
        buf.writeInt(this.segments.size());
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            buf.writeDouble(this.segments.get((int)i).x);
            buf.writeDouble(this.segments.get((int)i).y);
            buf.writeDouble(this.segments.get((int)i).z);
            buf.writeInt(this.segmentbottomsides.get(i).func_176745_a());
            buf.writeInt(this.segmenttopsides.get(i).func_176745_a());
        }
    }

    public static class Handler
    implements IMessageHandler<GrappleAttachMessage, IMessage> {
        public IMessage onMessage(GrappleAttachMessage message, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a((Runnable)new runner(message, ctx));
            return null;
        }

        public class runner
        implements Runnable {
            GrappleAttachMessage message;
            MessageContext ctx;

            public runner(GrappleAttachMessage message, MessageContext ctx) {
                this.message = message;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Entity grapple = world.func_73045_a(this.message.id);
                if (grapple instanceof grappleArrow) {
                    ((grappleArrow)grapple).clientAttach(this.message.x, this.message.y, this.message.z);
                    SegmentHandler segmenthandler = ((grappleArrow)grapple).segmenthandler;
                    segmenthandler.segments = this.message.segments;
                    segmenthandler.segmentbottomsides = this.message.segmentbottomsides;
                    segmenthandler.segmenttopsides = this.message.segmenttopsides;
                    Entity player = world.func_73045_a(this.message.entityid);
                    segmenthandler.forceSetPos(new vec(this.message.x, this.message.y, this.message.z), vec.positionvec(player));
                }
                grapplemod.proxy.createControl(this.message.controlid, this.message.id, this.message.entityid, (World)world, new vec(this.message.x, this.message.y, this.message.z), this.message.blockpos, this.message.custom);
            }
        }
    }
}

