/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.LibLog;

public class Translations {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private Map<String, String> lookup = new Object2ObjectOpenHashMap();

    protected void merge(@Nonnull InputStream stream) throws IOException {
        FMLCommonHandler.instance().loadLanguage(this.lookup, stream);
    }

    private static List<String> getLanguageList(String ... lang) {
        ArrayList<String> result = new ArrayList<String>();
        if (lang != null && lang.length > 0) {
            for (String s : lang) {
                if (!result.contains(s)) continue;
                result.add(s);
            }
        } else {
            String mcLang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            result.add(DEFAULT_LANGUAGE);
            if (!result.contains(mcLang)) {
                result.add(mcLang);
            }
        }
        return result;
    }

    public void load(@Nonnull ResourceLocation loc) {
        String assetName = "/assets/" + loc.func_110624_b() + "/lang/" + loc.func_110623_a() + ".lang";
        try (InputStream stream = Translations.class.getResourceAsStream(assetName);){
            if (stream != null) {
                this.merge(stream);
            }
        }
        catch (Throwable t) {
            LibLog.log().error("Error merging language " + assetName, t);
        }
    }

    public void load(@Nonnull String assetRoot, String ... lang) {
        List<String> langList = Translations.getLanguageList(lang);
        for (String l : langList) {
            String assetName = StringUtils.appendIfMissing((String)assetRoot, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + l + ".lang";
            try {
                InputStream stream = Translations.class.getResourceAsStream(assetName);
                Throwable throwable = null;
                try {
                    if (stream == null) continue;
                    this.merge(stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Throwable t) {
                LibLog.log().error("Error merging language " + assetName, t);
            }
        }
    }

    @Nonnull
    public String format(@Nonnull String translateKey, Object ... parameters) {
        String xlated = this.lookup.get(translateKey);
        return xlated == null ? translateKey : String.format(xlated, parameters);
    }

    @Nonnull
    public String loadString(@Nonnull String translateKey) {
        String xlated = this.lookup.get(translateKey);
        return xlated == null ? translateKey : xlated;
    }

    public void put(@Nonnull String key, @Nonnull String value) {
        this.lookup.put(key, value);
    }

    public void forAll(@Nonnull Predicate<Map.Entry<String, String>> pred) {
        for (Map.Entry<String, String> e : this.lookup.entrySet()) {
            pred.apply(e);
        }
    }

    public void transform(@Nonnull Function<Map.Entry<String, String>, String> func) {
        Map<String, String> old = this.lookup;
        this.lookup = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, String> e : old.entrySet()) {
            this.lookup.put(e.getKey(), (String)func.apply(e));
        }
    }
}

