/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.BaseContainerScreen;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.container.BaseContainer;
import com.lycanitesmobs.core.container.CreatureContainer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import com.lycanitesmobs.core.network.MessageEntityGUICommand;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class CreatureInventoryScreen
extends BaseContainerScreen {
    public BaseCreatureEntity creature;
    public InventoryCreature creatureInventory;
    public InventoryPlayer playerInventory;

    public CreatureInventoryScreen(BaseCreatureEntity creature, InventoryPlayer playerInventory) {
        super(new CreatureContainer(creature, playerInventory));
        this.creature = creature;
        this.creatureInventory = creature.inventory;
        this.playerInventory = playerInventory;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        int backX = (this.field_146294_l - this.field_146999_f) / 2;
        int backY = (this.field_146295_m - this.field_147000_g) / 2;
        this.drawControls(backX, backY);
    }

    protected void func_146979_b(int i, int j) {
        if (this.creature == null || !this.creature.func_70089_S()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.field_146289_q.func_78276_b(this.creatureInventory.func_70005_c_(), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(LanguageManager.translate(this.playerInventory.func_70005_c_()), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.drawBars(0, 0);
    }

    protected void drawBars(int backX, int backY) {
        int barWidth = 100;
        int barHeight = 11;
        int barX = backX - barWidth;
        int barY = backY + 54 + 18;
        int barCenter = barX + barWidth / 2;
        this.drawTexture(AssetManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
        float healthNormal = Math.min(1.0f, this.creature.func_110143_aJ() / this.creature.func_110138_aP());
        this.drawTexture(AssetManager.getTexture("GUIPetBarHealth"), barX, barY, 0.0f, healthNormal, 1.0f, (float)barWidth * healthNormal, barHeight);
        String healthText = LanguageManager.translate("entity.health") + ": " + String.format("%.0f", Float.valueOf(this.creature.func_110143_aJ())) + "/" + String.format("%.0f", Float.valueOf(this.creature.func_110138_aP()));
        this.field_146289_q.func_78276_b(healthText, barCenter - this.field_146289_q.func_78256_a(healthText) / 2, barY + 2, 0xFFFFFF);
        this.drawTexture(AssetManager.getTexture("GUIPetBarEmpty"), barX, barY += barHeight + 1, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
        float experienceNormal = Math.min(1.0f, (float)this.creature.getExperience() / (float)this.creature.creatureStats.getExperienceForNextLevel());
        this.drawTexture(AssetManager.getTexture("GUIBarExperience"), barX, barY, 0.0f, experienceNormal, 1.0f, (float)barWidth * experienceNormal, barHeight);
        String experienceText = LanguageManager.translate("entity.experience") + ": " + this.creature.getExperience() + "/" + this.creature.creatureStats.getExperienceForNextLevel();
        this.field_146289_q.func_78276_b(experienceText, barCenter - this.field_146289_q.func_78256_a(experienceText) / 2, barY + 2, 0xFFFFFF);
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        int backX = (this.field_146294_l - this.field_146999_f) / 2;
        int backY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(backX, backY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFrames(backX, backY, i, j);
        this.drawSlots(backX, backY);
    }

    protected void drawFrames(int backX, int backY, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        int statusWidth = 90;
        int statusHeight = 54;
        this.func_73729_b(backX + 79, backY + 17, 0, 256 - statusHeight, statusWidth, statusHeight);
        int creatureWidth = 54;
        int creatureHeight = 54;
        this.func_73729_b(backX - creatureWidth + 1, backY + 17, statusWidth, 256 - creatureHeight, creatureWidth, creatureHeight);
        GuiInventory.func_147046_a((int)(backX + 26 - creatureWidth + 1), (int)(backY + 60), (int)17, (float)((float)backX - (float)mouseX), (float)((float)backY - (float)mouseY), (EntityLivingBase)this.creature);
    }

    protected void drawSlots(int backX, int backY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        BaseContainer container = (BaseContainer)this.field_147002_h;
        List creatureSlots = container.field_75151_b.subList(container.specialStart, container.inventoryFinish + 1);
        int slotWidth = 18;
        int slotHeight = 18;
        int slotU = 238;
        int slotVBase = 0;
        for (Slot creatureSlot : creatureSlots) {
            int slotX = backX + creatureSlot.field_75223_e - 1;
            int slotY = backY + creatureSlot.field_75221_f - 1;
            int slotV = slotVBase;
            String slotType = this.creatureInventory.getTypeFromSlot(creatureSlot.getSlotIndex());
            if (slotType != null) {
                if (slotType.equals("saddle")) {
                    slotV += slotHeight;
                } else if (slotType.equals("bag")) {
                    slotV += slotHeight * 2;
                } else if (slotType.equals("chest")) {
                    slotV += slotHeight * 3;
                }
            }
            this.func_73729_b(slotX, slotY, slotU, slotV, slotWidth, slotHeight);
        }
    }

    protected void drawControls(int backX, int backY) {
        if (!(this.creature instanceof TameableCreatureEntity)) {
            return;
        }
        TameableCreatureEntity pet = (TameableCreatureEntity)this.creature;
        if (!pet.petControlsEnabled()) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = 128;
        int buttonHeight = 20;
        int buttonX = backX + this.field_146999_f;
        int buttonY = backY;
        String buttonText = LanguageManager.translate("gui.pet.follow");
        GuiButton button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id, buttonX + buttonSpacing, buttonY += buttonSpacing, buttonWidth, buttonHeight, buttonText);
        if (pet.isFollowing() && !pet.isSitting()) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.wander");
        button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.WANDER.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText);
        if (!pet.isFollowing() && !pet.isSitting()) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.sit");
        button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.SIT.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText);
        if (!pet.isFollowing() && pet.isSitting()) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.passive");
        button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText);
        if (pet.isPassive()) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.defensive");
        button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText);
        if (!(pet.isPassive() || pet.isAssisting() || pet.isAggressive())) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.assist");
        button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText);
        if (!pet.isPassive() && pet.isAssisting() && !pet.isAggressive()) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.aggressive");
        button = new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText);
        if (!pet.isPassive() && pet.isAggressive()) {
            button.field_146124_l = false;
        }
        this.field_146292_n.add(button);
        buttonText = LanguageManager.translate("gui.pet.pvp") + ": " + (pet.isPVP() ? LanguageManager.translate("common.yes") : LanguageManager.translate("common.no"));
        this.field_146292_n.add(new GuiButton((int)BaseCreatureEntity.PET_COMMAND_ID.PVP.id, buttonX + buttonSpacing, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, buttonText));
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (guiButton != null) {
            MessageEntityGUICommand message = new MessageEntityGUICommand((byte)guiButton.field_146127_k, (Entity)this.creature);
            LycanitesMobs.packetHandler.sendToServer(message);
        }
        super.func_146284_a(guiButton);
    }
}

