/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.block.BlockBase;
import com.lycanitesmobs.core.info.ModInfo;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFireBase
extends BlockBase {
    public static final PropertyBool PERMANENT = PropertyBool.func_177716_a((String)"permanent");
    public static final PropertyBool STATIC = PropertyBool.func_177716_a((String)"static");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"up");
    public boolean dieInRain = true;
    public boolean triggerTNT = true;
    public boolean tickRandomly = true;
    public int agingRate = 3;
    public float spreadChance = 1.0f;
    public boolean removeOnNoFireTick = false;

    public BlockFireBase(Material material, ModInfo group, String name) {
        super(material, group, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)PERMANENT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)STATIC, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
        this.removeOnTick = false;
        this.removeOnNoFireTick = false;
        this.loopTicks = true;
        this.canBeCrushed = true;
        this.noEntityCollision = true;
        this.noBreakCollision = false;
        this.isOpaque = false;
        this.tickRate = 30;
        this.func_149713_g(1);
        this.func_149675_a(this.tickRandomly);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149649_H();
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, PERMANENT, STATIC, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    @Override
    public String func_149732_F() {
        return LanguageManager.translate(this.func_149739_a() + ".name");
    }

    @Override
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(this.getDescription(stack, world));
    }

    @Override
    public String getDescription(ItemStack itemStack, World world) {
        return "\u00a7a" + LanguageManager.translate(this.func_149739_a() + ".description");
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP) && !Blocks.field_150480_ab.canCatchFire(worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177976_e(), EnumFacing.EAST))).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177984_a(), EnumFacing.DOWN))).func_177226_a((IProperty)PERMANENT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)STATIC, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Override
    public int func_149738_a(World world) {
        return this.tickRate;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState blockState, Random rand) {
        if (((Boolean)blockState.func_177229_b((IProperty)STATIC)).booleanValue() || !world.func_175697_a(pos, 2)) {
            return;
        }
        boolean permanent = (Boolean)blockState.func_177229_b((IProperty)PERMANENT);
        if (!world.func_82736_K().func_82766_b("doFireTick")) {
            if (this.removeOnNoFireTick && !permanent) {
                world.func_175698_g(pos);
            }
            return;
        }
        if (!this.func_176196_c(world, pos) || this.removeOnTick) {
            world.func_175698_g(pos);
        }
        Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        boolean isOnFireSource = permanent || this.isBlockFireSource(blockBelow, world, pos.func_177977_b(), EnumFacing.UP);
        int age = (Integer)blockState.func_177229_b((IProperty)AGE);
        if (!isOnFireSource && this.canDie(world, pos) && rand.nextFloat() < 0.2f + (float)age * 0.03f) {
            world.func_175698_g(pos);
            return;
        }
        if (age < 15) {
            blockState = blockState.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.max(age + Math.round((float)rand.nextInt(this.agingRate) / 2.0f), 15)));
            world.func_180501_a(pos, blockState, 4);
        }
        if (this.loopTicks) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world) + rand.nextInt(10));
        }
        if (!isOnFireSource) {
            if (!this.canNeighborCatchFire(world, pos)) {
                if (age > 3) {
                    world.func_175698_g(pos);
                }
                return;
            }
            if (!this.canCatchFire((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && age == 15 && rand.nextInt(4) == 0) {
                world.func_175698_g(pos);
                return;
            }
        }
        if (this.spreadChance <= 0.0f || permanent) {
            return;
        }
        boolean highHumidity = world.func_180502_D(pos);
        int humidityChance = 0;
        if (highHumidity) {
            humidityChance = -50;
        }
        this.tryCatchFire(world, pos.func_177974_f(), 300 + humidityChance, rand, age, EnumFacing.WEST);
        this.tryCatchFire(world, pos.func_177976_e(), 300 + humidityChance, rand, age, EnumFacing.EAST);
        this.tryCatchFire(world, pos.func_177977_b(), 250 + humidityChance, rand, age, EnumFacing.UP);
        this.tryCatchFire(world, pos.func_177984_a(), 250 + humidityChance, rand, age, EnumFacing.DOWN);
        this.tryCatchFire(world, pos.func_177978_c(), 300 + humidityChance, rand, age, EnumFacing.SOUTH);
        this.tryCatchFire(world, pos.func_177968_d(), 300 + humidityChance, rand, age, EnumFacing.NORTH);
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 4; ++offsetY) {
                    BlockPos spreadPos;
                    int spreadEncouragement;
                    if (offsetX == 0 && offsetY == 0 && offsetZ == 0) continue;
                    int chance = 100;
                    if (offsetY > 1) {
                        chance += (offsetY - 1) * 100;
                    }
                    if ((spreadEncouragement = this.getNeighborEncouragement(world, spreadPos = pos.func_177982_a(offsetX, offsetY, offsetZ))) <= 0) continue;
                    int spreadFlammability = (spreadEncouragement + 40 + world.func_175659_aa().func_151525_a() * 7) / (age + 30);
                    if (highHumidity) {
                        spreadFlammability /= 2;
                    }
                    if (spreadFlammability <= 0 || rand.nextInt(chance) > spreadFlammability || world.func_72896_J() && this.canDie(world, spreadPos)) continue;
                    int spreadAge = age + rand.nextInt(5) / 4;
                    if (spreadAge > 15) {
                        spreadAge = 15;
                    }
                    world.func_180501_a(spreadPos, blockState.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(spreadAge)).func_177226_a((IProperty)PERMANENT, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
    }

    public boolean func_149698_L() {
        return !this.tickRandomly;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        try {
            return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || this.canNeighborCatchFire(world, pos);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos triggerPos) {
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
    }

    protected boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    protected int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFlammability((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int flammability = this.getBlockFlammability((IBlockAccess)world, pos, face);
        if (Math.round((float)random.nextInt(chance) / this.spreadChance) < flammability) {
            IBlockState blockState = world.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !world.func_175727_C(pos)) {
                int newFireAge = age + random.nextInt(5) / 4;
                if (newFireAge > 15) {
                    newFireAge = 15;
                }
                this.burnBlockReplace(world, pos, newFireAge);
            } else {
                this.burnBlockDestroy(world, pos);
            }
            if (this.triggerTNT && blockState.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(world, pos, blockState.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public void burnBlockReplace(World world, BlockPos pos, int newFireAge) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(newFireAge)), 3);
    }

    public void burnBlockDestroy(World world, BlockPos pos) {
        world.func_175698_g(pos);
    }

    public boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, face);
    }

    public boolean isBlockFireSource(Block block, World world, BlockPos pos, EnumFacing side) {
        return block.isFireSource(world, pos, side);
    }

    public int getBlockFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().getFlammability(world, pos, face);
    }

    protected boolean canDie(World world, BlockPos pos) {
        return world.func_175727_C(pos) || world.func_175727_C(pos.func_177976_e()) || world.func_175727_C(pos.func_177974_f()) || world.func_175727_C(pos.func_177978_c()) || world.func_175727_C(pos.func_177968_d());
    }

    @Override
    public int func_149745_a(Random random) {
        return 0;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(this.func_180660_a(state, null, 0), 1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

