/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block.fluid;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.block.BlockFluidBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidOoze
extends BlockFluidBase {
    public BlockFluidOoze(Fluid fluid, String name) {
        super(fluid, Material.field_151586_h, LycanitesMobs.modInfo, name);
        this.func_149713_g(0);
        this.func_149715_a(0.25f);
        this.destroyItems = false;
    }

    @Override
    public String func_149732_F() {
        return LanguageManager.translate(this.func_149739_a() + ".name");
    }

    @Override
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(this.getDescription(stack, world));
    }

    @Override
    public String getDescription(ItemStack itemStack, World world) {
        return LanguageManager.translate(this.func_149739_a() + ".description");
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState == null || blockState.func_177230_c() == this) {
            return false;
        }
        if (blockState.func_185904_a() == Material.field_151586_h) {
            if (world instanceof World) {
                ((World)world).func_175656_a(pos, Blocks.field_150403_cj.func_176223_P());
            }
            return false;
        }
        if (blockState.func_185904_a() == Material.field_151587_i) {
            if (world instanceof World) {
                ((World)world).func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
            }
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return this.canDisplace((IBlockAccess)world, pos);
        }
        return super.displaceIfPossible(world, pos);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity != null) {
            if (!(entity instanceof EntityItem) && !(entity instanceof EntityXPOrb)) {
                entity.func_70097_a(ObjectManager.getDamageSource("ooze"), 1.0f);
            }
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
            }
        }
        super.func_180634_a(world, pos, state, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState blockState, World world, BlockPos pos, Random random) {
        if (random.nextInt(100) == 0) {
            float f = (float)pos.func_177958_n() + random.nextFloat();
            float f1 = (float)pos.func_177956_o() + random.nextFloat() * 0.5f;
            float f2 = (float)pos.func_177952_p() + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        super.func_180655_c(blockState, world, pos, random);
    }
}

