/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindParentGoal;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ItemDrop;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.item.ItemCustomSpawnEgg;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public abstract class AgeableCreatureEntity
extends BaseCreatureEntity {
    private float scaledWidth = -1.0f;
    private float scaledHeight;
    private AgeableCreatureEntity breedingTarget;
    public int growthTime = -24000;
    public boolean canGrow = true;
    public double babySpawnChance = 0.0;
    public int loveTime;
    private int loveTimeMax = 600;
    public int breedingCooldown = 6000;
    public boolean hasBeenFarmed = false;
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LOVE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public AgeableCreatureEntity(World world) {
        super(world);
    }

    @Override
    public void setupMob() {
        if (this.babySpawnChance > 0.0 && this.field_70146_Z.nextDouble() < this.babySpawnChance) {
            this.setGrowingAge(this.growthTime);
        }
        super.setupMob();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(LOVE, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new MateGoal(this).setMateDistance(5.0));
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindParentGoal(this).setSightCheck(false).setDistance(32.0));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new FollowParentGoal(this).setSpeed(1.0).setStrayDistance(3.0));
    }

    @Override
    public String getAgeName() {
        if (this.func_70631_g_()) {
            return LanguageManager.translate("entity.baby");
        }
        return "";
    }

    @Override
    public boolean isPersistant() {
        if (this.hasBeenFarmed) {
            return true;
        }
        return super.isPersistant();
    }

    public void setFarmed() {
        this.hasBeenFarmed = true;
        if (this.field_71088_bW > this.func_82147_ab()) {
            this.field_71088_bW = this.func_82147_ab();
        }
    }

    @Override
    public void getRandomSubspecies() {
        if (this.func_70631_g_()) {
            return;
        }
        super.getRandomSubspecies();
    }

    @Override
    public void getRandomVariant() {
        if (this.func_70631_g_()) {
            return;
        }
        super.getRandomVariant();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            this.setScaleForAge(this.func_70631_g_());
        } else if (this.canGrow) {
            int age = this.getGrowingAge();
            if (age < 0) {
                this.setGrowingAge(++age);
            } else if (age > 0) {
                this.setGrowingAge(--age);
            }
        }
        if (!this.canBreed()) {
            this.loveTime = 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(LOVE, (Object)this.loveTime);
        }
        if (this.func_130014_f_().field_72995_K) {
            this.loveTime = this.getIntFromDataManager(LOVE);
        }
        if (this.isInLove()) {
            this.setFarmed();
            --this.loveTime;
            if (this.func_130014_f_().field_72995_K) {
                EnumParticleTypes particle = EnumParticleTypes.HEART;
                if (this.loveTime % 10 == 0) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (!this.canBreed()) {
            this.loveTime = 0;
        }
        super.func_70619_bc();
    }

    @Override
    public boolean canDropItem(ItemDrop itemDrop) {
        if (itemDrop.adultOnly && this.func_70631_g_()) {
            return false;
        }
        return super.canDropItem(itemDrop);
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (itemStack != null) {
            if (itemStack.func_77973_b() == this.creatureInfo.creatureType.getSpawnEgg()) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Spawn Baby");
            }
            if (this.isBreedingItem(itemStack) && this.canBreed() && !this.isInLove()) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Breed");
            }
        }
        return commands;
    }

    @Override
    public boolean performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("Spawn Baby") && !this.func_130014_f_().field_72995_K) {
            AgeableCreatureEntity baby;
            ItemCustomSpawnEgg itemCustomSpawnEgg = (ItemCustomSpawnEgg)itemStack.func_77973_b();
            CreatureInfo spawnEggCreatureInfo = itemCustomSpawnEgg.getCreatureInfo(itemStack);
            if (spawnEggCreatureInfo != null && spawnEggCreatureInfo.entityClass != null && spawnEggCreatureInfo.entityClass.isAssignableFrom(((Object)((Object)this)).getClass()) && (baby = this.createChild(this)) != null) {
                baby.setGrowingAge(baby.growthTime);
                baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                baby.setFarmed();
                this.func_130014_f_().func_72838_d((Entity)baby);
                if (itemStack.func_82837_s()) {
                    baby.func_96094_a(itemStack.func_82833_r());
                }
                this.consumePlayersItem(player, itemStack);
            }
            return true;
        }
        if (command.equals("Breed") && this.breed()) {
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        return super.performCommand(command, player, itemStack);
    }

    public int getGrowingAge() {
        return this.getIntFromDataManager(AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
        this.setScaleForAge(this.func_70631_g_());
    }

    public void addGrowth(int growth) {
        int age = this.getGrowingAge();
        if ((age += growth * 20) > 0) {
            age = 0;
        }
        this.setGrowingAge(age);
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public boolean shouldFollowParent() {
        return this.func_70631_g_();
    }

    public boolean shouldFindParent() {
        return this.func_70631_g_();
    }

    public void setScaleForAge(boolean age) {
        this.setAgeScale(age ? 0.5f : 1.0f);
    }

    protected final void setAgeScale(float age) {
        super.func_70105_a(this.scaledWidth * age, this.scaledHeight * age);
    }

    @Override
    protected void func_70105_a(float width, float height) {
        boolean validWidth = this.scaledWidth > 0.0f;
        this.scaledWidth = width;
        this.scaledHeight = height;
        if (!validWidth) {
            this.setAgeScale(1.0f);
        }
        super.func_70105_a(width, height);
    }

    @Override
    public void updateSize() {
        this.func_70105_a(this.setWidth, this.setHeight);
        this.setScaleForAge(this.func_70631_g_());
    }

    @Override
    public boolean canBeTempted() {
        return !this.isInLove() && super.canBeTempted();
    }

    public AgeableCreatureEntity getBreedingTarget() {
        return this.breedingTarget;
    }

    public void setBreedingTarget(AgeableCreatureEntity target) {
        this.breedingTarget = target;
    }

    public AgeableCreatureEntity createChild(AgeableCreatureEntity partener) {
        return (AgeableCreatureEntity)this.creatureInfo.createEntity(this.func_130014_f_());
    }

    public boolean isBreedingItem(ItemStack itemStack) {
        if (!this.creatureInfo.isFarmable() || this.func_70086_ai() <= -100) {
            return false;
        }
        return this.creatureInfo.canEat(itemStack);
    }

    public boolean canBreedWith(AgeableCreatureEntity partner) {
        if (partner == this) {
            return false;
        }
        if (((Object)((Object)partner)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (this.getSubspecies() != partner.getSubspecies()) {
            return false;
        }
        return this.isInLove() && partner.isInLove();
    }

    public boolean isInLove() {
        return this.loveTime > 0;
    }

    public boolean canMate() {
        return this.isInLove();
    }

    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.loveTime = this.loveTimeMax;
        return true;
    }

    public boolean canBreed() {
        return this.getGrowingAge() == 0;
    }

    public void procreate(AgeableCreatureEntity partner) {
        AgeableCreatureEntity baby = this.createChild(partner);
        if (baby != null) {
            this.finishBreeding();
            partner.finishBreeding();
            baby.setGrowingAge(baby.growthTime);
            baby.setSubspecies(this.getSubspeciesIndex());
            Variant babyVariant = this.getSubspecies().getChildVariant((EntityLivingBase)this, this.getVariant(), partner.getVariant());
            baby.applyVariant(babyVariant != null ? babyVariant.index : 0);
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
            this.onCreateBaby(partner, baby);
            this.func_130014_f_().func_72838_d((Entity)baby);
            for (EntityPlayer player2 : this.func_130014_f_().func_175661_b(EntityPlayer.class, player -> player != null && this.func_70032_d((Entity)player) <= 5.0f)) {
                ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(player2);
                if (extendedPlayer == null) continue;
                extendedPlayer.studyCreature((Entity)this, CreatureManager.getInstance().config.creatureBreedKnowledge, false, true);
            }
        }
    }

    public void onCreateBaby(AgeableCreatureEntity partner, AgeableCreatureEntity baby) {
    }

    public void finishBreeding() {
        this.setGrowingAge(this.breedingCooldown);
        this.setBreedingTarget(null);
        this.loveTime = 0;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Age")) {
            this.setGrowingAge(nbtTagCompound.func_74762_e("Age"));
        } else {
            this.setGrowingAge(0);
        }
        this.loveTime = nbtTagCompound.func_74764_b("InLove") ? nbtTagCompound.func_74762_e("InLove") : 0;
        if (nbtTagCompound.func_74764_b("HasBeenFarmed") && nbtTagCompound.func_74767_n("HasBeenFarmed")) {
            this.setFarmed();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Age", this.getGrowingAge());
        nbtTagCompound.func_74768_a("InLove", this.loveTime);
        nbtTagCompound.func_74757_a("HasBeenFarmed", this.hasBeenFarmed);
    }
}

