/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IFusable;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.Targeting;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.container.CreatureContainer;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CreatureBuildTask;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import com.lycanitesmobs.core.entity.CreatureRelationships;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.entity.EntityHitArea;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.damagesources.MinionEntityDamageSource;
import com.lycanitesmobs.core.entity.goals.actions.AvoidGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowFuseGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowMasterGoal;
import com.lycanitesmobs.core.entity.goals.actions.LookIdleGoal;
import com.lycanitesmobs.core.entity.goals.actions.MoveRestrictionGoal;
import com.lycanitesmobs.core.entity.goals.actions.PaddleGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayByWaterGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import com.lycanitesmobs.core.entity.goals.actions.WanderGoal;
import com.lycanitesmobs.core.entity.goals.actions.WatchClosestGoal;
import com.lycanitesmobs.core.entity.goals.targeting.AvoidIfHitGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindFuseTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindGroupAttackTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindGroupAvoidTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeGoal;
import com.lycanitesmobs.core.entity.navigate.CreatureMoveHelper;
import com.lycanitesmobs.core.entity.navigate.CreaturePathNavigate;
import com.lycanitesmobs.core.entity.navigate.DirectNavigator;
import com.lycanitesmobs.core.entity.navigate.ICreatureNodeProcessor;
import com.lycanitesmobs.core.info.CreatureGroup;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ExtraMobBehaviour;
import com.lycanitesmobs.core.info.ItemDrop;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.inventory.InventoryCreature;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.network.MessageCreature;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.spawner.SpawnerEventListener;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BaseCreatureEntity
extends EntityLiving {
    public static Boolean ENABLE_HITAREAS = false;
    public static final IAttribute DEFENSE = new RangedAttribute(null, "generic.defense", 4.0, 0.0, 1024.0).func_111112_a(true);
    public static final IAttribute RANGED_SPEED = new RangedAttribute(null, "generic.rangedSpeed", 4.0, 0.0, 1024.0).func_111112_a(true);
    public CreatureInfo creatureInfo;
    public CreatureStats creatureStats;
    public Subspecies subspecies = null;
    public Variant variant = null;
    public EnumCreatureAttribute attribute = EnumCreatureAttribute.UNDEAD;
    public CreatureRelationships relationships;
    public ExtraMobBehaviour extraMobBehaviour;
    public long updateTick = 0L;
    protected boolean syncQueued = true;
    public String spawnEventType = "";
    public int spawnEventCount = -1;
    public PetEntry petEntry;
    public boolean altarSummoned = false;
    public int spawnedWithBlockProtection = 0;
    public boolean forceBossHealthBar = false;
    public TileEntitySummoningPedestal summoningPedestal;
    public float setWidth;
    public float setDepth;
    public float setHeight;
    public double sizeScale = 1.0;
    public EntityHitArea[][][] hitAreas;
    public float hitAreaWidthScale = 1.0f;
    public float hitAreaHeightScale = 1.0f;
    public int attackTime = 20;
    protected int level = 1;
    protected int experience = 0;
    public byte attackPhase = 0;
    public byte attackPhaseMax = 0;
    public int fleeTime = 200;
    public int currentFleeTime = 0;
    public float fleeHealthPercent = 0.0f;
    public int battlePhase = 0;
    public int damageMax = 0;
    public float damageLimit = 0.0f;
    protected int growingAge;
    public static int BOSS_DAMAGE_LIMIT = 50;
    public float damageTakenThisSec = 0.0f;
    public float healthLastTick = -1.0f;
    public int bossRange = 60;
    public boolean isAggressiveByDefault = true;
    public boolean spreadFire = false;
    public boolean stealthPrev = false;
    public int currentBlockingTime = 0;
    public int blockingTime = 60;
    public EntityLivingBase pickupEntity;
    public boolean solidCollision = false;
    protected BlockPos homePosition = new BlockPos(0, 0, 0);
    protected float homeDistanceMax = -1.0f;
    protected BlockPos arenaCenter = null;
    public int nextPriorityGoalIndex;
    public int nextDistractionGoalIndex;
    public int nextCombatGoalIndex;
    public int nextTravelGoalIndex;
    public int nextIdleGoalIndex;
    public int nextReactTargetIndex;
    public int nextSpecialTargetIndex;
    public int nextFindTargetIndex;
    public boolean firstSpawn = true;
    public boolean needsInitialLevel = true;
    public boolean spawnsInBlock = false;
    public boolean spawnsUnderground = true;
    public boolean spawnsOnLand = true;
    public boolean spawnsInWater = false;
    public boolean isLavaCreature = false;
    public boolean isMinion = false;
    public boolean isTemporary = false;
    public int temporaryDuration = 0;
    public boolean forceNoDespawn = false;
    public boolean spawnedRare = false;
    public boolean spawnedAsBoss = false;
    private boolean leashAIActive = false;
    private EntityAIBase leashMoveTowardsRestrictionAI = new MoveRestrictionGoal(this);
    public DirectNavigator directNavigator;
    protected List<Class<? extends Entity>> hostileTargetClasses = new ArrayList<Class<? extends Entity>>();
    private EntityLivingBase masterTarget;
    private EntityLivingBase parentTarget;
    private EntityLivingBase avoidTarget;
    private EntityLivingBase fixateTarget;
    private UUID fixateUUID = null;
    private EntityLivingBase perchTarget;
    public List<EntityPlayer> playerTargets = new ArrayList<EntityPlayer>();
    public List<EntityLivingBase> minions = new ArrayList<EntityLivingBase>();
    public List<EntityPlayer> guiViewers = new ArrayList<EntityPlayer>();
    public int guiRefreshTick = 0;
    public int guiRefreshTime = 2;
    protected int attackCooldownMax = 5;
    private int attackCooldown = 0;
    public boolean hasAttackSound = false;
    public boolean hasStepSound = true;
    public boolean hasJumpSound = false;
    public int flySoundSpeed = 0;
    public boolean extraAnimation01 = false;
    public BossInfoServer bossInfo;
    public float onlyRenderTicks = -1.0f;
    public boolean initialized = false;
    protected static final DataParameter<Byte> TARGET = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ATTACK_PHASE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ANIMATION_STATE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Integer> ANIMATION_ATTACK_COOLDOWN_MAX = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> STEALTH = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> BABY = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> EXPERIENCE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> SUBSPECIES = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<BlockPos>> ARENA = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187201_k);
    public static final DataParameter<ItemStack> EQUIPMENT_HEAD = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_CHEST = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_LEGS = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_FEET = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_BAG = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<ItemStack> EQUIPMENT_SADDLE = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187196_f);
    public InventoryCreature inventory;
    public List<ItemDrop> drops = new ArrayList<ItemDrop>();
    public List<ItemDrop> savedDrops = new ArrayList<ItemDrop>();
    protected boolean dropsRequirePlayerDamage = false;
    public FindAttackTargetGoal aiTargetPlayer = null;
    public RevengeGoal aiDefendAnimals = null;

    public BaseCreatureEntity(World world) {
        super(world);
        this.setWidth = (float)this.creatureInfo.width;
        this.setDepth = (float)this.creatureInfo.width;
        this.setHeight = (float)this.creatureInfo.height;
        this.field_70130_N = this.setWidth;
        this.field_70131_O = this.setHeight;
        this.field_70765_h = this.createMoveHelper();
        if (!this.canBurn()) {
            this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
            if (this.func_70648_aU()) {
                this.func_184644_a(PathNodeType.LAVA, 8.0f);
                if (!this.canBreatheAir() || this.isLavaCreature) {
                    this.func_184644_a(PathNodeType.LAVA, 0.0f);
                }
            }
        }
        if (this.waterDamage()) {
            this.func_184644_a(PathNodeType.WATER, -1.0f);
        } else if (this.func_70648_aU()) {
            this.func_184644_a(PathNodeType.WATER, 8.0f);
            if (!this.canBreatheAir()) {
                this.func_184644_a(PathNodeType.WATER, 0.0f);
            }
        }
        if (this.canWade() && this.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround groundNavigator = (PathNavigateGround)this.func_70661_as();
            groundNavigator.func_179693_d(true);
        }
    }

    protected void func_110147_ax() {
        this.loadCreatureFlags();
        this.creatureStats = new CreatureStats(this);
        this.relationships = new CreatureRelationships(this);
        this.extraMobBehaviour = new ExtraMobBehaviour(this);
        this.directNavigator = new DirectNavigator(this);
        this.nextPriorityGoalIndex = 10;
        this.nextDistractionGoalIndex = 30;
        this.nextCombatGoalIndex = 50;
        this.nextTravelGoalIndex = 70;
        this.nextIdleGoalIndex = 90;
        this.nextReactTargetIndex = 10;
        this.nextSpecialTargetIndex = 30;
        this.nextFindTargetIndex = 50;
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(DEFENSE);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(RANGED_SPEED);
        this.applyDynamicAttributes();
    }

    public void applyDynamicAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.creatureStats.getHealth());
        this.func_110148_a(DEFENSE).func_111128_a(this.creatureStats.getDefense());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.creatureStats.getArmor());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.creatureStats.getSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.creatureStats.getKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.creatureStats.getSight());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.creatureStats.getDamage());
        this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111128_a(this.creatureStats.getAttackSpeed());
        this.func_110148_a(RANGED_SPEED).func_111128_a(this.creatureStats.getRangedSpeed());
    }

    public void refreshAttributes() {
        this.applyDynamicAttributes();
        this.func_70606_j(this.func_110138_aP());
        this.refreshBossHealthName();
    }

    public void loadCreatureFlags() {
    }

    protected void func_184651_r() {
        if (this instanceof IFusable) {
            this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (EntityAIBase)new FindFuseTargetGoal(this));
        }
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new AvoidIfHitGoal(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new RevengeGoal(this).setHelpCall(true).setCheckSight(true));
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new PaddleGoal(this));
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new StayByWaterGoal(this));
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new AvoidGoal(this).setNearSpeed(1.3).setFarSpeed(1.2).setNearDistance(5.0).setFarDistance(20.0));
        if (this.creatureInfo.isTameable()) {
            this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (EntityAIBase)new TemptGoal(this).setTemptDistanceMin(4.0));
        }
        if (this instanceof IFusable) {
            this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (EntityAIBase)new FollowFuseGoal(this).setLostDistance(16.0));
        }
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindGroupAttackTargetGoal(this));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindGroupAvoidTargetGoal(this).setTameTargetting(false));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new FollowMasterGoal(this).setStrayDistance(12.0));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new WanderGoal(this));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new WatchClosestGoal(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new LookIdleGoal(this));
    }

    public void setupMob() {
        this.setWidth = (float)((double)this.setWidth * this.creatureInfo.hitboxScale);
        this.setHeight = (float)((double)this.setHeight * this.creatureInfo.hitboxScale);
        this.updateSize();
        this.field_70138_W = 0.5f;
        this.field_70728_aV = this.creatureInfo.experience;
        this.inventory = new InventoryCreature(this.func_70005_c_(), this);
        this.loadItemDrops();
        if (ItemEquipmentPart.MOB_PART_DROPS.containsKey(this.creatureInfo.getEntityId())) {
            for (ItemEquipmentPart itemEquipmentPart : ItemEquipmentPart.MOB_PART_DROPS.get(this.creatureInfo.getEntityId())) {
                ItemDrop partDrop = new ItemDrop(itemEquipmentPart.getRegistryName().toString(), 0, itemEquipmentPart.dropChance).setMaxAmount(1);
                partDrop.bonusAmount = false;
                partDrop.amountMultiplier = false;
                this.drops.add(partDrop);
            }
        }
        this.field_70178_ae = !this.canBurn();
        this.setAttackCooldownMax(this.attackCooldownMax);
    }

    public void loadItemDrops() {
        this.drops.addAll(this.creatureInfo.drops);
        this.drops.addAll(CreatureManager.getInstance().config.getGlobalDrops());
    }

    public void addSavedItemDrop(ItemDrop itemDrop) {
        this.drops.add(itemDrop);
        this.savedDrops.add(itemDrop);
    }

    protected void func_70088_a() {
        this.creatureInfo = CreatureManager.getInstance().getCreature(((Object)((Object)this)).getClass());
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_PHASE, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION_STATE, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION_ATTACK_COOLDOWN_MAX, (Object)0);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(STEALTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(EXPERIENCE, (Object)0);
        this.field_70180_af.func_187214_a(SUBSPECIES, (Object)0);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ARENA, (Object)Optional.absent());
        InventoryCreature.registerDataParameters(this.field_70180_af);
        this.initialized = true;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getFullName();
    }

    public String getFullName() {
        String nameFormatting = LanguageManager.translate("entity.lycanitesmobs.creature.name.format");
        String[] nameParts = nameFormatting.split("\\|");
        if (nameParts.length < 4 || nameFormatting.equals("entity.lycanitesmobs.creature.name.format")) {
            nameParts = new String[]{"age", "variant", "subspecies", "species", "level"};
        }
        StringBuilder name = new StringBuilder();
        ArrayList<String> nameComponents = new ArrayList<String>();
        String[] stringArray = nameParts;
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String namePart;
            switch (namePart = stringArray[i]) {
                case "age": {
                    nameComponents.add(this.getAgeName());
                    continue block14;
                }
                case "variant": {
                    nameComponents.add(this.getVariantName());
                    continue block14;
                }
                case "subspecies": {
                    nameComponents.add(this.getSubspeciesName());
                    continue block14;
                }
                case "species": {
                    nameComponents.add(this.getSpeciesName());
                    continue block14;
                }
                case "level": {
                    nameComponents.add(this.getLevelName());
                }
            }
        }
        boolean first = true;
        for (String nameComponent : nameComponents) {
            if (nameComponent.isEmpty()) continue;
            if (!first) {
                name.append(" ");
            }
            first = false;
            name.append(nameComponent);
        }
        return name.toString();
    }

    public String getAgeName() {
        return "";
    }

    public String getSpeciesName() {
        return this.creatureInfo.getTitle();
    }

    public String getVariantName() {
        if (this.getVariant() != null) {
            return this.getVariant().getTitle();
        }
        return "";
    }

    public String getSubspeciesName() {
        if (this.getSubspecies() != null) {
            return this.getSubspecies().getTitle();
        }
        return "";
    }

    public String getLevelName() {
        if (this.getLevel() < 2) {
            return "";
        }
        return " " + LanguageManager.translate("entity.level") + " " + this.getLevel();
    }

    public void queueSync() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        this.syncQueued = true;
    }

    public void doSync() {
        this.syncQueued = false;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        for (EntityPlayer player : this.relationships.getPlayers()) {
            CreatureRelationshipEntry relationshipEntry = this.relationships.getEntry((Entity)player);
            if (relationshipEntry == null) continue;
            MessageCreature message = new MessageCreature(this, relationshipEntry.reputation);
            LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)player);
        }
    }

    public boolean getBoolFromDataManager(DataParameter<Boolean> key) {
        try {
            return (Boolean)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte getByteFromDataManager(DataParameter<Byte> key) {
        try {
            return (Byte)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getIntFromDataManager(DataParameter<Integer> key) {
        try {
            return (Integer)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public float getFloatFromDataManager(DataParameter<Float> key) {
        try {
            return ((Float)this.func_184212_Q().func_187225_a(key)).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getStringFromDataManager(DataParameter<String> key) {
        try {
            return (String)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Optional<UUID> getUUIDFromDataManager(DataParameter<Optional<UUID>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack getItemStackFromDataManager(DataParameter<ItemStack> key) {
        try {
            return (ItemStack)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return ItemStack.field_190927_a;
        }
    }

    public Optional<BlockPos> getBlockPosFromDataManager(DataParameter<Optional<BlockPos>> key) {
        try {
            return (Optional)this.func_184212_Q().func_187225_a(key);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public boolean func_70601_bi() {
        return this.checkSpawnVanilla(this.func_130014_f_(), this.func_180425_c());
    }

    public int func_70641_bl() {
        return this.creatureInfo.creatureSpawn.spawnGroupMax;
    }

    public boolean checkSpawnVanilla(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", " ~O==================== Vanilla Spawn Check: " + this.creatureInfo.getName() + " ====================O~");
        LycanitesMobs.logDebug("MobSpawns", "Attempting to Spawn: " + this.creatureInfo.getName());
        LycanitesMobs.logDebug("MobSpawns", "Target Spawn Location: " + pos);
        LycanitesMobs.logDebug("MobSpawns", "Checking if creature is enabled...");
        if (!this.creatureInfo.enabled || !this.creatureInfo.creatureSpawn.enabled) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for peaceful difficulty...");
        if (!this.creatureInfo.peaceful && this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking gamerules...");
        if (!this.func_130014_f_().func_82736_K().func_82766_b("doMobSpawning")) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Fixed spawn check (light level, collisions)...");
        if (!this.fixedSpawnCheck(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for nearby Mob Spawner...");
        if (this.isSpawnerNearby(world, pos)) {
            LycanitesMobs.logDebug("MobSpawns", "Mob Spawner found, skipping other checks.");
            LycanitesMobs.logDebug("MobSpawns", "Vanilla Spawn Check Passed!");
            return true;
        }
        LycanitesMobs.logDebug("MobSpawns", "No Mob Spawner found.");
        LycanitesMobs.logDebug("MobSpawns", "Global Spawn Check (Master Dimension List, etc)...");
        if (!CreatureManager.getInstance().spawnConfig.isAllowedGlobal(world)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Environment spawn check (dimension, group limit, ground type, water, lava, underground)...");
        if (!this.environmentSpawnCheck(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Vanilla Spawn Check Passed!");
        return true;
    }

    public boolean fixedSpawnCheck(World world, BlockPos pos) {
        if (!this.checkSpawnLightLevel(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking collision...");
        if (!this.checkSpawnCollision(world, pos)) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Counting mobs of the same kind, max allowed is: " + this.creatureInfo.creatureSpawn.spawnAreaLimit);
        return this.checkSpawnGroupLimit(world, pos, CreatureManager.getInstance().spawnConfig.spawnLimitRange);
    }

    public boolean environmentSpawnCheck(World world, BlockPos pos) {
        if (this.creatureInfo.creatureSpawn.worldDayMin > 0.0) {
            int currentDay = (int)Math.floor((double)world.func_82737_E() / 24000.0);
            LycanitesMobs.logDebug("MobSpawns", "Checking world age, currently on day: " + currentDay + ", must be at least day: " + this.creatureInfo.creatureSpawn.worldDayMin + ".");
            if ((double)currentDay < this.creatureInfo.creatureSpawn.worldDayMin) {
                return false;
            }
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking dimension.");
        if (!this.isNativeDimension(this.func_130014_f_())) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Block preference.");
        if (this.getBlockPathWeight(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 0.0f) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for liquid (water, lava, ooze, etc).");
        if (!this.spawnsInWater && this.func_130014_f_().func_72953_d(this.func_174813_aQ())) {
            return false;
        }
        if (!this.spawnsOnLand && !this.func_130014_f_().func_72953_d(this.func_174813_aQ())) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for underground.");
        if (!this.spawnsUnderground && this.isBlockUnderground(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())) {
            return false;
        }
        LycanitesMobs.logDebug("MobSpawns", "Checking for nearby bosses.");
        return this.checkSpawnBoss(world, pos);
    }

    public boolean isNativeDimension(World world) {
        return this.creatureInfo.creatureSpawn.isAllowedDimension(world);
    }

    public boolean checkSpawnCollision(World world, BlockPos pos) {
        return this.spawnsInBlock || this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean checkSpawnLightLevel(World world, BlockPos pos) {
        if (this.creatureInfo.creatureSpawn.spawnsInDark && this.creatureInfo.creatureSpawn.spawnsInLight) {
            return true;
        }
        if (!this.creatureInfo.creatureSpawn.spawnsInDark && !this.creatureInfo.creatureSpawn.spawnsInLight) {
            return false;
        }
        byte light = this.testLightLevel(pos);
        if (this.creatureInfo.creatureSpawn.spawnsInDark && light <= 1) {
            return true;
        }
        return this.creatureInfo.creatureSpawn.spawnsInLight && light >= 2;
    }

    public boolean checkSpawnGroupLimit(World world, BlockPos pos, double range) {
        if (range <= 0.0) {
            return true;
        }
        int typesLimit = CreatureManager.getInstance().spawnConfig.typeSpawnLimit;
        int speciesLimit = this.creatureInfo.creatureSpawn.spawnAreaLimit;
        if (typesLimit <= 0 && speciesLimit <= 0) {
            return true;
        }
        List<BaseCreatureEntity> targets = this.getNearbyEntities(BaseCreatureEntity.class, (Predicate<Entity>)((Predicate)entity -> BaseCreatureEntity.class.isAssignableFrom(entity.getClass())), range);
        int typesFound = 0;
        int speciesFound = 0;
        for (BaseCreatureEntity targetCreature : targets) {
            if (targetCreature.creatureInfo.peaceful == this.creatureInfo.peaceful) {
                ++typesFound;
            }
            if (!this.creatureInfo.entityClass.isAssignableFrom(((Object)((Object)targetCreature)).getClass())) continue;
            ++speciesFound;
        }
        if (range > 0.0) {
            if (typesLimit > 0 && typesFound >= typesLimit) {
                return false;
            }
            if (speciesLimit > 0 && speciesFound >= speciesLimit) {
                return false;
            }
        }
        return true;
    }

    public boolean checkSpawnBoss(World world, BlockPos pos) {
        List<BaseCreatureEntity> bosses = this.getNearbyEntities(BaseCreatureEntity.class, (Predicate<Entity>)((Predicate)entity -> IGroupBoss.class.isAssignableFrom(entity.getClass())), CreatureManager.getInstance().spawnConfig.spawnLimitRange);
        return bosses.size() == 0;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        livingData = super.func_180482_a(difficulty, livingData);
        return livingData;
    }

    protected boolean func_70692_ba() {
        if (this.creatureInfo.creatureSpawn.despawnForced) {
            return true;
        }
        if (!this.creatureInfo.creatureSpawn.despawnNatural) {
            return false;
        }
        if (this.creatureInfo.boss || this.isRareVariant() && !Variant.RARE_DESPAWNING) {
            return false;
        }
        if (this.isPersistant() || this.func_110167_bD() || this.func_145818_k_() && "".equals(this.spawnEventType)) {
            return false;
        }
        return super.func_70692_ba();
    }

    public boolean isPersistant() {
        return this.forceNoDespawn;
    }

    public void func_110163_bv() {
        super.func_110163_bv();
        this.forceNoDespawn = true;
    }

    public boolean despawnCheck() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (!this.creatureInfo.enabled) {
            return true;
        }
        if (this.isTemporary && this.temporaryDuration-- <= 0) {
            return true;
        }
        if (!this.creatureInfo.peaceful && this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL && !this.func_145818_k_()) {
            return true;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(this.func_130014_f_());
        if (worldExt != null && !"".equals(this.spawnEventType) && this.spawnEventCount >= 0 && this.spawnEventCount != worldExt.getWorldEventCount()) {
            if (this.func_110167_bD() || this.isPersistant()) {
                this.spawnEventType = "";
                this.spawnEventCount = -1;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSpawnerNearby(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (world == null) {
            return false;
        }
        int checkRange = 8;
        for (int i = x - checkRange; i <= x + checkRange; ++i) {
            for (int j = y - checkRange; j <= y + checkRange; ++j) {
                for (int k = z - checkRange; k <= z + checkRange; ++k) {
                    TileEntity tileEntity;
                    IBlockState spawnerBlock = world.func_180495_p(new BlockPos(i, j, k));
                    if (spawnerBlock == null || (tileEntity = world.func_175625_s(new BlockPos(i, j, k))) == null || !(tileEntity instanceof TileEntityMobSpawner)) continue;
                    try {
                        String mobSpawnEntityId;
                        NBTTagCompound spawnData;
                        TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)tileEntity;
                        NBTTagCompound nbt = new NBTTagCompound();
                        mobSpawner.func_145881_a().func_189530_b(nbt);
                        if (!nbt.func_74764_b("SpawnData") || !(spawnData = nbt.func_74775_l("SpawnData")).func_74764_b("id") || !(mobSpawnEntityId = spawnData.func_74779_i("id")).equalsIgnoreCase(this.creatureInfo.getEntityId())) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    public boolean isBlockUnderground(int x, int y, int z) {
        if (this.func_130014_f_().func_175710_j(new BlockPos(x, y, z))) {
            return false;
        }
        for (int j = y; j < this.func_130014_f_().func_72800_K(); ++j) {
            Material blockMaterial = this.func_130014_f_().func_180495_p(new BlockPos(x, j, z)).func_185904_a();
            if (blockMaterial == Material.field_151579_a || blockMaterial == Material.field_151584_j || blockMaterial == Material.field_151585_k || blockMaterial == Material.field_151577_b || blockMaterial == Material.field_151582_l) continue;
            return true;
        }
        return false;
    }

    public boolean isBoss() {
        return this.isBossAlways() || this.spawnedAsBoss;
    }

    public boolean isBossAlways() {
        return this.creatureInfo.boss;
    }

    public boolean func_184222_aU() {
        return !this.isBoss();
    }

    public void createBossInfo(BossInfo.Color color, boolean darkenSky) {
        String name = this.func_70005_c_();
        if (this.isBossAlways()) {
            name = name + " (" + LanguageManager.translate("entity.phase") + " " + (this.getBattlePhase() + 1) + ")";
        }
        this.bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentString(name), color, BossInfo.Overlay.PROGRESS).func_186741_a(darkenSky);
    }

    public BossInfo getBossInfo() {
        if (this.bossInfo == null && this.showBossInfo() && !this.func_130014_f_().field_72995_K) {
            if (this.isBoss()) {
                this.createBossInfo(BossInfo.Color.RED, false);
            } else {
                this.createBossInfo(BossInfo.Color.GREEN, false);
            }
        }
        return this.bossInfo;
    }

    public void refreshBossHealthName() {
        if (this.bossInfo != null) {
            String name = this.getFullName();
            if (this.isBossAlways()) {
                name = name + " (" + LanguageManager.translate("entity.phase") + " " + (this.getBattlePhase() + 1) + ")";
            }
            this.bossInfo.func_186739_a((ITextComponent)new TextComponentString(name));
        }
    }

    public void summonMinion(EntityLivingBase minion, double angle, double distance) {
        double angleRadians = Math.toRadians(angle);
        double x = this.field_70165_t + (((double)this.field_70130_N + distance) * Math.cos(angleRadians) - Math.sin(angleRadians));
        double y = this.field_70163_u + 1.0;
        if (minion instanceof BaseCreatureEntity && ((BaseCreatureEntity)minion).isCurrentlyFlying()) {
            y += (double)(this.field_70131_O / 2.0f);
        }
        double z = this.field_70161_v + (((double)this.field_70130_N + distance) * Math.sin(angleRadians) + Math.cos(angleRadians));
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (minion instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)minion).setMinion(true);
            if (!this.isRareVariant()) {
                ((BaseCreatureEntity)minion).applyVariant(this.getVariantIndex());
            }
            ((BaseCreatureEntity)minion).setSubspecies(this.getSubspeciesIndex());
            ((BaseCreatureEntity)minion).setMasterTarget((EntityLivingBase)this);
            ((BaseCreatureEntity)minion).spawnEventType = this.spawnEventType;
            if (this.isTemporary) {
                ((BaseCreatureEntity)minion).setTemporary(this.temporaryDuration);
            }
            ((BaseCreatureEntity)minion).onFirstSpawn();
        }
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
        this.addMinion(minion);
    }

    public boolean addMinion(EntityLivingBase minion) {
        if (this.minions.contains(minion)) {
            return false;
        }
        this.minions.add(minion);
        return true;
    }

    public List<EntityLivingBase> getMinions(Class<? extends Entity> filterClass) {
        if (filterClass == null) {
            return this.minions;
        }
        ArrayList<EntityLivingBase> filteredMinions = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase minion : this.minions) {
            if (!filterClass.isAssignableFrom(minion.getClass())) continue;
            filteredMinions.add(minion);
        }
        return filteredMinions;
    }

    public void onMinionUpdate(EntityLivingBase minion, long tick) {
    }

    public void onMinionDeath(EntityLivingBase minion, DamageSource damageSource) {
    }

    public void onTryToDamageMinion(EntityLivingBase minion, float damageAmount) {
    }

    public void setMinion(boolean minion) {
        this.isMinion = minion;
    }

    public boolean isMinion() {
        return this.isMinion;
    }

    public void setTemporary(int duration) {
        this.temporaryDuration = duration;
        this.isTemporary = true;
    }

    public void unsetTemporary() {
        this.isTemporary = false;
        this.temporaryDuration = 0;
    }

    public boolean isBoundPet() {
        return this.hasPetEntry();
    }

    public boolean hasPetEntry() {
        return this.getPetEntry() != null;
    }

    public PetEntry getPetEntry() {
        return this.petEntry;
    }

    public void setPetEntry(PetEntry petEntry) {
        this.petEntry = petEntry;
    }

    public boolean isPetType(String type) {
        if (!this.hasPetEntry()) {
            return false;
        }
        return type.equals(this.getPetEntry().getType());
    }

    public void onFirstSpawn() {
        this.firstSpawn = false;
        if (this.hasPetEntry()) {
            if (this.getPetEntry().summonSet != null && this.getPetEntry().summonSet.playerExt != null) {
                this.getPetEntry().summonSet.playerExt.sendPetEntryToPlayer(this.getPetEntry());
            }
            return;
        }
        if (this.isMinion()) {
            return;
        }
        if (this.needsInitialLevel) {
            this.applyLevel(this.getStartingLevel());
        }
        if (this.getSubspeciesIndex() == 0 && this.getVariantIndex() == 0) {
            this.getRandomSubspecies();
            if (CreatureManager.getInstance().config.variantSpawn && !this.creatureInfo.creatureSpawn.disableVariants) {
                this.getRandomVariant();
            }
        }
        if (this.sizeScale == 1.0 && CreatureManager.getInstance().config.randomSizes) {
            this.getRandomSize();
        }
    }

    public void getRandomSubspecies() {
        if (!this.isMinion()) {
            Subspecies randomSubspecies = this.creatureInfo.getRandomSubspecies((EntityLivingBase)this);
            this.setSubspecies(randomSubspecies.index);
            LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " subspecies to " + randomSubspecies.getTitle());
        }
    }

    public void getRandomVariant() {
        if (!this.isMinion()) {
            Variant randomVariant = this.getSubspecies().getRandomVariant((EntityLivingBase)this, this.spawnedRare);
            if (randomVariant != null) {
                LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " variant to " + randomVariant.getTitle());
                this.applyVariant(randomVariant.index);
            } else {
                LycanitesMobs.logDebug("Subspecies", "Setting " + this.getSpeciesName() + " variant to base variant.");
                this.applyVariant(0);
            }
        }
    }

    public void getRandomSize() {
        double range = CreatureManager.getInstance().config.randomSizeMax - CreatureManager.getInstance().config.randomSizeMin;
        double randomScale = range * this.func_70681_au().nextDouble();
        double scale = CreatureManager.getInstance().config.randomSizeMin + randomScale;
        if (this.getVariant() != null) {
            scale *= this.getVariant().getScale();
        }
        this.setSizeScale(scale);
    }

    public int getAge() {
        if (this.field_70170_p.field_72995_K) {
            return this.getBoolFromDataManager(BABY) ? -1 : 1;
        }
        return this.growingAge;
    }

    public int getLevel() {
        if (this.func_130014_f_().field_72995_K) {
            return this.getIntFromDataManager(LEVEL);
        }
        return this.level;
    }

    public int getStartingLevel() {
        int startingLevelMin = Math.max(1, CreatureManager.getInstance().config.startingLevelMin);
        if (CreatureManager.getInstance().config.startingLevelMax > startingLevelMin) {
            return startingLevelMin + this.func_70681_au().nextInt(CreatureManager.getInstance().config.startingLevelMax - startingLevelMin);
        }
        if (CreatureManager.getInstance().config.levelPerDay > 0.0 && CreatureManager.getInstance().config.levelPerDayMax > 0) {
            int day = (int)Math.floor((double)this.func_130014_f_().func_82737_E() / 23999.0);
            double levelGain = Math.min(CreatureManager.getInstance().config.levelPerDay * (double)day, (double)CreatureManager.getInstance().config.levelPerDayMax);
            startingLevelMin += (int)Math.floor(levelGain);
        }
        if (CreatureManager.getInstance().config.levelPerLocalDifficulty > 0.0) {
            double levelGain = this.func_130014_f_().func_175649_E(this.func_180425_c()).func_180168_b();
            startingLevelMin += Math.max(0, (int)Math.floor(levelGain - 1.5));
        }
        return startingLevelMin;
    }

    public void applyLevel(int level) {
        this.needsInitialLevel = false;
        this.setLevel(level);
        this.refreshAttributes();
    }

    public void setLevel(int level) {
        this.level = level;
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public void addLevel(int level) {
        this.applyLevel(this.level + level);
    }

    public void updateLevelExperience() {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(EXPERIENCE, (Object)this.experience);
        }
        if (this.getExperience() >= this.creatureStats.getExperienceForNextLevel()) {
            this.setExperience(this.getExperience() - this.creatureStats.getExperienceForNextLevel());
            this.addLevel(1);
        }
    }

    public int getExperience() {
        if (this.func_130014_f_().field_72995_K) {
            return this.getIntFromDataManager(EXPERIENCE);
        }
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
        this.updateLevelExperience();
    }

    public void addExperience(int experience) {
        this.experience += experience;
        this.updateLevelExperience();
    }

    public int getMeleeCooldown() {
        return Math.round((float)(1.0 / this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0));
    }

    public int getRangedCooldown() {
        return Math.round((float)(1.0 / this.func_110148_a(RANGED_SPEED).func_111126_e() * 20.0));
    }

    public int getEffectDuration(int seconds) {
        return Math.round((float)seconds * (float)this.creatureStats.getEffect() * 20.0f);
    }

    public int getEffectAmplifier(float scale) {
        return Math.round((float)this.creatureStats.getAmplifier());
    }

    public int getEffectStrength(float value) {
        return Math.round(value * (float)this.creatureStats.getAmplifier());
    }

    public List<ElementInfo> getElements() {
        if (this.getSubspecies() != null && !this.getSubspecies().elements.isEmpty()) {
            return this.getSubspecies().elements;
        }
        return this.creatureInfo.elements;
    }

    public boolean hasElement(ElementInfo element) {
        return this.getElements().contains(element);
    }

    public void setSubspecies(int subspeciesIndex) {
        this.subspecies = this.creatureInfo.getSubspecies(subspeciesIndex);
    }

    public void setVariant(int variantIndex) {
        this.variant = this.getSubspecies().getVariant(variantIndex);
        if (this.variant != null) {
            float scaledExp = this.creatureInfo.experience;
            if ("uncommon".equals(this.variant.rarity)) {
                scaledExp = Math.round((float)((double)this.creatureInfo.experience * Variant.UNCOMMON_EXPERIENCE_SCALE));
            } else if ("rare".equals(this.variant.rarity)) {
                scaledExp = Math.round((float)((double)this.creatureInfo.experience * Variant.RARE_EXPERIENCE_SCALE));
            }
            this.field_70728_aV = Math.round(scaledExp);
            if ("rare".equals(this.variant.rarity)) {
                this.damageLimit = BOSS_DAMAGE_LIMIT;
                this.damageMax = BOSS_DAMAGE_LIMIT;
            }
        }
    }

    public void applyVariant(int variantIndex) {
        this.setVariant(variantIndex);
        this.refreshAttributes();
    }

    public Subspecies getSubspecies() {
        if (this.subspecies == null) {
            this.subspecies = this.creatureInfo.getSubspecies(0);
        }
        return this.subspecies;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public int getSubspeciesIndex() {
        return this.getSubspecies().index;
    }

    public int getVariantIndex() {
        return this.getVariant() != null ? this.getVariant().index : 0;
    }

    public boolean isRareVariant() {
        return this.getVariant() != null && "rare".equals(this.getVariant().rarity);
    }

    public int scaleKnowledgeExperience(int knowledgeExperience) {
        if (this.isBoss()) {
            knowledgeExperience = Math.round((float)CreatureManager.getInstance().config.creatureBossKnowledgeScale * (float)knowledgeExperience);
        } else if (this.getVariant() != null) {
            knowledgeExperience = Math.round((float)CreatureManager.getInstance().config.creatureVariantKnowledgeScale * (float)knowledgeExperience);
        }
        return knowledgeExperience;
    }

    public void updateBattlePhase() {
    }

    public int getBattlePhase() {
        return this.battlePhase;
    }

    public void setBattlePhase(int phase) {
        if (this.getBattlePhase() == phase) {
            return;
        }
        this.battlePhase = phase;
        this.refreshBossHealthName();
        this.playPhaseSound();
    }

    public EntityLivingBase transform(Class transformClass, Entity partner, boolean destroyPartner) {
        EntityLivingBase transformedEntity = null;
        try {
            transformedEntity = (EntityLivingBase)transformClass.getConstructor(World.class).newInstance(this.func_130014_f_());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (transformedEntity == null) {
            return null;
        }
        if (transformedEntity instanceof BaseCreatureEntity) {
            BaseCreatureEntity transformedCreature = (BaseCreatureEntity)transformedEntity;
            transformedCreature.firstSpawn = false;
            if (this.isTemporary) {
                transformedCreature.setTemporary(this.temporaryDuration);
            }
            if (this.isMinion()) {
                transformedCreature.setMinion(true);
            }
            if (this.hasMaster()) {
                transformedCreature.setMasterTarget(this.getMasterTarget());
            }
            if (partner instanceof BaseCreatureEntity) {
                BaseCreatureEntity partnerCreature = (BaseCreatureEntity)partner;
                Variant fusionVariant = transformedCreature.getSubspecies().getChildVariant((EntityLivingBase)this, this.getVariant(), partnerCreature.getVariant());
                transformedCreature.setSubspecies(this.getSubspeciesIndex());
                transformedCreature.applyVariant(fusionVariant != null ? fusionVariant.index : 0);
                transformedCreature.setSizeScale(this.sizeScale + partnerCreature.sizeScale);
                if (partnerCreature.summoningPedestal != null) {
                    partnerCreature.summoningPedestal.minions.add(transformedCreature);
                    transformedCreature.summoningPedestal = partnerCreature.summoningPedestal;
                }
                if (this.summoningPedestal != null) {
                    this.summoningPedestal.minions.add(transformedCreature);
                    transformedCreature.summoningPedestal = this.summoningPedestal;
                }
                int transformedLevel = this.getLevel();
                if ("lowest".equalsIgnoreCase(CreatureManager.getInstance().config.elementalFusionLevelMix)) {
                    if (transformedLevel > partnerCreature.getLevel()) {
                        transformedLevel = partnerCreature.getLevel();
                    }
                } else if ("highest".equalsIgnoreCase(CreatureManager.getInstance().config.elementalFusionLevelMix)) {
                    if (transformedLevel < partnerCreature.getLevel()) {
                        transformedLevel = partnerCreature.getLevel();
                    }
                } else {
                    transformedLevel += partnerCreature.getLevel();
                }
                transformedCreature.applyLevel(Math.round((float)transformedLevel * (float)CreatureManager.getInstance().config.elementalFusionLevelMultiplier));
                if (transformedCreature instanceof TameableCreatureEntity) {
                    TameableCreatureEntity fusionTameable = (TameableCreatureEntity)transformedCreature;
                    if (this instanceof TameableCreatureEntity) {
                        EntityPlayer owner = ((TameableCreatureEntity)this).getPlayerOwner();
                        if (owner != null) {
                            transformedCreature.applyLevel(transformedLevel);
                            fusionTameable.setPlayerOwner(owner);
                            ((TameableCreatureEntity)this).copyPetBehaviourTo(fusionTameable);
                        }
                    } else {
                        EntityPlayer partnerOwner = null;
                        if (partnerCreature instanceof TameableCreatureEntity && (partnerOwner = ((TameableCreatureEntity)partnerCreature).getPlayerOwner()) != null) {
                            transformedCreature.applyLevel(transformedLevel);
                            fusionTameable.setPlayerOwner(partnerOwner);
                            ((TameableCreatureEntity)partnerCreature).copyPetBehaviourTo(fusionTameable);
                            if (partnerCreature.isTemporary) {
                                transformedCreature.setTemporary(partnerCreature.temporaryDuration);
                            }
                            transformedCreature.setMinion(partnerCreature.isMinion());
                            if (partnerCreature.hasMaster()) {
                                transformedCreature.setMasterTarget(partnerCreature.getMasterTarget());
                            }
                        }
                    }
                }
            } else {
                transformedCreature.setSubspecies(this.getSubspeciesIndex());
                transformedCreature.applyVariant(this.getVariantIndex());
                transformedCreature.setSizeScale(this.sizeScale);
                transformedCreature.applyLevel(this.getLevel());
                if (transformedCreature instanceof TameableCreatureEntity) {
                    TameableCreatureEntity fusionTameable = (TameableCreatureEntity)transformedCreature;
                    if (this.getOwner() != null && this.getOwner() instanceof EntityPlayer) {
                        fusionTameable.setPlayerOwner((EntityPlayer)this.getOwner());
                        if (this instanceof TameableCreatureEntity) {
                            ((TameableCreatureEntity)this).copyPetBehaviourTo(fusionTameable);
                        }
                    }
                }
            }
        }
        transformedEntity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        this.func_130014_f_().func_72838_d((Entity)transformedEntity);
        this.func_70106_y();
        if (partner != null && destroyPartner) {
            partner.func_70106_y();
        }
        return transformedEntity;
    }

    public void func_70071_h_() {
        EntityLivingBase perchTarget;
        super.func_70071_h_();
        if (this.creatureInfo.dummy) {
            return;
        }
        this.onSyncUpdate();
        if (!this.func_130014_f_().field_72995_K) {
            this.updateHitAreas();
        }
        if (this.despawnCheck()) {
            if (!this.isBoundPet() || this.isTemporary) {
                this.inventory.dropInventory();
            }
            this.func_70106_y();
        }
        boolean bl = this.field_70178_ae = !this.canBurn();
        if (!this.canWalk() && !this.isCurrentlyFlying() && !this.func_70090_H() && this.isMoving() || !this.canMove()) {
            this.clearMovement();
        }
        if (!this.func_130014_f_().field_72995_K || this.func_184186_bw()) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (!this.field_70122_E && this.flySoundSpeed > 0 && this.field_70173_aa % 20 == 0) {
                this.playFlySound();
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isFlying() && this.hasAttackTarget() && this.updateTick % 40L == 0L) {
            this.leap(0.0, 0.4);
        }
        if ((perchTarget = this.getPerchTarget()) != null) {
            ExtendedPlayer perchPlayerExt;
            ExtendedEntity perchEntityExt = ExtendedEntity.getForEntity(this.getPerchTarget());
            if (perchEntityExt != null) {
                Vec3d perchPosition = perchEntityExt.getPerchPosition();
                this.func_70107_b(perchPosition.field_72450_a, perchPosition.field_72448_b, perchPosition.field_72449_c);
                this.field_70159_w = perchTarget.field_70159_w;
                this.field_70181_x = perchTarget.field_70181_x;
                this.field_70179_y = perchTarget.field_70179_y;
                this.field_70177_z = perchTarget.field_70177_z;
            }
            if (perchTarget instanceof EntityPlayer && !perchTarget.func_184218_aH() && (perchPlayerExt = ExtendedPlayer.getForPlayer((EntityPlayer)perchTarget)).isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_DISMOUNT)) {
                this.perchOnEntity(null);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isBoss() && this.updateTick % 20L == 0L && this.playerTargets.isEmpty()) {
            this.func_70691_i(1.0f);
        }
        if (this.bossInfo != null) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L) {
            for (EntityPlayer player2 : this.func_130014_f_().func_175661_b(EntityPlayer.class, player -> player != null && this.func_70032_d((Entity)player) <= 5.0f)) {
                CreatureKnowledge creatureKnowledge;
                ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(player2);
                if (extendedPlayer == null || (creatureKnowledge = extendedPlayer.getBeastiary().getCreatureKnowledge(this.creatureInfo.getName())) != null && creatureKnowledge.rank >= 1) continue;
                extendedPlayer.studyCreature((Entity)this, CreatureManager.getInstance().config.creatureProximityKnowledge, false, false);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.guiViewers.size() <= 0) {
            this.guiRefreshTick = 0;
        }
        if (!this.func_130014_f_().field_72995_K && this.guiRefreshTick > 0 && --this.guiRefreshTick <= 0) {
            this.refreshGUIViewers();
            this.guiRefreshTick = 0;
        }
    }

    protected void func_70619_bc() {
        if (this.useDirectNavigator()) {
            this.directNavigator.updateFlight();
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        float brightness;
        if (this.damageLimit > 0.0f) {
            if (this.healthLastTick < 0.0f) {
                this.healthLastTick = this.func_110143_aJ();
            }
            if (this.healthLastTick - this.func_110143_aJ() > this.damageLimit) {
                this.func_70606_j(this.healthLastTick - this.damageLimit);
            }
            this.healthLastTick = this.func_110143_aJ();
            if (!this.func_130014_f_().field_72995_K && this.updateTick % 20L == 0L) {
                this.damageTakenThisSec = 0.0f;
            }
        }
        super.func_70636_d();
        if (this.creatureInfo.dummy) {
            ++this.updateTick;
            return;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            if (this.attackCooldown > this.getAttackCooldownMax()) {
                this.triggerAttackCooldown();
            }
        }
        this.updateBattlePhase();
        this.func_82168_bl();
        if (this.currentBlockingTime > 0) {
            --this.currentBlockingTime;
        }
        if (this.currentBlockingTime < 0) {
            this.currentBlockingTime = 0;
        }
        if (!this.func_130014_f_().field_72995_K && this.firstSpawn) {
            this.onFirstSpawn();
        }
        if (!this.func_130014_f_().field_72995_K && !this.hasFixateTarget() && this.fixateUUID != null) {
            double range = 64.0;
            List connections = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(range, range, range));
            for (EntityLivingBase possibleFixateTarget : connections) {
                if (possibleFixateTarget == this || !possibleFixateTarget.func_110124_au().equals(this.fixateUUID)) continue;
                this.setFixateTarget(possibleFixateTarget);
                break;
            }
            this.fixateUUID = null;
        }
        if (this.hasFixateTarget()) {
            this.func_70624_b(this.getFixateTarget());
        }
        if (this.hasAttackTarget() && this.func_70638_az() instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)this.func_70638_az();
            if (targetPlayer.field_71075_bZ.field_75098_d) {
                this.func_70624_b(null);
            }
        }
        if (this.hasAvoidTarget() && this.currentFleeTime-- <= 0) {
            this.setAvoidTarget(null);
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= this.getFallingMod();
        }
        if (!this.func_130014_f_().field_72995_K && this.daylightBurns() && this.func_130014_f_().func_72935_r() && (brightness = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f && this.func_130014_f_().func_175710_j(this.func_180425_c())) {
            boolean shouldBurn = true;
            ItemStack helmet = this.inventory.getEquipmentStack("head");
            if (!helmet.func_190926_b()) {
                if (helmet.func_77984_f()) {
                    helmet.func_77964_b(helmet.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (helmet.func_77952_i() >= helmet.func_77958_k()) {
                        this.func_70669_a(helmet);
                        this.setCurrentItemOrArmor(4, ItemStack.field_190927_a);
                    }
                }
                shouldBurn = false;
            }
            if (shouldBurn) {
                this.func_70015_d(8);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.waterDamage() && this.func_70026_G() && !this.func_180799_ab()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.func_130014_f_().field_72995_K && !this.canBreatheAir()) {
            int currentAir = this.func_70086_ai();
            if (this.func_70089_S()) {
                if (!this.isLavaCreature && !this.waterContact() || this.isLavaCreature && !this.lavaContact()) {
                    this.func_70050_g(--currentAir);
                    if (this.func_70086_ai() <= -200) {
                        this.func_70050_g(-180);
                        this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    }
                } else {
                    this.func_70050_g(299);
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            float light = this.func_70013_c();
            if (!this.creatureInfo.creatureSpawn.spawnsInLight && light > 0.5f) {
                this.field_70708_bq += 2;
            } else if (!this.creatureInfo.creatureSpawn.spawnsInDark && light <= 0.5f) {
                this.field_70708_bq += 2;
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isStealthed() && !this.func_82150_aj()) {
                this.func_82142_c(true);
            } else if (!this.isStealthed() && this.func_82150_aj() && !this.func_70644_a(MobEffects.field_76441_p)) {
                this.func_82142_c(false);
            }
        }
        if (this.isStealthed()) {
            if (this.stealthPrev != this.isStealthed()) {
                this.startStealth();
            }
            this.onStealth();
        } else if (this.func_82150_aj() && !this.func_70644_a(MobEffects.field_76441_p) && !this.func_130014_f_().field_72995_K) {
            this.func_82142_c(false);
        }
        this.stealthPrev = this.isStealthed();
        if (this.field_70173_aa % 20 == 0 && !this.func_130014_f_().field_72995_K && this.func_70089_S() && this.canPickupItems()) {
            this.pickupItems();
        }
        if (!this.func_130014_f_().field_72995_K && this.pickupEntity != null) {
            if (!this.pickupEntity.func_70089_S()) {
                this.dropPickupEntity();
            } else if (Math.sqrt(this.func_70032_d((Entity)this.pickupEntity)) > 32.0) {
                this.dropPickupEntity();
            }
        }
        this.getBossInfo();
        if (this.isBossAlways() || this.spawnedWithBlockProtection > 0) {
            ExtendedWorld extendedWorld = ExtendedWorld.getForWorld(this.func_130014_f_());
            extendedWorld.bossUpdate((Entity)this);
        }
        if (!this.minions.isEmpty()) {
            for (EntityLivingBase minion : this.minions.toArray(new EntityLivingBase[0])) {
                if (minion.func_70089_S()) continue;
                this.minions.remove(minion);
            }
        }
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)this.getMasterTarget()).onMinionUpdate((EntityLivingBase)this, this.updateTick);
        }
        ++this.updateTick;
    }

    public void onSyncUpdate() {
        if (this.syncQueued) {
            this.doSync();
        }
        if (!this.func_130014_f_().field_72995_K) {
            byte targets = 0;
            if (this.func_70638_az() != null) {
                targets = (byte)(targets + TARGET_BITS.ATTACK.id);
            }
            if (this.getMasterTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.MASTER.id);
            }
            if (this.getParentTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.PARENT.id);
            }
            if (this.getAvoidTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.AVOID.id);
            }
            if (this.func_184179_bs() != null) {
                targets = (byte)(targets + TARGET_BITS.RIDER.id);
            }
            if (this.getPickupEntity() != null) {
                targets = (byte)(targets + TARGET_BITS.PICKUP.id);
            }
            if (this.getPerchTarget() != null) {
                targets = (byte)(targets + TARGET_BITS.PERCH.id);
            }
            this.field_70180_af.func_187227_b(TARGET, (Object)targets);
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(ATTACK_PHASE, (Object)this.attackPhase);
        }
        if (!this.func_130014_f_().field_72995_K) {
            byte animations = 0;
            if (this.isAttackOnCooldown()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.ATTACKED.id);
            }
            if (this.field_70122_E) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.GROUNDED.id);
            }
            if (this.field_70171_ac) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.IN_WATER.id);
            }
            if (this.isBlocking()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.BLOCKING.id);
            }
            if (this.isMinion()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.MINION.id);
            }
            if (this.extraAnimation01()) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.EXTRA01.id);
            }
            if (this.spawnedAsBoss) {
                animations = (byte)(animations + ANIMATION_STATE_BITS.BOSS.id);
            }
            this.field_70180_af.func_187227_b(ANIMATION_STATE, (Object)animations);
        } else if (this.func_130014_f_().field_72995_K) {
            byte animationState = this.getByteFromDataManager(ANIMATION_STATE);
            if ((animationState & ANIMATION_STATE_BITS.ATTACKED.id) > 0) {
                if (!this.isAttackOnCooldown()) {
                    this.triggerAttackCooldown();
                }
            } else {
                this.resetAttackCooldown();
            }
            this.field_70122_E = (animationState & ANIMATION_STATE_BITS.GROUNDED.id) > 0;
            this.field_70171_ac = (animationState & ANIMATION_STATE_BITS.IN_WATER.id) > 0;
            this.extraAnimation01 = (animationState & ANIMATION_STATE_BITS.EXTRA01.id) > 0;
            boolean bl = this.spawnedAsBoss = (animationState & ANIMATION_STATE_BITS.BOSS.id) > 0;
        }
        if (this.func_130014_f_().field_72995_K) {
            boolean bl = this.isMinion = (this.getByteFromDataManager(ANIMATION_STATE) & ANIMATION_STATE_BITS.MINION.id) > 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(SUBSPECIES, (Object)((byte)this.getSubspeciesIndex()));
        } else if (this.getSubspeciesIndex() != this.getByteFromDataManager(SUBSPECIES)) {
            this.setSubspecies(this.getByteFromDataManager(SUBSPECIES));
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)((byte)this.getVariantIndex()));
        } else if (this.getVariantIndex() != this.getByteFromDataManager(VARIANT)) {
            this.applyVariant(this.getByteFromDataManager(VARIANT));
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf((float)this.sizeScale));
        } else if (this.sizeScale != (double)this.getFloatFromDataManager(SIZE)) {
            this.setSizeScale(this.getFloatFromDataManager(SIZE));
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(ARENA, (Object)(this.getArenaCenter() != null ? Optional.of((Object)this.getArenaCenter()) : Optional.absent()));
        }
    }

    public void updateHitAreas() {
        if (!ENABLE_HITAREAS.booleanValue()) {
            return;
        }
        int hitAreaWidthCount = Math.max(1, Math.round(this.field_70130_N * this.hitAreaWidthScale / 4.0f));
        int hitAreaHeightCount = Math.max(1, Math.round(this.field_70131_O * this.hitAreaHeightScale / 4.0f));
        if (hitAreaWidthCount < 2 && hitAreaHeightCount < 2) {
            this.hitAreas = null;
            return;
        }
        if (this.hitAreas == null || this.hitAreas[0] == null || this.hitAreas[0][0] == null || this.hitAreas.length != hitAreaHeightCount || this.hitAreas[0].length != hitAreaWidthCount || this.hitAreas[0][0].length != hitAreaWidthCount) {
            this.hitAreas = new EntityHitArea[hitAreaHeightCount][hitAreaWidthCount][hitAreaWidthCount];
        }
        for (int y = 0; y < hitAreaHeightCount; ++y) {
            for (int x = 0; x < hitAreaWidthCount; ++x) {
                for (int z = 0; z < hitAreaWidthCount; ++z) {
                    if (y != 0 && y != hitAreaHeightCount - 1 && x != 0 && x != hitAreaWidthCount - 1 && z != 0 && z != hitAreaWidthCount - 1) continue;
                    if (this.hitAreas[y][x][z] == null) {
                        this.hitAreas[y][x][z] = new EntityHitArea((Entity)this, this.field_70130_N / (float)hitAreaWidthCount * this.hitAreaWidthScale, this.field_70131_O / (float)hitAreaHeightCount * this.hitAreaHeightScale);
                        this.func_130014_f_().func_72838_d((Entity)this.hitAreas[y][x][z]);
                    }
                    this.hitAreas[y][x][z].field_70165_t = this.field_70165_t - (double)(this.field_70130_N * this.hitAreaWidthScale / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount * (float)x);
                    this.hitAreas[y][x][z].field_70163_u = this.field_70163_u + (double)(this.field_70131_O / (float)hitAreaHeightCount * this.hitAreaHeightScale * (float)y);
                    this.hitAreas[y][x][z].field_70161_v = this.field_70161_v - (double)(this.field_70130_N * this.hitAreaWidthScale / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount / 2.0f) + (double)(this.field_70130_N * this.hitAreaWidthScale / (float)hitAreaWidthCount * (float)z);
                    this.hitAreas[y][x][z].field_70177_z = this.field_70177_z;
                }
            }
        }
    }

    public AxisAlignedBB func_70046_E() {
        if (this.solidCollision) {
            return this.func_174813_aQ();
        }
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return super.func_70114_g(entity);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public float getBlockPathWeight(int par1, int par2, int par3) {
        if (this.creatureInfo.creatureSpawn.spawnsInDark && !this.creatureInfo.creatureSpawn.spawnsInLight) {
            return 0.5f - this.func_130014_f_().func_175724_o(new BlockPos(par1, par2, par3));
        }
        if (this.creatureInfo.creatureSpawn.spawnsInLight && !this.creatureInfo.creatureSpawn.spawnsInDark) {
            return this.func_130014_f_().func_175724_o(new BlockPos(par1, par2, par3)) - 0.5f;
        }
        return 0.0f;
    }

    public boolean useDirectNavigator() {
        return false;
    }

    public boolean shouldSwim() {
        if (!this.func_70090_H() && !this.func_180799_ab()) {
            return false;
        }
        if (this.canWade() && this.func_70648_aU()) {
            IBlockState blockState;
            boolean targetInWater = true;
            if (this.func_70638_az() != null) {
                targetInWater = this.func_70638_az().func_70090_H();
            } else if (this.getParentTarget() != null) {
                targetInWater = this.getParentTarget().func_70090_H();
            } else if (this.getMasterTarget() != null) {
                targetInWater = this.getMasterTarget().func_70090_H();
            }
            return targetInWater || !(blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177984_a())).func_177230_c().isAir(blockState, (IBlockAccess)this.func_130014_f_(), this.func_180425_c().func_177984_a());
        }
        return this.isStrongSwimmer();
    }

    public boolean func_180799_ab() {
        AxisAlignedBB boundingBox = this.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
        if (this.field_70130_N / 2.0f > 2.0f || this.field_70131_O > 2.0f) {
            double radius = Math.min((double)this.field_70130_N / 2.0, 2.0);
            double height = Math.min((double)this.field_70131_O, 2.0);
            boundingBox = new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + height, this.field_70161_v + radius);
        }
        return this.field_70170_p.func_72875_a(boundingBox, Material.field_151587_i);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        if (Double.isNaN(z)) {
            z = 0.0;
        }
        x = Math.max(Math.min(x, 10.0), -10.0);
        y = Math.max(Math.min(y, 10.0), -10.0);
        z = Math.max(Math.min(z, 10.0), -10.0);
        super.func_70091_d(type, x, y, z);
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (!this.useDirectNavigator()) {
            if (this.isFlying() && !this.func_70090_H() && !this.func_180799_ab()) {
                this.moveFlyingWithHeading(strafe, forward);
                this.updateLimbSwing();
            } else if (this.shouldSwim()) {
                this.moveSwimmingWithHeading(strafe, forward);
                this.updateLimbSwing();
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            this.directNavigator.flightMovement(strafe, forward);
            this.updateLimbSwing();
        }
    }

    public void updateLimbSwing() {
        this.field_184618_aE = this.field_70721_aZ;
        double distanceX = this.field_70165_t - this.field_70169_q;
        double distanceZ = this.field_70161_v - this.field_70166_s;
        float distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 4.0f;
        if (distance > 1.0f) {
            distance = 1.0f;
        }
        this.field_70721_aZ += (distance - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void moveFlyingWithHeading(float strafe, float forward) {
        float f = 0.91f;
        if (this.field_70122_E) {
            f = this.func_130014_f_().func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
        }
        float f1 = 0.16277136f / (f * f * f);
        this.moveFlying(strafe, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
        f = 0.91f;
        if (this.field_70122_E) {
            f = this.func_130014_f_().func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)f;
        this.field_70179_y *= (double)f;
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void moveFlying(float strafe, float forward, float friction) {
        if (!this.func_96092_aw() && this.canWalk() && this.func_70090_H()) {
            float sliperryness = 0.91f;
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
            if (this.field_70122_E) {
                sliperryness = this.func_130014_f_().func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_177230_c().field_149765_K * sliperryness * 2.0f;
            }
            float f7 = 0.16277136f / (sliperryness * sliperryness * sliperryness);
            friction = this.func_70689_ay() * f7;
        }
    }

    public void moveSwimmingWithHeading(float strafe, float forward) {
        super.func_191958_b(strafe, 0.0f, forward, 0.1f);
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.9f;
        this.field_70181_x *= (double)0.9f;
        this.field_70179_y *= (double)0.9f;
    }

    protected PathNavigate func_175447_b(World world) {
        return new CreaturePathNavigate(this, world);
    }

    protected EntityMoveHelper createMoveHelper() {
        return new CreatureMoveHelper(this);
    }

    public PathNavigate func_70661_as() {
        return super.func_70661_as();
    }

    public EntityMoveHelper func_70605_aq() {
        return super.func_70605_aq();
    }

    public void clearMovement() {
        if (!this.useDirectNavigator() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        } else {
            this.directNavigator.clearTargetPosition(1.0);
        }
    }

    public boolean rollLookChance() {
        return this.func_70681_au().nextFloat() < 0.02f;
    }

    public boolean rollWanderChance() {
        if (this.field_70130_N >= 3.0f) {
            return this.func_70681_au().nextDouble() <= 5.0E-4;
        }
        return this.func_70681_au().nextDouble() <= 0.008;
    }

    protected void func_110159_bB() {
        super.func_110159_bB();
        if (this.func_110167_bD() && this.func_110166_bE().func_130014_f_() == this.func_130014_f_()) {
            Entity entity = this.func_110166_bE();
            this.setHome((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, 5.0f);
            float distance = this.func_70032_d(entity);
            this.testLeash(distance);
            if (!this.leashAIActive) {
                this.field_70714_bg.func_75776_a(2, this.leashMoveTowardsRestrictionAI);
                if (!this.isStrongSwimmer()) {
                    this.func_184644_a(PathNodeType.WATER, 0.0f);
                }
                this.leashAIActive = true;
            }
            if (distance > 4.0f) {
                this.func_70661_as().func_75497_a(entity, 1.0);
            }
            if (distance > 6.0f) {
                double d0 = (entity.field_70165_t - this.field_70165_t) / (double)distance;
                double d1 = (entity.field_70163_u - this.field_70163_u) / (double)distance;
                double d2 = (entity.field_70161_v - this.field_70161_v) / (double)distance;
                this.field_70159_w += d0 * Math.abs(d0) * 0.4;
                this.field_70181_x += d1 * Math.abs(d1) * 0.4;
                this.field_70179_y += d2 * Math.abs(d2) * 0.4;
            }
            if (distance > 10.0f) {
                this.func_110160_i(true, true);
            }
        } else if (!this.func_110167_bD() && this.leashAIActive) {
            this.leashAIActive = false;
            this.field_70714_bg.func_85156_a(this.leashMoveTowardsRestrictionAI);
            if (!this.isStrongSwimmer()) {
                this.func_184644_a(PathNodeType.WATER, PathNodeType.WATER.func_186289_a());
            }
            this.detachHome();
        }
    }

    public boolean func_96092_aw() {
        return !this.isStrongSwimmer() && !this.isBoss();
    }

    public boolean isMoving() {
        if (!this.useDirectNavigator()) {
            return this.func_70661_as().func_75505_d() != null;
        }
        return !this.directNavigator.atTargetPosition();
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void testLeash(float distance) {
    }

    public void func_70659_e(float speed) {
        super.func_70659_e(speed * this.getAISpeedModifier());
    }

    public float getAISpeedModifier() {
        if (!(this.canWalk() || this.func_70090_H() || this.isFlying())) {
            return 0.1f;
        }
        return 1.0f;
    }

    public double getFallingMod() {
        return 1.0;
    }

    protected float func_189749_co() {
        if (!this.func_96092_aw()) {
            return 1.0f;
        }
        return 0.8f;
    }

    public void leap(double distance, double leapHeight) {
        if (!this.isFlying()) {
            this.playJumpSound();
        }
        float yaw = this.field_70177_z;
        float pitch = this.field_70125_A;
        double angle = Math.toRadians(yaw);
        double xAmount = -Math.sin(angle);
        double yAmount = leapHeight;
        double zAmount = Math.cos(angle);
        if (this.isFlying()) {
            yAmount = Math.sin(Math.toRadians(pitch)) * distance + this.field_70181_x * 0.2;
        }
        this.func_70024_g(xAmount * distance + this.field_70159_w * 0.2, yAmount, zAmount * distance + this.field_70179_y * 0.2);
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public void leap(float range, double leapHeight, Entity target) {
        if (target == null) {
            return;
        }
        this.leap(range, leapHeight, target.func_180425_c());
    }

    public void leap(float range, double leapHeight, BlockPos targetPos) {
        double distance;
        if (targetPos == null) {
            return;
        }
        if (!this.isFlying()) {
            this.playJumpSound();
        }
        if ((distance = targetPos.func_177951_i((Vec3i)this.func_180425_c())) > 4.0 && distance <= (double)(range * range)) {
            double xDist = targetPos.func_177958_n() - this.func_180425_c().func_177958_n();
            double zDist = targetPos.func_177952_p() - this.func_180425_c().func_177952_p();
            if (xDist == 0.0) {
                xDist = 0.05;
            }
            if (zDist == 0.0) {
                zDist = 0.05;
            }
            double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            this.func_70024_g(xDist / xzDist * 0.5 * 0.8 + this.field_70159_w * 0.2, leapHeight, zDist / xzDist * 0.5 * 0.8 + this.field_70179_y * 0.2);
            ForgeHooks.onLivingJump((EntityLivingBase)this);
        }
    }

    public void strafe(double distance, double leapHeight) {
        boolean opposite = false;
        if (distance < 0.0) {
            distance = -distance;
            opposite = true;
        }
        float yaw = this.field_70177_z + (opposite ? -90.0f : 90.0f);
        float pitch = this.field_70125_A;
        double angle = Math.toRadians(yaw);
        double xAmount = -Math.sin(angle);
        double yAmount = leapHeight;
        double zAmount = Math.cos(angle);
        if (this.isFlying()) {
            yAmount = Math.sin(Math.toRadians(pitch)) * distance + this.field_70181_x * 0.2;
        }
        this.func_70024_g(xAmount * distance + this.field_70159_w * 0.2, yAmount, zAmount * distance + this.field_70179_y * 0.2);
    }

    public boolean isLookingAtMe(Entity targetEntity) {
        if (targetEntity == null) {
            return false;
        }
        Vec3d targetViewVector = targetEntity.func_70676_i(1.0f).func_72432_b();
        Vec3d distance = new Vec3d(this.field_70165_t - targetEntity.field_70165_t, this.field_70163_u + (double)this.func_70047_e() - (targetEntity.field_70163_u + (double)targetEntity.func_70047_e()), this.field_70161_v - targetEntity.field_70161_v);
        double distanceStraight = distance.func_72433_c();
        distance = distance.func_72432_b();
        double lookDistance = targetViewVector.func_72430_b(distance);
        double lookRange = 1.5;
        double comparison = 1.0 - lookRange / distanceStraight;
        if (targetEntity instanceof EntityPlayer) {
            return lookDistance > comparison && ((EntityPlayer)targetEntity).func_70685_l((Entity)this);
        }
        return lookDistance > comparison;
    }

    public void setHome(int x, int y, int z, float distance) {
        this.setHomePosition(x, y, z);
        this.setHomeDistanceMax(distance);
    }

    public void setHomePosition(int x, int y, int z) {
        this.homePosition = new BlockPos(x, y, z);
    }

    public void setHomeDistanceMax(float distance) {
        this.homeDistanceMax = distance;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public float getHomeDistanceMax() {
        return this.homeDistanceMax;
    }

    public void detachHome() {
        this.setHomeDistanceMax(-1.0f);
    }

    public boolean hasHome() {
        return this.getHomePosition() != null && this.getHomeDistanceMax() >= 0.0f;
    }

    public boolean positionNearHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return true;
        }
        return this.getDistanceFromHome(x, y, z) < (double)(this.getHomeDistanceMax() * this.getHomeDistanceMax());
    }

    public double getDistanceFromHome(int x, int y, int z) {
        if (!this.hasHome()) {
            return 0.0;
        }
        return this.homePosition.func_185332_f(x, y, z);
    }

    public double getDistanceFromHome() {
        return this.homePosition.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean hasArenaCenter() {
        return this.getArenaCenter() != null;
    }

    public void setArenaCenter(BlockPos pos) {
        this.arenaCenter = pos;
    }

    public BlockPos getArenaCenter() {
        return this.arenaCenter;
    }

    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        return wanderPosition;
    }

    public int restrictYHeightFromGround(BlockPos coords, int minY, int maxY) {
        int groundY = this.getGroundY(coords);
        int airYMax = Math.min(this.getAirY(coords), groundY + maxY);
        int airYMin = Math.min(airYMax, groundY + minY);
        if (airYMin >= airYMax) {
            return airYMin;
        }
        return airYMin + this.func_70681_au().nextInt(airYMax - airYMin);
    }

    public int getGroundY(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y <= 0) {
            return 0;
        }
        IBlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock.func_177230_c().isAir(startBlock, (IBlockAccess)this.func_130014_f_(), pos)) {
            IBlockState possibleGroundBlock;
            int possibleGroundY = Math.max(0, y - 1);
            while (possibleGroundY >= 0 && (possibleGroundBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleGroundY, pos.func_177952_p()))).func_177230_c().isAir(possibleGroundBlock, (IBlockAccess)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleGroundY, pos.func_177952_p()))) {
                y = possibleGroundY--;
            }
        }
        return y;
    }

    public int getAirY(BlockPos pos) {
        int yMax;
        int y = pos.func_177956_o();
        if (y >= (yMax = this.func_130014_f_().field_73011_w.getActualHeight() - 1)) {
            return yMax;
        }
        if (this.func_130014_f_().func_175710_j(pos)) {
            return yMax;
        }
        IBlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock.func_177230_c().isAir(startBlock, (IBlockAccess)this.func_130014_f_(), pos)) {
            IBlockState possibleGroundBlock;
            int possibleAirY = Math.min(yMax, y + 1);
            while (possibleAirY <= yMax && (possibleGroundBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleAirY, pos.func_177952_p()))).func_177230_c().isAir(possibleGroundBlock, (IBlockAccess)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleAirY, pos.func_177952_p()))) {
                y = possibleAirY++;
            }
        }
        return y;
    }

    public int getWaterSurfaceY(BlockPos pos) {
        int y = pos.func_177956_o();
        if (y <= 0) {
            return 0;
        }
        int yMax = this.func_130014_f_().field_73011_w.getActualHeight() - 1;
        if (y >= yMax) {
            return yMax;
        }
        int yLimit = 24;
        yMax = Math.min(yMax, y + yLimit);
        IBlockState startBlock = this.func_130014_f_().func_180495_p(pos);
        if (startBlock.func_185904_a() == Material.field_151586_h) {
            int possibleSurfaceY = y;
            ++possibleSurfaceY;
            while (possibleSurfaceY <= yMax) {
                IBlockState possibleSurfaceBlock = this.func_130014_f_().func_180495_p(new BlockPos(pos.func_177958_n(), possibleSurfaceY, pos.func_177952_p()));
                if (possibleSurfaceBlock.func_177230_c().isAir(possibleSurfaceBlock, (IBlockAccess)this.func_130014_f_(), new BlockPos(pos.func_177958_n(), possibleSurfaceY, pos.func_177952_p()))) {
                    return possibleSurfaceY;
                }
                if (possibleSurfaceBlock.func_185904_a() != Material.field_151586_h) {
                    return possibleSurfaceY - 1;
                }
                ++possibleSurfaceY;
            }
            return Math.max(possibleSurfaceY - 1, y);
        }
        return y;
    }

    protected void func_70105_a(float width, float height) {
        width = (float)((double)width * ((double)((float)this.sizeScale) * this.creatureInfo.sizeScale));
        height = (float)((double)height * ((double)((float)this.sizeScale) * this.creatureInfo.sizeScale));
        super.func_70105_a(width, height);
        this.hitAreas = null;
        if (!this.func_130014_f_().field_72995_K && this.func_70661_as() != null && this.func_70661_as().func_189566_q() instanceof ICreatureNodeProcessor) {
            ((ICreatureNodeProcessor)this.func_70661_as().func_189566_q()).updateEntitySize((Entity)this);
        }
    }

    public void updateSize() {
        this.func_70105_a(Math.max(this.setWidth, 0.5f), Math.max(this.setHeight, 0.5f));
    }

    public void setSizeScale(double scale) {
        this.sizeScale = scale;
        this.updateSize();
    }

    public double getRenderScale() {
        return this.sizeScale * this.creatureInfo.sizeScale;
    }

    public boolean func_70686_a(Class targetClass) {
        return CreatureManager.getInstance().config.mobsAttackVillagers || targetClass != EntityVillager.class;
    }

    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (!CreatureManager.getInstance().config.mobsAttackVillagers && targetEntity instanceof EntityVillager) {
            return false;
        }
        if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.PEACEFUL && targetEntity instanceof EntityPlayer) {
            return false;
        }
        if (!Targeting.isValidTarget((Entity)this, (Entity)targetEntity)) {
            return false;
        }
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)targetEntity;
            if (targetPlayer.field_71075_bZ.field_75102_a) {
                return false;
            }
        }
        if (this.func_184191_r((Entity)targetEntity)) {
            return false;
        }
        CreatureRelationshipEntry relationshipEntry = this.relationships.getEntry((Entity)targetEntity);
        if (relationshipEntry != null && !relationshipEntry.canAttack()) {
            return false;
        }
        if (targetEntity instanceof BaseCreatureEntity) {
            BaseCreatureEntity targetCreature = (BaseCreatureEntity)targetEntity;
            if (!this.canAttackOwnSpecies() && ((Object)((Object)targetCreature)).getClass() == ((Object)((Object)this)).getClass() && !targetCreature.isTamed()) {
                return false;
            }
            if (targetCreature.getMasterTarget() == this) {
                return false;
            }
            if (!(this instanceof IGroupBoss) && !this.isTamed()) {
                if (targetCreature.isBoss()) {
                    return false;
                }
                if (this.isRareVariant()) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canAttackOwnSpecies() {
        return false;
    }

    public double getPhysicalRange() {
        double range = (double)this.field_70130_N + 1.5;
        if (this.isFlying()) {
            range += this.getFlightOffset();
        }
        return range * range;
    }

    public double getMeleeAttackRange(EntityLivingBase attackTarget, double additionalReach) {
        double creatureRange = this.getPhysicalRange();
        double targetSize = 1.0;
        if (attackTarget != null) {
            targetSize = (attackTarget.field_70130_N + 1.0f) * (attackTarget.field_70130_N + 1.0f);
        }
        return creatureRange + targetSize + additionalReach;
    }

    public boolean shouldCreatureGroupRevenge(EntityLivingBase target) {
        boolean shouldRevenge = this.creatureInfo.getGroups().isEmpty();
        boolean shouldPackHunt = false;
        for (CreatureGroup group : this.creatureInfo.getGroups()) {
            if (group.shouldRevenge((Entity)target)) {
                shouldRevenge = true;
            }
            if (!group.shouldPackHunt((Entity)target)) continue;
            shouldPackHunt = true;
        }
        boolean canPackHunt = shouldPackHunt && this.isInPack();
        return shouldRevenge || canPackHunt;
    }

    public boolean shouldCreatureGroupHunt(EntityLivingBase target) {
        boolean canPackHunt;
        boolean shouldFlee = false;
        boolean shouldHunt = false;
        boolean shouldPackHunt = false;
        for (CreatureGroup group : this.creatureInfo.getGroups()) {
            if (group.shouldFlee((Entity)target)) {
                shouldFlee = true;
            }
            if (group.shouldHunt((Entity)target)) {
                shouldHunt = true;
            }
            if (!group.shouldPackHunt((Entity)target)) continue;
            shouldPackHunt = true;
        }
        boolean bl = canPackHunt = shouldPackHunt && this.isInPack();
        if (shouldFlee && !canPackHunt) {
            return false;
        }
        return shouldHunt || shouldPackHunt;
    }

    public boolean shouldCreatureGroupFlee(EntityLivingBase target) {
        if (this.isBoss() || this.isRareVariant() || this.isTamed()) {
            return false;
        }
        boolean shouldFlee = false;
        boolean shouldPackHunt = false;
        for (CreatureGroup group : this.creatureInfo.getGroups()) {
            if (group.shouldFlee((Entity)target)) {
                shouldFlee = true;
            }
            if (!group.shouldPackHunt((Entity)target)) continue;
            shouldPackHunt = true;
        }
        boolean canPackHunt = shouldPackHunt && this.isInPack();
        return shouldFlee && !canPackHunt;
    }

    public EntityLivingBase getMasterAttackTarget() {
        if (this.masterTarget == null) {
            return null;
        }
        if (this.masterTarget instanceof EntityLiving) {
            return ((EntityLiving)this.masterTarget).func_70638_az();
        }
        return null;
    }

    public EntityLivingBase getParentAttackTarget() {
        if (this.parentTarget == null) {
            return null;
        }
        if (this.parentTarget instanceof BaseCreatureEntity) {
            return ((BaseCreatureEntity)this.parentTarget).func_70638_az();
        }
        if (this.parentTarget instanceof EntityCreature) {
            return ((EntityCreature)this.parentTarget).func_70638_az();
        }
        return null;
    }

    public void func_70604_c(EntityLivingBase entityLivingBase) {
        super.func_70604_c(entityLivingBase);
    }

    public boolean attackMelee(Entity target, double damageScale) {
        if (this.isBlocking() && !this.canAttackWhileBlocking()) {
            return false;
        }
        if (this.attackEntityAsMob(target, damageScale)) {
            EntityLivingBase livingTarget;
            if (!(!(target instanceof EntityLivingBase) || (livingTarget = (EntityLivingBase)target).func_184585_cz() && livingTarget.func_184607_cu().func_77973_b().isShield(livingTarget.func_184607_cu(), livingTarget))) {
                if (this.spreadFire && this.func_70027_ad() && (double)this.field_70146_Z.nextFloat() < this.creatureStats.getEffect()) {
                    target.func_70015_d(this.getEffectDuration(4) / 20);
                }
                if (this.creatureStats.getAmplifier() >= 0.0) {
                    this.applyDebuffs(livingTarget, 1, 1);
                }
            }
            this.triggerAttackCooldown();
            this.playAttackSound();
            return true;
        }
        return false;
    }

    public boolean attackHitscan(Entity target, double damageScale) {
        if (this.isBlocking() && !this.canAttackWhileBlocking()) {
            return false;
        }
        if (target == null || !this.func_70685_l(target)) {
            return false;
        }
        if (this.attackEntityAsMob(target, damageScale)) {
            EntityLivingBase livingTarget;
            if (target instanceof EntityLivingBase && (!(livingTarget = (EntityLivingBase)target).func_184585_cz() || !livingTarget.func_184607_cu().func_77973_b().isShield(livingTarget.func_184607_cu(), livingTarget)) && this.creatureStats.getAmplifier() >= 0.0) {
                this.applyDebuffs(livingTarget, 1, 1);
            }
            this.triggerAttackCooldown();
            this.playAttackSound();
            return true;
        }
        return false;
    }

    public void attackRanged(Entity target, float range) {
        if (this.isBlocking() && !this.canAttackWhileBlocking()) {
            return;
        }
        this.triggerAttackCooldown();
        this.playAttackSound();
    }

    public boolean doRangedDamage(Entity target, EntityThrowable projectile, float damage, boolean noPierce) {
        boolean success;
        double pierceDamage;
        damage = (float)((double)damage * (this.creatureStats.getDamage() / 2.0));
        double d = pierceDamage = noPierce ? 0.0 : this.creatureStats.getPierce();
        if ((double)damage <= pierceDamage) {
            success = target.func_70097_a(this.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)projectile, (Entity)this).func_76348_h(), false).func_151518_m(), damage);
        } else {
            int hurtResistantTimeBefore = target.field_70172_ad;
            if (pierceDamage > 0.0) {
                target.func_70097_a(this.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)projectile, (Entity)this).func_76348_h(), false).func_151518_m(), (float)pierceDamage);
            }
            target.field_70172_ad = hurtResistantTimeBefore;
            damage = (float)((double)damage - pierceDamage);
            success = target.func_70097_a(this.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)projectile, (Entity)this), false), damage);
        }
        if (success && target instanceof EntityLivingBase && this.creatureStats.getAmplifier() >= 0.0) {
            this.applyDebuffs((EntityLivingBase)target, 1, 1);
        }
        return success;
    }

    public BaseProjectileEntity fireProjectile(String projectileName, Entity target, float range, float angle, Vec3d offset, float velocity, float scale, float inaccuracy) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(projectileName);
        if (projectileInfo == null) {
            return null;
        }
        return this.fireProjectile(projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)this), target, range, angle, offset, velocity, scale, inaccuracy);
    }

    public BaseProjectileEntity fireProjectile(Class projectileClass, Entity target, float range, float angle, Vec3d offset, float velocity, float scale, float inaccuracy) {
        BaseProjectileEntity projectile = null;
        try {
            projectile = (BaseProjectileEntity)((Object)projectileClass.getConstructor(World.class, EntityLivingBase.class).newInstance(new Object[]{this.func_130014_f_(), this}));
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to create a projectile from the class: " + projectileClass);
        }
        return this.fireProjectile(projectile, target, range, angle, offset, velocity, scale, inaccuracy);
    }

    public BaseProjectileEntity fireProjectile(BaseProjectileEntity projectile, Entity target, float range, float angle, Vec3d offset, float velocity, float scale, float inaccuracy) {
        double distanceXZ;
        if (projectile == null) {
            return null;
        }
        projectile.field_70165_t += offset.field_72450_a * this.sizeScale;
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f) + offset.field_72448_b * this.sizeScale;
        projectile.field_70161_v += offset.field_72449_c * this.sizeScale;
        projectile.setProjectileScale(scale);
        Vec3d facing = this.getFacingPositionDouble(this.field_70165_t, this.field_70163_u, this.field_70161_v, range, angle);
        double distanceX = facing.field_72450_a - this.field_70165_t;
        double distanceZ = facing.field_72449_c - this.field_70161_v;
        double distanceY = distanceXZ = (double)MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 0.0;
        if (target != null) {
            double targetX = target.field_70165_t - this.field_70165_t;
            double targetZ = target.field_70161_v - this.field_70161_v;
            double newX = targetX * Math.cos(angle) - targetZ * Math.sin(angle);
            double newY = targetX * Math.sin(angle) + targetZ * Math.cos(angle);
            targetX = newX + this.field_70165_t;
            targetZ = newY + this.field_70161_v;
            distanceX = targetX - this.field_70165_t;
            distanceY = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O * 0.5 - projectile.field_70163_u;
            distanceZ = targetZ - this.field_70161_v;
        }
        projectile.func_70186_c(distanceX, distanceY, distanceZ, velocity, inaccuracy);
        this.func_130014_f_().func_72838_d((Entity)projectile);
        if (projectile.getLaunchSound() != null) {
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        return projectile;
    }

    public byte getAttackPhase() {
        return this.getByteFromDataManager(ATTACK_PHASE);
    }

    public void setAttackPhase(byte setAttackPhase) {
        this.attackPhase = setAttackPhase;
    }

    public void nextAttackPhase() {
        this.attackPhase = (byte)(this.attackPhase + 1);
        if (this.attackPhase > this.attackPhaseMax - 1) {
            this.attackPhase = 0;
        }
    }

    public boolean attackEntityAsMob(Entity target, double damageScale) {
        boolean attackSuccess;
        if (!this.func_70089_S()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (!this.func_70685_l(target)) {
            return false;
        }
        float damage = this.getAttackDamage(damageScale);
        int enchantmentKnockback = 0;
        boolean targetIsShielding = false;
        if (target instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)target;
            ItemStack playerActiveItemStack = targetPlayer.func_184607_cu();
            targetIsShielding = targetPlayer.func_184585_cz() && playerActiveItemStack.func_77973_b().isShield(playerActiveItemStack, (EntityLivingBase)targetPlayer);
        }
        double pierceDamage = this.creatureStats.getPierce();
        if (targetIsShielding) {
            pierceDamage = 0.0;
        }
        if ((double)damage <= pierceDamage) {
            attackSuccess = target.func_70097_a(this.getDamageSource(null, false).func_76348_h().func_151518_m(), damage);
        } else {
            if (pierceDamage > 0.0) {
                int hurtResistantTimeBefore = target.field_70172_ad;
                target.func_70097_a(this.getDamageSource(null, false).func_76348_h().func_151518_m(), (float)pierceDamage);
                target.field_70172_ad = hurtResistantTimeBefore;
                damage = (float)((double)damage - pierceDamage);
            }
            attackSuccess = target.func_70097_a(this.getDamageSource(null, false), damage);
        }
        if (attackSuccess) {
            int fireEnchantDuration;
            this.func_130011_c(target);
            if (enchantmentKnockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)enchantmentKnockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)enchantmentKnockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireEnchantDuration = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireEnchantDuration * 4);
            }
            if (target instanceof EntityPlayer && this.canInteruptShields(true)) {
                EntityPlayer targetPlayer = (EntityPlayer)target;
                if (targetIsShielding && this.canInteruptShields(false)) {
                    ItemStack playerActiveItemStack = targetPlayer.func_184587_cr() ? targetPlayer.func_184607_cu() : ItemStack.field_190927_a;
                    targetPlayer.func_184811_cZ().func_185145_a(playerActiveItemStack.func_77973_b(), 100);
                    this.field_70170_p.func_72960_a((Entity)targetPlayer, (byte)30);
                }
            }
        }
        return attackSuccess;
    }

    public boolean canTargetBlockDamageSource(EntityLivingBase target, DamageSource damageSource) {
        Vec3d vec3d;
        if (!damageSource.func_76363_c() && target.func_184585_cz() && (vec3d = damageSource.func_188404_v()) != null) {
            Vec3d vec3d1 = target.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public float getAttackDamage(double damageScale) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        damage = (float)((double)damage * damageScale);
        return damage;
    }

    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource, boolean playerCredit) {
        if (nestedDamageSource != null) {
            return nestedDamageSource;
        }
        return DamageSource.func_76358_a((EntityLivingBase)this);
    }

    public boolean canInteruptShields(boolean checkAbility) {
        return false;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (this.func_180431_b(damageSrc)) {
            return;
        }
        if ((damageAmount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
            return;
        }
        damageAmount *= this.getDamageModifier(damageSrc);
        damageAmount = this.func_70655_b(damageSrc, damageAmount);
        damageAmount = this.func_70672_c(damageSrc, damageAmount);
        damageAmount = this.getDamageAfterDefense(damageAmount);
        if ((this.isBoss() || this.isRareVariant()) && !(damageSrc.func_76346_g() instanceof EntityPlayer)) {
            damageAmount *= 0.25f;
        }
        float damageBeforeAbsorption = damageAmount;
        damageAmount = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
        this.func_110149_m(this.func_110139_bj() - (damageBeforeAbsorption - damageAmount));
        damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount);
        if (damageAmount != 0.0f) {
            float healthBeforeDamage = this.func_110143_aJ();
            this.func_110142_aN().func_94547_a(damageSrc, healthBeforeDamage, damageAmount);
            this.func_70606_j(healthBeforeDamage - damageAmount);
            this.func_110149_m(this.func_110139_bj() - damageAmount);
        }
    }

    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.func_180431_b(damageSrc)) {
            return false;
        }
        if (!this.isDamageTypeApplicable(damageSrc.func_76355_l(), damageSrc, damageAmount)) {
            return false;
        }
        if (!this.isDamageEntityApplicable(damageSrc.func_76346_g())) {
            return false;
        }
        if (this.dropsRequirePlayerDamage && damageSrc.func_76346_g() instanceof EntityPlayer) {
            if (damageSrc instanceof MinionEntityDamageSource) {
                MinionEntityDamageSource minionEntityDamageSource = (MinionEntityDamageSource)damageSrc;
                if (minionEntityDamageSource.getMinion() instanceof TameableCreatureEntity) {
                    TameableCreatureEntity tameableCreatureEntity = (TameableCreatureEntity)minionEntityDamageSource.getMinion();
                    if (!tameableCreatureEntity.fromSummoningPedestal) {
                        this.dropsRequirePlayerDamage = false;
                    }
                }
            } else {
                this.dropsRequirePlayerDamage = false;
            }
        }
        if (super.func_70097_a(damageSrc, damageAmount)) {
            Entity entity;
            this.onDamage(damageSrc, damageAmount);
            if (this.isBoss() && this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof EntityPlayer && !this.playerTargets.contains(damageSrc.func_76346_g())) {
                this.playerTargets.add((EntityPlayer)damageSrc.func_76346_g());
            }
            if ((entity = damageSrc.func_76364_f()) instanceof EntityThrowable) {
                entity = ((EntityThrowable)entity).func_85052_h();
            }
            if (entity instanceof EntityLivingBase && this.getRider() != entity && this.func_184187_bx() != entity && entity != this) {
                this.func_70604_c((EntityLivingBase)entity);
                CreatureRelationshipEntry relationshipEntry = this.relationships.getOrCreateEntry(entity);
                int reputationAmount = 50 + this.func_70681_au().nextInt(50);
                relationshipEntry.decreaseReputation(reputationAmount);
            }
            return true;
        }
        return false;
    }

    public boolean attackEntityFromArea(EntityHitArea entityHitArea, DamageSource damageSrc, float damage) {
        return this.func_70097_a(damageSrc, damage);
    }

    public float getDamageAfterDefense(float damage) {
        float defense = (float)this.creatureStats.getDefense();
        float minDamage = 0.0f;
        if (this.isBlocking()) {
            if (defense <= 0.0f) {
                defense = 1.0f;
            }
            defense *= (float)this.getBlockingMultiplier();
        }
        damage = Math.max(damage - defense, 1.0f);
        if (this.damageMax > 0) {
            damage = Math.min(damage, (float)this.damageMax);
        }
        return Math.max(damage, minDamage);
    }

    public void onDamage(DamageSource damageSrc, float damage) {
        this.damageTakenThisSec += damage;
    }

    public float getDamageModifier(DamageSource damageSrc) {
        return 1.0f;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70729_aU) {
            return;
        }
        if (this.isBossAlways()) {
            ExtendedWorld extendedWorld = ExtendedWorld.getForWorld(this.func_130014_f_());
            extendedWorld.bossRemoved((Entity)this);
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.isBoundPet()) {
                this.inventory.dropInventory();
            }
            if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof EntityPlayer) {
                try {
                    ExtendedPlayer extendedPlayer;
                    EntityPlayer player = (EntityPlayer)damageSource.func_76346_g();
                    player.func_71064_a(ObjectManager.getStat(this.creatureInfo.getName() + ".kill"), 1);
                    if (!this.isTamed() && (extendedPlayer = ExtendedPlayer.getForPlayer(player)) != null) {
                        extendedPlayer.studyCreature((Entity)this, CreatureManager.getInstance().config.creatureKillKnowledge, false, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.getMasterTarget() != null && this.getMasterTarget() instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)this.getMasterTarget()).onMinionDeath((EntityLivingBase)this, damageSource);
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.isTamed() || this.isMinion() || this.dropsRequirePlayerDamage) {
            return 0;
        }
        return super.func_70693_a(player);
    }

    public boolean isAggressive() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.aggressiveOverride) {
            return true;
        }
        return this.isAggressiveByDefault;
    }

    public boolean isHostileTo(Entity target) {
        if (target == null) {
            return false;
        }
        if (this.hostileTargetClasses.contains(target.getClass())) {
            return true;
        }
        for (CreatureGroup group : this.creatureInfo.getGroups()) {
            if (!group.shouldHunt(target) && !group.shouldPackHunt(target)) continue;
            return true;
        }
        return false;
    }

    public void setHostileTo(Class<? extends Entity> targetClass) {
        if (this.hostileTargetClasses == null) {
            this.hostileTargetClasses = new ArrayList<Class<? extends Entity>>();
        }
        if (this.hostileTargetClasses.contains(targetClass)) {
            return;
        }
        this.hostileTargetClasses.add(targetClass);
    }

    public boolean isProtective(Entity entity) {
        return entity.getClass() == ((Object)((Object)this)).getClass();
    }

    public boolean hasAttackTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_70638_az() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.ATTACK.id) > 0;
    }

    public EntityLivingBase getMasterTarget() {
        return this.masterTarget;
    }

    public void setMasterTarget(EntityLivingBase setTarget) {
        this.masterTarget = setTarget;
    }

    public boolean hasMaster() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getMasterTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.MASTER.id) > 0;
    }

    public EntityLivingBase getParentTarget() {
        return this.parentTarget;
    }

    public void setParentTarget(EntityLivingBase setTarget) {
        this.parentTarget = setTarget;
    }

    public boolean hasParent() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getParentTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.PARENT.id) > 0;
    }

    public EntityLivingBase getAvoidTarget() {
        return this.avoidTarget;
    }

    public void setAvoidTarget(EntityLivingBase setTarget) {
        this.currentFleeTime = this.fleeTime;
        this.avoidTarget = setTarget;
    }

    public boolean hasAvoidTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getAvoidTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.AVOID.id) > 0;
    }

    public EntityLivingBase getFixateTarget() {
        return this.fixateTarget;
    }

    public void setFixateTarget(EntityLivingBase target) {
        this.fixateTarget = target;
    }

    public boolean hasFixateTarget() {
        return this.getFixateTarget() != null;
    }

    public EntityLivingBase getPerchTarget() {
        return this.perchTarget;
    }

    public void setPerchTarget(EntityLivingBase setTarget) {
        this.perchTarget = setTarget;
    }

    public boolean hasPerchTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getPerchTarget() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.PERCH.id) > 0;
    }

    public boolean rollAttackTargetChance(EntityLivingBase target) {
        return true;
    }

    public boolean func_70685_l(Entity target) {
        return super.func_70685_l(target);
    }

    public Entity getOwner() {
        return null;
    }

    public UUID getOwnerId() {
        return null;
    }

    public EntityLivingBase getRider() {
        if (this.func_184179_bs() instanceof EntityLivingBase) {
            return (EntityLivingBase)this.func_184179_bs();
        }
        return null;
    }

    public void setRiderTarget(Entity setTarget) {
        this.func_184200_o(setTarget);
    }

    public boolean hasRiderTarget() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_184179_bs() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.RIDER.id) > 0;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected boolean func_184228_n(Entity entity) {
        if (this.isBoss()) {
            return false;
        }
        return super.func_184228_n(entity);
    }

    public boolean func_82171_bF() {
        return false;
    }

    public boolean canBeTargetedBy(EntityLivingBase entity) {
        if (this.isBoss() && entity instanceof BaseCreatureEntity) {
            TameableCreatureEntity entityTameable;
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
            return entityCreature instanceof TameableCreatureEntity && (entityTameable = (TameableCreatureEntity)entity).getPlayerOwner() != null;
        }
        return true;
    }

    public boolean isInPack() {
        return this.creatureInfo.packSize <= 1 || this.countAllies(10.0) >= this.creatureInfo.packSize;
    }

    public BlockPos getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public BlockPos getFacingPosition(Entity entity, double distance, double angleOffset) {
        return this.getFacingPosition(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, distance, (double)entity.field_70177_z + angleOffset);
    }

    public BlockPos getFacingPosition(double x, double y, double z, double distance, double angle) {
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        return new BlockPos(x + distance * xAmount, y, z + distance * zAmount);
    }

    public Vec3d getFacingPositionDouble(double x, double y, double z, double distance, double angle) {
        if (distance == 0.0) {
            distance = 1.0;
        }
        angle = Math.toRadians(angle);
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        return new Vec3d(x + distance * xAmount, y, z + distance * zAmount);
    }

    public boolean isTamed() {
        return false;
    }

    public boolean isHostile() {
        return this.isAggressive();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount) {
            if (this.isMinion()) {
                return false;
            }
            for (EnumCreatureType creatureType : this.creatureInfo.creatureSpawn.vanillaSpawnerTypes) {
                if (creatureType != type) continue;
                return true;
            }
            return false;
        }
        if (type.func_75598_a() == IMob.class) {
            try {
                return this.isHostile();
            }
            catch (Exception e) {
                return true;
            }
        }
        return type.func_75598_a().isAssignableFrom(((Object)((Object)this)).getClass());
    }

    public boolean canMove() {
        return !this.isBlocking();
    }

    public boolean canWalk() {
        return true;
    }

    public boolean canWade() {
        return true;
    }

    public boolean canFloat() {
        return !this.func_70648_aU();
    }

    public boolean canDive() {
        return this.func_70648_aU();
    }

    public boolean isStrongSwimmer() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.swimmingOverride;
    }

    public boolean canJump() {
        return !this.isBlocking();
    }

    public boolean canClimb() {
        return false;
    }

    public boolean isFlying() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.flightOverride;
    }

    public int getFlyingHeight() {
        if (!this.isFlying()) {
            return 20;
        }
        return 0;
    }

    public boolean isSafeToLand() {
        if (this.field_70122_E) {
            return true;
        }
        if (this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a().func_76220_a()) {
            return true;
        }
        return this.func_130014_f_().func_180495_p(this.func_180425_c().func_177979_c(2)).func_185904_a().func_76220_a();
    }

    public double getFlightOffset() {
        return 0.0;
    }

    public boolean isCurrentlyFlying() {
        return this.isFlying();
    }

    public boolean canBeTempted() {
        if (this.isRareVariant() || this.spawnedAsBoss) {
            return false;
        }
        if (this.creatureInfo.isFarmable()) {
            return true;
        }
        if (this.isInPack() && !CreatureManager.getInstance().config.packTreatLuring) {
            return false;
        }
        return this.creatureInfo.isTameable();
    }

    public void onEat() {
    }

    public boolean canStealth() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.stealthOverride;
    }

    public float getStealth() {
        return this.getFloatFromDataManager(STEALTH);
    }

    public void setStealth(float setStealth) {
        setStealth = Math.min(setStealth, 1.0f);
        setStealth = Math.max(setStealth, 0.0f);
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(STEALTH, (Object)Float.valueOf(setStealth));
        }
    }

    public boolean isStealthed() {
        return this.getStealth() >= 1.0f;
    }

    public void startStealth() {
    }

    public void onStealth() {
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && this.func_70638_az() instanceof EntityLiving && ((EntityLiving)this.func_70638_az()).func_70638_az() != null) {
            ((EntityLiving)this.func_70638_az()).func_70624_b(null);
        }
    }

    public boolean func_70617_f_() {
        if (this.isFlying() || this.isStrongSwimmer() && this.func_70090_H()) {
            return false;
        }
        if (this.canClimb()) {
            return (this.getByteFromDataManager(CLIMBING) & 1) != 0;
        }
        return super.func_70617_f_();
    }

    public void setBesideClimbableBlock(boolean collided) {
        if (this.canClimb()) {
            byte climbing = this.getByteFromDataManager(CLIMBING);
            climbing = collided ? (byte)(climbing | 1) : (byte)(climbing & 0xFFFFFFFE);
            this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
        }
    }

    public boolean isBesideClimbableBlock() {
        return (this.getByteFromDataManager(CLIMBING) & 1) != 0;
    }

    public void func_180430_e(float fallDistance, float damageMultiplier) {
        if (this.isFlying()) {
            return;
        }
        fallDistance -= this.getFallResistance();
        if (this.getFallResistance() >= 100.0f) {
            fallDistance = 0.0f;
        }
        super.func_180430_e(fallDistance, damageMultiplier);
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
        if (!this.isFlying()) {
            super.func_184231_a(y, onGround, state, pos);
        }
    }

    public void setBlocking() {
        this.currentBlockingTime = this.blockingTime;
    }

    public boolean isBlocking() {
        if (this.func_130014_f_().field_72995_K) {
            return (this.getByteFromDataManager(ANIMATION_STATE) & ANIMATION_STATE_BITS.BLOCKING.id) > 0;
        }
        return this.currentBlockingTime > 0;
    }

    public boolean canAttackWhileBlocking() {
        return false;
    }

    public int getBlockingMultiplier() {
        return 4;
    }

    public boolean canPickupEntity(EntityLivingBase entity) {
        boolean heavyTarget;
        if (this.getPickupEntity() == entity) {
            return false;
        }
        if (entity instanceof IGroupBoss) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            if (((EntityPlayer)entity).func_184812_l_()) {
                return false;
            }
            if (((EntityPlayer)entity).func_175149_v()) {
                return false;
            }
        }
        if (entity instanceof BaseCreatureEntity && ((BaseCreatureEntity)entity).hasPickupEntity()) {
            return false;
        }
        if (CreatureManager.getInstance().creatureGroups.containsKey("boss") && CreatureManager.getInstance().creatureGroups.get("boss").hasEntity((Entity)entity)) {
            return false;
        }
        boolean bl = heavyTarget = entity instanceof IGroupHeavy || entity.field_70131_O >= 4.0f || entity.field_70130_N >= 4.0f;
        if (heavyTarget && !(this instanceof IGroupHeavy)) {
            return false;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity == null) {
            return false;
        }
        if (entity.func_184187_bx() != null && !(entity.func_184187_bx() instanceof EntityBoat) && !(entity.func_184187_bx() instanceof EntityMinecart) || entity.func_184179_bs() != null) {
            return false;
        }
        if (ObjectManager.getEffect("weight") != null && entity.func_70644_a((Potion)ObjectManager.getEffect("weight"))) {
            return false;
        }
        if (ObjectManager.getEffect("repulsion") != null && entity.func_70644_a((Potion)ObjectManager.getEffect("repulsion"))) {
            return false;
        }
        return extendedEntity.pickedUpByEntity == null || extendedEntity.pickedUpByEntity instanceof FearEntity;
    }

    public void pickupEntity(EntityLivingBase entity) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity((Entity)this);
        }
        this.pickupEntity = entity;
        this.clearMovement();
    }

    public EntityLivingBase getPickupEntity() {
        return this.pickupEntity;
    }

    public boolean hasPickupEntity() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.getPickupEntity() != null;
        }
        return (this.getByteFromDataManager(TARGET) & TARGET_BITS.PICKUP.id) > 0;
    }

    public void dropPickupEntity() {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
        if (extendedEntity != null) {
            extendedEntity.setPickedUpByEntity(null);
        }
        this.pickupEntity = null;
    }

    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, 0.0, 0.0};
    }

    public boolean canAttackWithPickup() {
        return false;
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop) {
        this.destroyArea(x, y, z, strength, drop, 0);
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop, int range) {
        this.destroyArea(x, y, z, strength, drop, range, null, 0);
    }

    public void destroyArea(int x, int y, int z, float strength, boolean drop, int range, EntityPlayer player, int chain) {
        range = Math.max(range - 1, 0);
        int w = -((int)Math.ceil(this.field_70130_N) - range);
        while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
            int d = -((int)Math.ceil(this.field_70130_N) - range);
            while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                int h = 0;
                while ((double)h <= Math.ceil(this.field_70131_O)) {
                    BlockPos breakPos = new BlockPos(x + w, y + h, z + d);
                    if (this.func_130014_f_().func_175625_s(breakPos) == null) {
                        IBlockState blockState = this.func_130014_f_().func_180495_p(breakPos);
                        float hardness = blockState.func_185887_b(this.func_130014_f_(), breakPos);
                        Material material = blockState.func_185904_a();
                        if (hardness >= 0.0f && strength >= hardness && strength >= blockState.func_177230_c().func_149638_a((Entity)this) && material != Material.field_151586_h && material != Material.field_151587_i && (player == null || w != 0 || h != 0 || d != 0)) {
                            SpawnerEventListener.getInstance().onBlockBreak(this.func_130014_f_(), breakPos, blockState, player, chain);
                            this.func_130014_f_().func_175655_b(breakPos, drop);
                        }
                    }
                    ++h;
                }
                ++d;
            }
            ++w;
        }
    }

    public void destroyAreaBlock(int x, int y, int z, Class<? extends Block> blockClass, boolean drop, int range) {
        int w = -((int)Math.ceil(this.field_70130_N) + range);
        while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
            int d = -((int)Math.ceil(this.field_70130_N) + range);
            while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                int h = 0;
                while ((double)h <= Math.ceil(this.field_70131_O)) {
                    IBlockState blockState;
                    BlockPos breakPos = new BlockPos(x + w, y + h, z + d);
                    if (this.func_130014_f_().func_175625_s(breakPos) == null && blockClass.isInstance((blockState = this.func_130014_f_().func_180495_p(breakPos)).func_177230_c())) {
                        this.func_130014_f_().func_175655_b(breakPos, drop);
                    }
                    ++h;
                }
                ++d;
            }
            ++w;
        }
    }

    public boolean extraAnimation01() {
        return this.extraAnimation01;
    }

    public void applyDebuffs(EntityLivingBase entity, int duration, int amplifier) {
        for (ElementInfo element : this.getElements()) {
            element.debuffEntity(entity, this.getEffectDuration(duration), this.getEffectAmplifier(amplifier));
        }
    }

    public void applyBuffs(EntityLivingBase entity, int duration, int amplifier) {
        if (this.creatureStats.getAmplifier() >= 0.0) {
            for (ElementInfo element : this.getElements()) {
                element.buffEntity(entity, this.getEffectDuration(duration), this.getEffectAmplifier(amplifier));
            }
        }
    }

    protected Item func_146068_u() {
        if (this.drops != null && this.drops.get(0) != null && !this.isMinion() && !this.isBoundPet()) {
            return this.drops.get(0).getItemStack().func_77973_b();
        }
        return null;
    }

    protected void func_70628_a(boolean playerKill, int lootingModifier) {
        if (this.func_130014_f_().field_72995_K || this.isMinion() || this.isBoundPet() || this.dropsRequirePlayerDamage) {
            return;
        }
        int variantScale = 1;
        if (this.isRareVariant()) {
            variantScale = Variant.RARE_DROP_SCALE;
        } else if (this.getVariant() != null && "uncommon".equals(this.getVariant().rarity)) {
            variantScale = Variant.UNCOMMON_DROP_SCALE;
        }
        for (ItemDrop itemDrop : this.drops) {
            int quantity;
            if (!this.canDropItem(itemDrop)) continue;
            int multiplier = 1;
            if (itemDrop.variantIndex < 0) {
                multiplier *= variantScale;
            }
            if (this.extraMobBehaviour != null && this.extraMobBehaviour.itemDropMultiplierOverride != 1.0) {
                multiplier = Math.round((float)multiplier * (float)this.extraMobBehaviour.itemDropMultiplierOverride);
            }
            if ((quantity = itemDrop.getQuantity(this.field_70146_Z, lootingModifier, multiplier)) <= 0) continue;
            this.dropItem(itemDrop.getEntityDropItemStack((EntityLivingBase)this, quantity));
        }
    }

    public boolean canDropItem(ItemDrop itemDrop) {
        if (itemDrop.subspeciesIndex >= 0 && itemDrop.subspeciesIndex != this.getSubspeciesIndex()) {
            return false;
        }
        return itemDrop.variantIndex < 0 || itemDrop.variantIndex == this.getVariantIndex();
    }

    public void dropItem(ItemStack itemStack) {
        this.func_70099_a(itemStack, 0.0f);
    }

    public EntityItem func_70099_a(ItemStack itemStack, float heightOffset) {
        if (itemStack.func_190916_E() != 0) {
            EntityItemCustom entityItem = new EntityItemCustom(this.func_130014_f_(), this.field_70165_t, this.field_70163_u + (double)heightOffset, this.field_70161_v, itemStack);
            entityItem.func_174867_a(10);
            this.applyDropEffects(entityItem);
            if (this.captureDrops) {
                this.capturedDrops.add(entityItem);
            } else {
                this.func_130014_f_().func_72838_d((Entity)entityItem);
            }
            return entityItem;
        }
        return null;
    }

    public void applyDropEffects(EntityItemCustom entityItem) {
    }

    public void setDropsRequirePlayerDamage(boolean requiresPlayerDamage) {
        this.dropsRequirePlayerDamage = requiresPlayerDamage;
    }

    public void perchOnEntity(EntityLivingBase target) {
        if (target == null) {
            ExtendedEntity extendedEntity;
            if (this.getPerchTarget() != null && (extendedEntity = ExtendedEntity.getForEntity(this.getPerchTarget())) != null) {
                extendedEntity.setPerchedByEntity(null);
            }
            this.setPerchTarget(null);
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(target);
        if (extendedEntity == null) {
            return;
        }
        this.setPerchTarget(target);
        extendedEntity.setPerchedByEntity((Entity)this);
    }

    public void openGUI(EntityPlayer player) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        this.addGUIViewer(player);
        this.refreshGUIViewers();
        this.openGUIToPlayer(player);
    }

    public void addGUIViewer(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.guiViewers.add(player);
        }
    }

    public void removeGUIViewer(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.guiViewers.remove(player);
        }
    }

    public void refreshGUIViewers() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.guiViewers.size() > 0) {
            for (EntityPlayer player : this.guiViewers.toArray(new EntityPlayer[this.guiViewers.size()])) {
                if (player.field_71070_bA == null || !(player.field_71070_bA instanceof CreatureContainer)) continue;
                if (((CreatureContainer)player.field_71070_bA).creature == this) {
                    this.openGUIToPlayer(player);
                    continue;
                }
                this.removeGUIViewer(player);
            }
        }
    }

    public void openGUIToPlayer(EntityPlayer player) {
        if (player != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.ENTITY.id, this.func_130014_f_(), this.func_145782_y(), 0, 0);
        }
    }

    public void scheduleGUIRefresh() {
        this.guiRefreshTick = this.guiRefreshTime + 1;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.hasPerchTarget()) {
            return false;
        }
        if (this.assessInteractCommand(this.getInteractCommands(player, player.func_184586_b(hand)), player, player.func_184586_b(hand))) {
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean assessInteractCommand(HashMap<Integer, String> commands, EntityPlayer player, ItemStack itemStack) {
        if (commands.isEmpty()) {
            return false;
        }
        int priority = 100;
        for (int testPriority : commands.keySet()) {
            if (testPriority >= priority) continue;
            priority = testPriority;
        }
        if (!commands.containsKey(priority)) {
            return false;
        }
        this.performCommand(commands.get(priority), player, itemStack);
        return true;
    }

    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Items.field_151058_ca && this.func_184652_a(player)) {
                commands.put(COMMAND_PIORITIES.ITEM_USE.id, "Leash");
            }
            if (itemStack.func_77973_b() == Items.field_151057_cb) {
                if (this.canNameTag(player)) {
                    return new HashMap<Integer, String>();
                }
                commands.put(COMMAND_PIORITIES.ITEM_USE.id, "Name Tag");
            }
            if (this.canBeColored(player) && itemStack.func_77973_b() == Items.field_151100_aR) {
                commands.put(COMMAND_PIORITIES.ITEM_USE.id, "Color");
            }
        }
        return commands;
    }

    public boolean performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        int colorID;
        if ("Leash".equals(command)) {
            this.func_110162_b((Entity)player, true);
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        if ("Color".equals(command) && (colorID = 15 - itemStack.func_77952_i()) != this.getColor()) {
            this.setColor(colorID);
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        return false;
    }

    public boolean canNameTag(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        if (this.getVariant() != null && !this.func_145818_k_()) {
            return this.renderVariantNameTag();
        }
        return super.func_94059_bO();
    }

    public boolean renderVariantNameTag() {
        return CreatureManager.getInstance().config.subspeciesTags;
    }

    public void consumePlayersItem(EntityPlayer player, ItemStack itemStack) {
        this.consumePlayersItem(player, itemStack, 1);
    }

    public void consumePlayersItem(EntityPlayer player, ItemStack itemStack, int amount) {
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - amount));
        }
        if (itemStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        }
    }

    public void replacePlayersItem(EntityPlayer player, ItemStack itemStack, ItemStack newStack) {
        this.replacePlayersItem(player, itemStack, 1, newStack);
    }

    public void replacePlayersItem(EntityPlayer player, ItemStack itemStack, int amount, ItemStack newStack) {
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - amount));
        }
        if (itemStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStack);
        } else if (!player.field_71071_by.func_70441_a(newStack)) {
            player.func_71019_a(newStack, false);
        }
    }

    public void performGUICommand(EntityPlayer player, byte guiCommandID) {
        this.scheduleGUIRefresh();
    }

    public boolean canCarryItems() {
        return this.getInventorySize() > 0;
    }

    public int getInventorySize() {
        return this.inventory.func_70302_i_();
    }

    public int getInventorySizeMax() {
        return Math.max(this.getNoBagSize(), this.getBagSize());
    }

    public boolean hasBag() {
        return this.inventory.getEquipmentStack("bag") != null;
    }

    public int getNoBagSize() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.inventorySizeOverride > 0) {
            return this.extraMobBehaviour.inventorySizeOverride;
        }
        return 0;
    }

    public int getBagSize() {
        if (this.creatureInfo != null) {
            return this.creatureInfo.bagSize;
        }
        return 5;
    }

    public boolean canPickupItems() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.itemPickupOverride;
    }

    public int getSpaceForStack(ItemStack pickupStack) {
        return this.inventory.getSpaceForStack(pickupStack);
    }

    public boolean canEquip() {
        return this.creatureInfo.isTameable();
    }

    public void setCurrentItemOrArmor(int slot, ItemStack itemStack) {
        String type = "item";
        if (slot == 0) {
            type = "weapon";
        }
        if (slot == 1) {
            type = "feet";
        }
        if (slot == 2) {
            type = "legs";
        }
        if (slot == 3) {
            type = "chest";
        }
        if (slot == 4) {
            type = "head";
        }
        if (slot == 100) {
            type = "bag";
        }
        this.inventory.setEquipmentStack(type, itemStack);
    }

    public String getEquipmentName(String type) {
        if (this.inventory.getEquipmentGrade(type) != null) {
            return type + this.inventory.getEquipmentGrade(type);
        }
        return null;
    }

    public int func_70658_aO() {
        return super.func_70658_aO() + this.inventory.getArmorValue();
    }

    public void pickupItems() {
        List list = this.func_130014_f_().func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
        for (EntityItem entityItem : list) {
            ItemStack itemStack;
            int space;
            if (entityItem.field_70128_L || entityItem.func_92059_d() == null || (space = this.getSpaceForStack(itemStack = entityItem.func_92059_d())) <= 0) continue;
            this.onPickupStack(itemStack);
            this.doItemPickup(entityItem);
        }
    }

    public void onPickupStack(ItemStack itemStack) {
    }

    public void doItemPickup(EntityItem entityItem) {
        if (!entityItem.field_70128_L && entityItem.func_92059_d() != null) {
            ItemStack leftoverStack = this.inventory.autoInsertStack(entityItem.func_92059_d());
            if (leftoverStack != null) {
                entityItem.func_92058_a(leftoverStack);
            } else {
                entityItem.func_70106_y();
            }
        }
    }

    public void onBlockPlaced(BlockPos blockPos, IBlockState blockState) {
    }

    public void onBuildTaskComplete(CreatureBuildTask buildTask) {
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.damageLimit > 0.0f && this.damageTakenThisSec >= this.damageLimit) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (("inWall".equals(type) || "cactus".equals(type)) && (this.isRareVariant() || this.isBoss())) {
            return false;
        }
        if ("inWall".equals(type)) {
            return !CreatureManager.getInstance().config.suffocationImmunity && !this.hasPerchTarget();
        }
        if ("drown".equals(type)) {
            return !CreatureManager.getInstance().config.drownImmunity;
        }
        if ("fall".equals(type)) {
            return this.getFallResistance() < 100.0f;
        }
        return true;
    }

    public boolean isDamageEntityApplicable(Entity entity) {
        if (this.isBoss() || this.isRareVariant()) {
            if (entity == null) {
                return false;
            }
            if (this.func_70032_d(entity) > (float)this.bossRange) {
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(LanguageManager.translate("boss.damage.protection.range")), true);
                }
                return false;
            }
        }
        return true;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        for (ElementInfo element : this.getElements()) {
            if (element.isEffectApplicable(potionEffect)) continue;
            return false;
        }
        return true;
    }

    public boolean canBurn() {
        if (this.extraMobBehaviour != null && this.extraMobBehaviour.fireImmunityOverride) {
            return false;
        }
        for (ElementInfo element : this.getElements()) {
            if (element.canBurn()) continue;
            return false;
        }
        return true;
    }

    public boolean daylightBurns() {
        return false;
    }

    public boolean canFreeze() {
        if (this instanceof IGroupIce) {
            return false;
        }
        for (ElementInfo element : this.getElements()) {
            if (element.canFreeze()) continue;
            return false;
        }
        return true;
    }

    public boolean waterDamage() {
        return false;
    }

    public boolean webProof() {
        return false;
    }

    public void func_70110_aj() {
        if (!this.webProof()) {
            super.func_70110_aj();
        }
    }

    public boolean canBreatheAir() {
        return true;
    }

    public boolean func_70648_aU() {
        return this.extraMobBehaviour != null && this.extraMobBehaviour.waterBreathingOverride;
    }

    public boolean canBreatheUnderlava() {
        return true;
    }

    public void func_70050_g(int air) {
        if (air == 300 && !this.canBreatheAir()) {
            return;
        }
        super.func_70050_g(air);
    }

    public boolean func_70090_H() {
        if (this.isLavaCreature && this.field_70130_N <= 2.0f) {
            return this.func_180799_ab() || super.func_70090_H();
        }
        return super.func_70090_H();
    }

    public boolean waterContact() {
        if (this.func_70026_G()) {
            return true;
        }
        return this.func_130014_f_().func_72896_J() && !this.isBlockUnderground((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
    }

    public boolean lavaContact() {
        return this.func_180799_ab();
    }

    public boolean canBreatheAtLocation(BlockPos pos) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(pos);
        if (blockState == null) {
            return true;
        }
        if (this.canBreatheAir() && blockState.func_185904_a() == Material.field_151579_a) {
            return true;
        }
        if (this.func_70648_aU()) {
            if (!this.isLavaCreature && blockState.func_185904_a() == Material.field_151586_h) {
                return true;
            }
            if (this.isLavaCreature && blockState.func_185904_a() == Material.field_151587_i) {
                return true;
            }
        }
        return false;
    }

    public boolean isSwimmable(int x, int y, int z) {
        IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
        if (blockState == null) {
            return false;
        }
        if (this.isLavaCreature && Material.field_151587_i.equals(blockState.func_185904_a())) {
            return true;
        }
        return Material.field_151586_h.equals(blockState.func_185904_a());
    }

    public float getFallResistance() {
        return 0.0f;
    }

    public byte testLightLevel() {
        return this.testLightLevel(this.func_180425_c());
    }

    public byte testLightLevel(BlockPos pos) {
        IBlockState spawnBlockState = this.func_130014_f_().func_180495_p(pos);
        if (pos.func_177956_o() < 0) {
            return 0;
        }
        pos = spawnBlockState.func_185904_a() == Material.field_151586_h && CreatureManager.getInstance().spawnConfig.useSurfaceLightLevel ? new BlockPos(pos.func_177958_n(), this.getWaterSurfaceY(pos), pos.func_177952_p()) : new BlockPos(pos.func_177958_n(), this.getGroundY(pos), pos.func_177952_p());
        int light = this.func_130014_f_().func_175671_l(pos);
        if (this.func_130014_f_().func_72911_I()) {
            int originalSkylight = this.func_130014_f_().func_175657_ab();
            this.func_130014_f_().func_175692_b(10);
            light = this.func_130014_f_().func_175671_l(pos);
            this.func_130014_f_().func_175692_b(originalSkylight);
        }
        if (light == 0) {
            return 0;
        }
        if (light <= 7) {
            return 1;
        }
        if (light <= 14) {
            return 2;
        }
        return 3;
    }

    public boolean isDaytime() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.func_130014_f_().func_72935_r();
        }
        long time = this.func_130014_f_().func_72820_D();
        if (time < 12500L) {
            return true;
        }
        return time < 12542L || time >= 23460L;
    }

    public int nearbyCreatureCount(Class targetClass, double range) {
        return this.getNearbyEntities(Entity.class, (Predicate<Entity>)((Predicate)entity -> targetClass == null || targetClass.isAssignableFrom(entity.getClass())), range).size();
    }

    public int countAllies(double range) {
        return this.getNearbyEntities(Entity.class, (Predicate<Entity>)((Predicate)entity -> ((Object)((Object)this)).getClass().isAssignableFrom(entity.getClass()) && entity instanceof BaseCreatureEntity && this.isTamed() == ((BaseCreatureEntity)((Object)entity)).isTamed()), range).size();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.attribute;
    }

    public double getMountedXOffset() {
        if (this.getSubspecies() != null && this.getSubspecies().mountOffset != null) {
            return (double)this.field_70130_N * this.getSubspecies().mountOffset.field_72450_a;
        }
        return (double)this.field_70130_N * this.creatureInfo.mountOffset.field_72450_a;
    }

    public double func_70042_X() {
        if (this.getSubspecies() != null && this.getSubspecies().mountOffset != null) {
            return (double)this.field_70131_O * this.getSubspecies().mountOffset.field_72448_b;
        }
        return (double)this.field_70131_O * this.creatureInfo.mountOffset.field_72448_b;
    }

    public double getMountedZOffset() {
        if (this.getSubspecies() != null && this.getSubspecies().mountOffset != null) {
            return (double)this.field_70130_N * this.getSubspecies().mountOffset.field_72449_c;
        }
        return (double)this.field_70130_N * this.creatureInfo.mountOffset.field_72449_c;
    }

    public <T extends Entity> List<T> getNearbyEntities(Class<? extends T> clazz, Predicate<Entity> predicate, double range) {
        return this.func_130014_f_().func_175647_a(clazz, this.func_174813_aQ().func_72314_b(range, range, range), predicate);
    }

    public <T extends Entity> T getNearestEntity(Class<? extends T> clazz, Class filterClass, double range, boolean canAttack) {
        List<T> aoeTargets = this.getNearbyEntities(clazz, (Predicate<Entity>)((Predicate)entity -> filterClass == null || filterClass.isAssignableFrom(entity.getClass())), range);
        if (aoeTargets.size() == 0) {
            return null;
        }
        double nearestDistance = range + 10.0;
        Entity nearestEntity = null;
        for (T entityObj : aoeTargets) {
            double distance;
            Entity targetEntity = (Entity)entityObj;
            if (targetEntity == this || !(targetEntity instanceof EntityLivingBase) || canAttack && !this.canAttackEntity((EntityLivingBase)targetEntity) || targetEntity == this.func_184179_bs() || !((distance = (double)this.func_70032_d(targetEntity)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestEntity = targetEntity;
        }
        return (T)nearestEntity;
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        int i;
        if (this.creatureInfo.dummy) {
            super.func_70037_a(nbtTagCompound);
            return;
        }
        this.firstSpawn = nbtTagCompound.func_74764_b("FirstSpawn") ? nbtTagCompound.func_74767_n("FirstSpawn") : true;
        if (nbtTagCompound.func_74764_b("SpawnEventType")) {
            this.spawnEventType = nbtTagCompound.func_74779_i("SpawnEventType");
        }
        if (nbtTagCompound.func_74764_b("SpawnEventCount")) {
            this.spawnEventCount = nbtTagCompound.func_74762_e("SpawnEventCount");
        }
        if (nbtTagCompound.func_74764_b("Stealth")) {
            this.setStealth(nbtTagCompound.func_74760_g("Stealth"));
        }
        if (nbtTagCompound.func_74764_b("IsMinion")) {
            this.setMinion(nbtTagCompound.func_74767_n("IsMinion"));
        }
        if (nbtTagCompound.func_74764_b("IsTemporary") && nbtTagCompound.func_74767_n("IsTemporary") && nbtTagCompound.func_74764_b("TemporaryDuration")) {
            this.setTemporary(nbtTagCompound.func_74762_e("TemporaryDuration"));
        } else {
            this.unsetTemporary();
        }
        if (nbtTagCompound.func_74764_b("IsBoundPet") && nbtTagCompound.func_74767_n("IsBoundPet") && !this.hasPetEntry()) {
            this.func_70106_y();
        }
        if (nbtTagCompound.func_74764_b("ForceNoDespawn")) {
            this.forceNoDespawn = nbtTagCompound.func_74767_n("ForceNoDespawn");
        }
        if (nbtTagCompound.func_74764_b("Color")) {
            this.setColor(nbtTagCompound.func_74771_c("Color"));
        }
        if (nbtTagCompound.func_74764_b("Size")) {
            this.setSizeScale(nbtTagCompound.func_74769_h("Size"));
        }
        if (!this.firstSpawn && nbtTagCompound.func_74764_b("Subspecies") && !nbtTagCompound.func_74764_b("Variant")) {
            this.setSubspecies(Variant.getIndexFromOld(nbtTagCompound.func_74771_c("Subspecies")));
            this.setVariant(Variant.getIndexFromOld(nbtTagCompound.func_74771_c("Subspecies")));
        } else {
            if (nbtTagCompound.func_74764_b("Subspecies")) {
                this.setSubspecies(nbtTagCompound.func_74771_c("Subspecies"));
            }
            if (nbtTagCompound.func_74764_b("Variant")) {
                if (this.firstSpawn) {
                    this.applyVariant(nbtTagCompound.func_74771_c("Variant"));
                } else {
                    this.setVariant(nbtTagCompound.func_74771_c("Variant"));
                }
            }
        }
        if (nbtTagCompound.func_74764_b("MobLevel")) {
            if (this.firstSpawn) {
                this.applyLevel(nbtTagCompound.func_74762_e("MobLevel"));
            } else {
                this.setLevel(nbtTagCompound.func_74762_e("MobLevel"));
            }
        }
        if (nbtTagCompound.func_74764_b("Experience")) {
            this.setExperience(nbtTagCompound.func_74762_e("Experience"));
        }
        if (nbtTagCompound.func_74764_b("SpawnedAsBoss")) {
            this.spawnedAsBoss = nbtTagCompound.func_74767_n("SpawnedAsBoss");
        }
        if (nbtTagCompound.func_74764_b("SpawnedWithBlockProtection")) {
            this.spawnedWithBlockProtection = nbtTagCompound.func_74762_e("SpawnedWithBlockProtection");
        }
        super.func_70037_a(nbtTagCompound);
        this.relationships.load(nbtTagCompound);
        this.inventory.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Drops")) {
            NBTTagList nbtDropList = nbtTagCompound.func_150295_c("Drops", 10);
            for (i = 0; i < nbtDropList.func_74745_c(); ++i) {
                NBTTagCompound dropNBT = nbtDropList.func_150305_b(i);
                ItemDrop drop = new ItemDrop(dropNBT);
                this.addSavedItemDrop(drop);
            }
        }
        if (nbtTagCompound.func_74764_b("DropsRequirePlayerDamage")) {
            this.dropsRequirePlayerDamage = nbtTagCompound.func_74767_n("DropsRequirePlayerDamage");
        }
        if (nbtTagCompound.func_74764_b("ExtraBehaviour")) {
            this.extraMobBehaviour.readFromNBT(nbtTagCompound.func_74775_l("ExtraBehaviour"));
        }
        if (nbtTagCompound.func_74764_b("HomeX") && nbtTagCompound.func_74764_b("HomeY") && nbtTagCompound.func_74764_b("HomeZ") && nbtTagCompound.func_74764_b("HomeDistanceMax")) {
            this.setHome(nbtTagCompound.func_74762_e("HomeX"), nbtTagCompound.func_74762_e("HomeY"), nbtTagCompound.func_74762_e("HomeZ"), nbtTagCompound.func_74760_g("HomeDistanceMax"));
        }
        if (nbtTagCompound.func_74764_b("ArenaX") && nbtTagCompound.func_74764_b("ArenaY") && nbtTagCompound.func_74764_b("ArenaZ")) {
            this.setArenaCenter(new BlockPos(nbtTagCompound.func_74762_e("ArenaX"), nbtTagCompound.func_74762_e("ArenaY"), nbtTagCompound.func_74762_e("ArenaZ")));
        }
        if (nbtTagCompound.func_74764_b("FixateUUIDMost") && nbtTagCompound.func_74764_b("FixateUUIDLeast")) {
            this.fixateUUID = new UUID(nbtTagCompound.func_74763_f("FixateUUIDMost"), nbtTagCompound.func_74763_f("FixateUUIDLeast"));
        }
        if (nbtTagCompound.func_74764_b("MinionIds")) {
            NBTTagList minionIds = nbtTagCompound.func_150295_c("MinionIds", 10);
            for (i = 0; i < minionIds.func_74745_c(); ++i) {
                Entity entity;
                NBTTagCompound minionId = minionIds.func_150305_b(i);
                if (!minionId.func_74764_b("ID") || !((entity = this.func_130014_f_().func_73045_a(minionId.func_74762_e("ID"))) instanceof EntityLivingBase)) continue;
                this.addMinion((EntityLivingBase)entity);
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        if (this.creatureInfo.dummy) {
            super.func_70014_b(nbtTagCompound);
            return;
        }
        nbtTagCompound.func_74757_a("FirstSpawn", this.firstSpawn);
        nbtTagCompound.func_74778_a("SpawnEventType", this.spawnEventType);
        nbtTagCompound.func_74768_a("SpawnEventCount", this.spawnEventCount);
        nbtTagCompound.func_74776_a("Stealth", this.getStealth());
        nbtTagCompound.func_74757_a("IsMinion", this.isMinion());
        nbtTagCompound.func_74757_a("IsTemporary", this.isTemporary);
        nbtTagCompound.func_74768_a("TemporaryDuration", this.temporaryDuration);
        nbtTagCompound.func_74757_a("IsBoundPet", this.isBoundPet());
        nbtTagCompound.func_74757_a("ForceNoDespawn", this.forceNoDespawn);
        nbtTagCompound.func_74774_a("Color", (byte)this.getColor());
        nbtTagCompound.func_74774_a("Subspecies", (byte)this.getSubspeciesIndex());
        nbtTagCompound.func_74774_a("Variant", (byte)this.getVariantIndex());
        nbtTagCompound.func_74780_a("Size", this.sizeScale);
        nbtTagCompound.func_74768_a("MobLevel", this.getLevel());
        nbtTagCompound.func_74768_a("Experience", this.getExperience());
        nbtTagCompound.func_74757_a("SpawnedAsBoss", this.spawnedAsBoss);
        nbtTagCompound.func_74768_a("SpawnedWithBlockProtection", this.spawnedWithBlockProtection);
        if (this.hasHome()) {
            BlockPos homePos = this.getHomePosition();
            nbtTagCompound.func_74768_a("HomeX", homePos.func_177958_n());
            nbtTagCompound.func_74768_a("HomeY", homePos.func_177956_o());
            nbtTagCompound.func_74768_a("HomeZ", homePos.func_177952_p());
            nbtTagCompound.func_74776_a("HomeDistanceMax", this.getHomeDistanceMax());
        }
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            nbtTagCompound.func_74768_a("ArenaX", arenaPos.func_177958_n());
            nbtTagCompound.func_74768_a("ArenaY", arenaPos.func_177956_o());
            nbtTagCompound.func_74768_a("ArenaZ", arenaPos.func_177952_p());
        }
        if (this.getFixateTarget() != null) {
            nbtTagCompound.func_74772_a("FixateUUIDMost", this.getFixateTarget().func_110124_au().getMostSignificantBits());
            nbtTagCompound.func_74772_a("FixateUUIDLeast", this.getFixateTarget().func_110124_au().getLeastSignificantBits());
        }
        super.func_70014_b(nbtTagCompound);
        this.relationships.save(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
        NBTTagList nbtDropList = new NBTTagList();
        for (ItemDrop drop : this.savedDrops) {
            NBTTagCompound dropNBT;
            if (!drop.writeToNBT(dropNBT = new NBTTagCompound())) continue;
            nbtDropList.func_74742_a((NBTBase)dropNBT);
        }
        nbtTagCompound.func_74782_a("Drops", (NBTBase)nbtDropList);
        nbtTagCompound.func_74757_a("DropsRequirePlayerDamage", this.dropsRequirePlayerDamage);
        NBTTagCompound extTagCompound = new NBTTagCompound();
        this.extraMobBehaviour.writeToNBT(extTagCompound);
        nbtTagCompound.func_74782_a("ExtraBehaviour", (NBTBase)extTagCompound);
        NBTTagList minionIds = new NBTTagList();
        for (EntityLivingBase minion : this.minions) {
            NBTTagCompound minionId = new NBTTagCompound();
            minionId.func_74768_a("ID", minion.func_145782_y());
            minionIds.func_74742_a((NBTBase)minionId);
        }
        nbtTagCompound.func_74782_a("MinionIds", (NBTBase)minionIds);
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public boolean isAttackOnCooldown() {
        return this.getAttackCooldown() > 0;
    }

    public void triggerAttackCooldown() {
        this.attackCooldown = this.getAttackCooldownMax();
    }

    public void resetAttackCooldown() {
        this.attackCooldown = 0;
        this.setAttackCooldownMax(this.getAttackCooldownMax());
    }

    public int getAttackCooldownMax() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.attackCooldownMax;
        }
        return this.getIntFromDataManager(ANIMATION_ATTACK_COOLDOWN_MAX);
    }

    public void setAttackCooldownMax(int cooldownMax) {
        this.attackCooldownMax = cooldownMax;
        if (!this.func_130014_f_().field_72995_K) {
            this.func_184212_Q().func_187227_b(ANIMATION_ATTACK_COOLDOWN_MAX, (Object)this.attackCooldownMax);
        }
    }

    public ResourceLocation getTexture() {
        return this.getTexture("");
    }

    public ResourceLocation getTexture(String suffix) {
        String textureName = this.getTextureName();
        if (this.getSubspecies().name != null) {
            textureName = textureName + "_" + this.getSubspecies().name;
        }
        if (this.getVariant() != null) {
            textureName = textureName + "_" + this.getVariant().color;
        }
        if (!"".equals(suffix)) {
            textureName = textureName + "_" + suffix;
        }
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public ResourceLocation getEquipmentTexture(String equipmentName) {
        if (!this.canEquip()) {
            return this.getTexture();
        }
        if (this.getSubspecies() != null && this.getSubspecies().name != null) {
            equipmentName = this.getSubspecies().name + "_" + equipmentName;
        }
        return this.getSubTexture(equipmentName);
    }

    public ResourceLocation getSubTexture(String subName) {
        subName = subName.toLowerCase();
        String textureName = this.getTextureName();
        if (AssetManager.getTexture(textureName = textureName + "_" + subName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }

    public String getTextureName() {
        return this.creatureInfo.getName();
    }

    public boolean canBeColored(EntityPlayer player) {
        return false;
    }

    public int getColor() {
        return this.getByteFromDataManager(COLOR) & 0xF;
    }

    public void setColor(int color) {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(COLOR, (Object)((byte)(color & 0xF)));
        }
    }

    public boolean showBossInfo() {
        if (this.forceBossHealthBar || this.isBoss()) {
            return true;
        }
        if (this.isRareVariant()) {
            return Variant.RARE_HEALTH_BARS;
        }
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.getBossInfo() != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        if (this.getBossInfo() != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    protected float func_70599_aP() {
        if (this.isBoss()) {
            return 4.0f;
        }
        if (this.isRareVariant()) {
            return 2.0f;
        }
        return 1.0f;
    }

    public String getSoundName() {
        String soundSuffix = "";
        if (this.getSubspecies() != null && this.getSubspecies().name != null) {
            soundSuffix = soundSuffix + "." + this.getSubspecies().name;
        }
        return this.creatureInfo.getName() + soundSuffix;
    }

    public int func_70627_aG() {
        return CreatureManager.getInstance().config.idleSoundTicks;
    }

    protected SoundEvent func_184639_G() {
        return AssetManager.getSound(this.getSoundName() + "_say");
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return AssetManager.getSound(this.getSoundName() + "_hurt");
    }

    protected SoundEvent func_184615_bR() {
        return AssetManager.getSound(this.getSoundName() + "_death");
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.isCurrentlyFlying()) {
            return;
        }
        if (!this.hasStepSound) {
            super.func_180429_a(pos, block);
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_step"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    public void playJumpSound() {
        if (!this.hasJumpSound) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_jump"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playFlySound() {
        if (!this.isFlying() || this.hasPerchTarget()) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_fly"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playAttackSound() {
        if (!this.hasAttackSound) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_attack"), this.func_70599_aP(), 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playPhaseSound() {
        if (AssetManager.getSound(this.creatureInfo.getName() + "_phase") == null) {
            return;
        }
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_phase"), this.func_70599_aP() * 2.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void func_184185_a(SoundEvent sound, float volume, float pitch) {
        super.func_184185_a(sound, volume, pitch);
    }

    public class GroupData
    implements IEntityLivingData {
        public boolean isChild;

        public GroupData(boolean child) {
            this.isChild = child;
        }
    }

    public static enum PET_COMMAND_ID {
        ACTIVE(0),
        TELEPORT(1),
        PVP(2),
        RELEASE(3),
        PASSIVE(4),
        DEFENSIVE(5),
        ASSIST(6),
        AGGRESSIVE(7),
        FOLLOW(8),
        WANDER(9),
        SIT(10),
        FLEE(11);

        public byte id;

        private PET_COMMAND_ID(byte i) {
            this.id = i;
        }
    }

    public static enum GUI_COMMAND {
        CLOSE(0),
        SITTING(1),
        FOLLOWING(2),
        PASSIVE(3),
        STANCE(4),
        PVP(5),
        TELEPORT(6),
        SPAWNING(7),
        RELEASE(8);

        public byte id;

        private GUI_COMMAND(byte i) {
            this.id = i;
        }
    }

    public static enum COMMAND_PIORITIES {
        OVERRIDE(0),
        IMPORTANT(1),
        EQUIPPING(2),
        ITEM_USE(3),
        EMPTY_HAND(4),
        MAIN(5);

        public final int id;

        private COMMAND_PIORITIES(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum TARGET_TYPES {
        ENEMY(1),
        ALLY(2),
        SELF(4);

        public final byte id;

        private TARGET_TYPES(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }

    public static enum ANIMATION_STATE_BITS {
        ATTACKED(1),
        GROUNDED(2),
        IN_WATER(4),
        BLOCKING(8),
        MINION(16),
        EXTRA01(32),
        BOSS(64);

        public final byte id;

        private ANIMATION_STATE_BITS(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }

    public static enum TARGET_BITS {
        ATTACK(1),
        MASTER(2),
        PARENT(4),
        AVOID(8),
        RIDER(16),
        PICKUP(32),
        PERCH(64);

        public final byte id;

        private TARGET_BITS(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

