/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.CreatureRelationships;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;

public class CreatureRelationshipEntry {
    protected CreatureRelationships creatureRelationships;
    protected UUID targetEntityUUID;
    protected int reputation = 0;

    public CreatureRelationshipEntry(CreatureRelationships creatureRelationships) {
        this.creatureRelationships = creatureRelationships;
    }

    public int getReputation() {
        return this.reputation;
    }

    public void setReputation(int reputation) {
        this.reputation = reputation;
        this.creatureRelationships.getCreatureEntity().queueSync();
    }

    public boolean increaseReputation(int amount) {
        int max = this.creatureRelationships.getCreatureEntity().creatureInfo.getTamingReputation();
        int min = -this.creatureRelationships.getCreatureEntity().creatureInfo.getTamingReputation();
        if (this.reputation >= max) {
            return false;
        }
        this.reputation = Math.max(Math.min(this.reputation + amount, max), min);
        this.creatureRelationships.getCreatureEntity().queueSync();
        return true;
    }

    public boolean decreaseReputation(int amount) {
        int max = this.creatureRelationships.getCreatureEntity().creatureInfo.getTamingReputation();
        int min = -this.creatureRelationships.getCreatureEntity().creatureInfo.getTamingReputation();
        if (this.reputation <= min) {
            return false;
        }
        this.reputation = Math.max(Math.min(this.reputation - amount, max), min);
        this.creatureRelationships.getCreatureEntity().queueSync();
        return true;
    }

    public boolean canAttack() {
        return this.reputation < this.creatureRelationships.getCreatureEntity().creatureInfo.getTamingReputation();
    }

    public boolean canHunt() {
        return this.reputation < this.creatureRelationships.getCreatureEntity().creatureInfo.getFriendlyReputation();
    }

    public boolean shouldDefend() {
        return this.reputation >= this.creatureRelationships.getCreatureEntity().creatureInfo.getFriendlyReputation();
    }

    public UUID getTargetEntityUUID() {
        return this.targetEntityUUID;
    }

    public void setTarget(Entity entity) {
        this.targetEntityUUID = entity.func_110124_au();
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_186855_b("TargetUUID")) {
            this.targetEntityUUID = nbt.func_186857_a("TargetUUID");
        }
        if (nbt.func_74764_b("Reputation")) {
            this.reputation = nbt.func_74762_e("Reputation");
        }
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_186854_a("TargetUUID", this.targetEntityUUID);
        nbt.func_74768_a("Reputation", this.reputation);
    }
}

