/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CreatureRelationships {
    protected BaseCreatureEntity creatureEntity;
    protected Map<UUID, CreatureRelationshipEntry> relationships = new HashMap<UUID, CreatureRelationshipEntry>();

    public CreatureRelationships(BaseCreatureEntity creatureEntity) {
        this.creatureEntity = creatureEntity;
    }

    @Nullable
    public CreatureRelationshipEntry getEntry(Entity entity) {
        if (this.relationships.containsKey(entity.func_110124_au())) {
            return this.relationships.get(entity.func_110124_au());
        }
        return null;
    }

    public List<EntityPlayer> getPlayers() {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        if (this.getCreatureEntity().func_130014_f_().field_72995_K) {
            return players;
        }
        for (CreatureRelationshipEntry relationshipEntry : this.relationships.values()) {
            EntityPlayer player = this.getCreatureEntity().func_130014_f_().func_152378_a(relationshipEntry.getTargetEntityUUID());
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public CreatureRelationshipEntry getOrCreateEntry(Entity entity) {
        CreatureRelationshipEntry relationshipEntry = this.getEntry(entity);
        if (relationshipEntry == null) {
            relationshipEntry = new CreatureRelationshipEntry(this);
            relationshipEntry.setTarget(entity);
            this.relationships.put(relationshipEntry.getTargetEntityUUID(), relationshipEntry);
        }
        return relationshipEntry;
    }

    public BaseCreatureEntity getCreatureEntity() {
        return this.creatureEntity;
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("CreatureRelationships")) {
            this.relationships.clear();
            NBTTagList relationshipNbtList = nbt.func_150295_c("CreatureRelationships", 10);
            for (int i = 0; i < relationshipNbtList.func_74745_c(); ++i) {
                NBTTagCompound relationshipNbt = relationshipNbtList.func_150305_b(i);
                CreatureRelationshipEntry creatureRelationshipEntry = new CreatureRelationshipEntry(this);
                creatureRelationshipEntry.load(relationshipNbt);
                this.relationships.put(creatureRelationshipEntry.getTargetEntityUUID(), creatureRelationshipEntry);
            }
        }
    }

    public void save(NBTTagCompound nbt) {
        NBTTagList relationshipNbtList = new NBTTagList();
        boolean i = false;
        for (CreatureRelationshipEntry creatureRelationshipEntry : this.relationships.values()) {
            NBTTagCompound relationshipNbt = new NBTTagCompound();
            creatureRelationshipEntry.save(relationshipNbt);
            relationshipNbtList.func_74742_a((NBTBase)relationshipNbt);
        }
        nbt.func_74782_a("CreatureRelationships", (NBTBase)relationshipNbtList);
    }
}

