/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.core.capabilities.IExtendedEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.network.MessageEntityPerched;
import com.lycanitesmobs.core.network.MessageEntityPickedUp;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.Vec3d;

public class ExtendedEntity
implements IExtendedEntity {
    public static Map<Entity, ExtendedEntity> clientExtendedEntities = new HashMap<Entity, ExtendedEntity>();
    public static String[] FORCE_REMOVE_ENTITY_IDS;
    public static int FORCE_REMOVE_ENTITY_TICKS;
    public EntityLivingBase entity;
    protected Map<String, Integer> projectileCooldownsPrimary = new HashMap<String, Integer>();
    protected Map<String, Integer> projectileCooldownsSecondary = new HashMap<String, Integer>();
    Vector3d lastSafePos;
    private boolean playerAllowFlyingSnapshot;
    private boolean playerIsFlyingSnapshot;
    public EntityLivingBase lastAttackedEntity;
    public int lastAttackedTime = 0;
    public Entity pickedUpByEntity;
    public Entity perchedByEntity;
    public boolean perchedEntityNoclip = false;
    public FearEntity fearEntity;
    boolean forceRemoveChecked = false;
    boolean forceRemove = false;
    int forceRemoveTicks = FORCE_REMOVE_ENTITY_TICKS;

    public static ExtendedEntity getForEntity(EntityLivingBase entity) {
        if (entity == null) {
            return null;
        }
        if (entity.func_130014_f_() != null && entity.func_130014_f_().field_72995_K) {
            if (clientExtendedEntities.containsKey(entity)) {
                ExtendedEntity extendedEntity = clientExtendedEntities.get(entity);
                extendedEntity.setEntity(entity);
                return extendedEntity;
            }
            ExtendedEntity extendedEntity = new ExtendedEntity();
            extendedEntity.setEntity(entity);
            clientExtendedEntities.put((Entity)entity, extendedEntity);
        }
        IExtendedEntity iExtendedEntity = null;
        try {
            iExtendedEntity = (IExtendedEntity)entity.getCapability(LycanitesMobs.EXTENDED_ENTITY, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iExtendedEntity == null || !(iExtendedEntity instanceof ExtendedEntity)) {
            return null;
        }
        ExtendedEntity extendedEntity = (ExtendedEntity)iExtendedEntity;
        if (extendedEntity.getEntity() != entity) {
            extendedEntity.setEntity(entity);
        }
        return extendedEntity;
    }

    public void setEntity(EntityLivingBase entity) {
        this.entity = entity;
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public void setLastAttackedEntity(EntityLivingBase target) {
        this.lastAttackedEntity = target;
        this.lastAttackedTime = this.entity.field_70173_aa;
    }

    public void onUpdate() {
        int cooldownValue;
        if (this.entity == null) {
            return;
        }
        for (String cooldownName : this.projectileCooldownsPrimary.keySet()) {
            cooldownValue = this.projectileCooldownsPrimary.get(cooldownName);
            if (cooldownValue <= 0) continue;
            this.projectileCooldownsPrimary.put(cooldownName, cooldownValue - 1);
        }
        for (String cooldownName : this.projectileCooldownsSecondary.keySet()) {
            cooldownValue = this.projectileCooldownsSecondary.get(cooldownName);
            if (cooldownValue <= 0) continue;
            this.projectileCooldownsSecondary.put(cooldownName, cooldownValue - 1);
        }
        if (!this.entity.func_130014_f_().field_72995_K && FORCE_REMOVE_ENTITY_IDS != null && FORCE_REMOVE_ENTITY_IDS.length > 0 && !this.forceRemoveChecked) {
            LycanitesMobs.logDebug("ForceRemoveEntity", "Forced entity removal, checking: " + this.entity.func_70005_c_());
            for (String forceRemoveID : FORCE_REMOVE_ENTITY_IDS) {
                if (!forceRemoveID.equalsIgnoreCase(this.entity.func_70005_c_())) continue;
                this.forceRemove = true;
                break;
            }
            this.forceRemoveChecked = true;
        }
        if (this.forceRemove && this.forceRemoveTicks-- <= 0) {
            this.entity.func_70106_y();
        }
        if (this.lastSafePos == null) {
            this.lastSafePos = new Vector3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        }
        if (!this.entity.func_130014_f_().func_180495_p(this.entity.func_180425_c()).func_185904_a().func_76220_a()) {
            this.lastSafePos.set(Math.floor(this.entity.field_70165_t) + 0.5, (double)this.entity.func_180425_c().func_177956_o(), Math.floor(this.entity.field_70161_v) + 0.5);
        }
        if (this.fearEntity != null && !this.fearEntity.func_70089_S()) {
            this.fearEntity = null;
        }
        try {
            this.updatePickedUpByEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.updatedPerchedByEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDeath() {
        this.setPickedUpByEntity(null);
    }

    public void updatePickedUpByEntity() {
        if (this.pickedUpByEntity == null) {
            return;
        }
        if (!this.entity.func_130014_f_().field_72995_K) {
            if (!this.pickedUpByEntity.func_70089_S()) {
                this.setPickedUpByEntity(null);
                return;
            }
            if (this.pickedUpByEntity instanceof EntityLivingBase && ((EntityLivingBase)this.pickedUpByEntity).func_110143_aJ() <= 0.0f) {
                this.setPickedUpByEntity(null);
                return;
            }
            PotionBase weight = ObjectManager.getEffect("weight");
            if (weight != null && this.entity.func_70644_a((Potion)weight)) {
                this.setPickedUpByEntity(null);
                return;
            }
            if ((double)this.entity.func_70032_d(this.pickedUpByEntity) > 32.0) {
                this.setPickedUpByEntity(null);
                return;
            }
        }
        if (this.pickedUpByEntity != null) {
            double[] pickupOffset = this.getPickedUpOffset();
            this.entity.func_70107_b(this.pickedUpByEntity.field_70165_t + pickupOffset[0], this.pickedUpByEntity.field_70163_u + pickupOffset[1], this.pickedUpByEntity.field_70161_v + pickupOffset[2]);
            this.entity.field_70159_w = this.pickedUpByEntity.field_70159_w;
            this.entity.field_70181_x = this.pickedUpByEntity.field_70181_x;
            this.entity.field_70179_y = this.pickedUpByEntity.field_70179_y;
            this.entity.field_70143_R = 0.0f;
            if (!this.entity.func_130014_f_().field_72995_K && this.entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.entity;
                player.field_71075_bZ.field_75100_b = true;
                this.entity.field_70145_X = true;
            }
        }
    }

    public void setPickedUpByEntity(Entity pickedUpByEntity) {
        if (this.pickedUpByEntity == pickedUpByEntity || this.entity == null) {
            return;
        }
        if (this.entity.func_184187_bx() != null) {
            this.entity.func_184210_p();
        }
        this.pickedUpByEntity = pickedUpByEntity;
        if (!this.entity.func_130014_f_().field_72995_K) {
            if (this.entity instanceof EntityPlayer) {
                if (pickedUpByEntity != null) {
                    this.playerAllowFlyingSnapshot = ((EntityPlayer)this.entity).field_71075_bZ.field_75101_c;
                    this.playerIsFlyingSnapshot = ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b;
                } else {
                    ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b = this.playerIsFlyingSnapshot;
                    this.entity.field_70145_X = false;
                }
            }
            if (this.pickedUpByEntity != null && !(this.entity instanceof EntityPlayer)) {
                double[] pickupOffset = this.getPickedUpOffset();
                this.entity.func_184595_k(this.pickedUpByEntity.field_70165_t + pickupOffset[0], this.pickedUpByEntity.field_70163_u + pickupOffset[1], this.pickedUpByEntity.field_70161_v + pickupOffset[2]);
            }
            MessageEntityPickedUp message = new MessageEntityPickedUp((Entity)this.entity, pickedUpByEntity);
            LycanitesMobs.packetHandler.sendToDimension(message, this.entity.field_71093_bK);
        }
        if (pickedUpByEntity == null) {
            if (this.lastSafePos != null) {
                this.entity.func_70107_b(this.lastSafePos.getX(), this.lastSafePos.getY(), this.lastSafePos.getZ());
            }
            this.entity.field_70159_w = 0.0;
            this.entity.field_70181_x = 0.0;
            this.entity.field_70179_y = 0.0;
            this.entity.field_70143_R = 0.0f;
        }
    }

    public double[] getPickedUpOffset() {
        double[] pickupOffset = new double[]{0.0, 0.0, 0.0};
        if (this.pickedUpByEntity instanceof BaseCreatureEntity) {
            pickupOffset = ((BaseCreatureEntity)this.pickedUpByEntity).getPickupOffset((Entity)this.entity);
        }
        if (CreatureManager.getInstance().config.disablePickupOffsets && this.entity instanceof EntityPlayer) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return pickupOffset;
    }

    public boolean isPickedUp() {
        return this.pickedUpByEntity != null;
    }

    public boolean isFeared() {
        return this.pickedUpByEntity instanceof FearEntity;
    }

    public void setPerchedByEntity(Entity perchedByEntity) {
        if (this.perchedByEntity != null) {
            this.perchedByEntity.field_70145_X = this.perchedEntityNoclip;
            if (this.perchedByEntity instanceof BaseCreatureEntity) {
                ((BaseCreatureEntity)this.perchedByEntity).setPerchTarget(null);
            }
        }
        this.perchedByEntity = perchedByEntity;
        if (perchedByEntity != null) {
            this.perchedEntityNoclip = perchedByEntity.field_70145_X;
            perchedByEntity.field_70145_X = true;
            if (perchedByEntity instanceof BaseCreatureEntity) {
                ((BaseCreatureEntity)perchedByEntity).setPerchTarget(this.entity);
            }
        }
        if (!this.entity.func_130014_f_().field_72995_K) {
            MessageEntityPerched message = new MessageEntityPerched((Entity)this.entity, this.perchedByEntity);
            LycanitesMobs.packetHandler.sendToDimension(message, this.entity.field_71093_bK);
        }
    }

    public Entity getPerchedByEntity() {
        return this.perchedByEntity;
    }

    public Vec3d getPerchPosition() {
        double angle = Math.toRadians(this.entity.field_70177_z) + 90.0;
        double xPerchPos = this.entity.field_70165_t;
        double zPerchPos = this.entity.field_70161_v;
        double distance = (double)this.entity.field_70130_N * 0.7;
        if (distance != 0.0) {
            xPerchPos += distance * -Math.sin(angle);
            zPerchPos += distance * Math.cos(angle);
        }
        return new Vec3d(xPerchPos, this.entity.field_70163_u + (double)this.entity.field_70131_O * 0.78, zPerchPos);
    }

    public void updatedPerchedByEntity() {
        Entity perchedByEntity = this.getPerchedByEntity();
        if (perchedByEntity != null) {
            Vec3d perchPosition = this.getPerchPosition();
            perchedByEntity.func_70107_b(perchPosition.field_72450_a, perchPosition.field_72448_b, perchPosition.field_72449_c);
            perchedByEntity.field_70159_w = this.entity.field_70159_w;
            perchedByEntity.field_70181_x = this.entity.field_70181_x;
            perchedByEntity.field_70179_y = this.entity.field_70179_y;
            perchedByEntity.field_70177_z = this.entity.field_70177_z;
            perchedByEntity.field_70145_X = true;
        }
    }

    public int getProjectileCooldown(int type, String projectileName) {
        if (type == 1) {
            if (!this.projectileCooldownsPrimary.containsKey(projectileName)) {
                return 0;
            }
            return this.projectileCooldownsPrimary.get(projectileName);
        }
        if (!this.projectileCooldownsSecondary.containsKey(projectileName)) {
            return 0;
        }
        return this.projectileCooldownsSecondary.get(projectileName);
    }

    public void setProjectileCooldown(int type, String projectileName, int cooldown) {
        if (type == 1) {
            this.projectileCooldownsPrimary.put(projectileName, cooldown);
        }
        this.projectileCooldownsSecondary.put(projectileName, cooldown);
    }

    public void onEntityRemoved() {
        clientExtendedEntities.remove(this.entity);
    }

    public void readNBT(NBTTagCompound nbtTagCompound) {
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
    }

    static {
        FORCE_REMOVE_ENTITY_TICKS = 40;
    }
}

