/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.google.common.base.Optional;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.damagesources.MinionEntityDamageSource;
import com.lycanitesmobs.core.entity.goals.actions.BegGoal;
import com.lycanitesmobs.core.entity.goals.actions.FollowOwnerGoal;
import com.lycanitesmobs.core.entity.goals.actions.StayGoal;
import com.lycanitesmobs.core.entity.goals.targeting.CopyOwnerAttackTargetGoal;
import com.lycanitesmobs.core.entity.goals.targeting.DefendOwnerGoal;
import com.lycanitesmobs.core.entity.goals.targeting.RevengeOwnerGoal;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.item.ChargeItem;
import com.lycanitesmobs.core.item.consumable.CreatureTreatItem;
import com.lycanitesmobs.core.item.special.ItemSoulstone;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TameableCreatureEntity
extends AgeableCreatureEntity
implements IEntityOwnable {
    public float hunger = this.getCreatureHungerMax();
    public float stamina = this.getStaminaMax();
    public float staminaRecovery = 0.5f;
    public float sittingGuardRange = 16.0f;
    public UUID ownerUUID;
    public boolean fromSummoningPedestal = false;
    protected static final DataParameter<Byte> TAMED = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> HUNGER = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> STAMINA = EntityDataManager.func_187226_a(BaseCreatureEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> LOYALTY = EntityDataManager.func_187226_a(TameableCreatureEntity.class, (DataSerializer)DataSerializers.field_187192_b);

    public TameableCreatureEntity(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(HUNGER, (Object)Float.valueOf(this.getCreatureHungerMax()));
        this.field_70180_af.func_187214_a(STAMINA, (Object)Float.valueOf(this.getStaminaMax()));
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(this.nextReactTargetIndex++, (EntityAIBase)new RevengeOwnerGoal(this));
        this.field_70715_bh.func_75776_a(this.nextReactTargetIndex++, (EntityAIBase)new CopyOwnerAttackTargetGoal(this));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new StayGoal(this));
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (EntityAIBase)new DefendOwnerGoal(this));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (EntityAIBase)new FollowOwnerGoal(this).setStrayDistance(CreatureManager.getInstance().config.petFollowDistance).setLostDistance(32.0).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex++, (EntityAIBase)new BegGoal(this));
    }

    @Override
    public String func_70005_c_() {
        if (!this.isTamed() || !CreatureManager.getInstance().config.ownerTags) {
            return super.func_70005_c_();
        }
        String ownerName = this.getOwnerName();
        String ownerSuffix = "'s ";
        if (ownerName != null && ownerName.length() > 0 && ("s".equals(ownerName.substring(ownerName.length() - 1)) || "S".equals(ownerName.substring(ownerName.length() - 1)))) {
            ownerSuffix = "' ";
        }
        String ownedName = ownerName + ownerSuffix + this.getFullName();
        if (this.func_145818_k_()) {
            return super.func_70005_c_();
        }
        return ownedName;
    }

    public boolean func_145818_k_() {
        if (!CreatureManager.getInstance().config.ownerTags) {
            return false;
        }
        return super.func_145818_k_();
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.isTamed()) {
            return false;
        }
        return super.func_70692_ba();
    }

    @Override
    public boolean despawnCheck() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        if (this.getPetEntry() != null) {
            if (this.getPetEntry().entity != this && this.getPetEntry().entity != null) {
                return true;
            }
            if (this.getPetEntry().host == null || !this.getPetEntry().host.func_70089_S()) {
                this.getPetEntry().saveEntityNBT();
                return true;
            }
        }
        if (this.isTamed() && !this.isTemporary) {
            return false;
        }
        return super.despawnCheck();
    }

    @Override
    public boolean isPersistant() {
        return this.isTamed() || super.isPersistant();
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        if (this.isTamed() && player == this.getPlayerOwner()) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public void testLeash(float distance) {
        if (this.isSitting() && distance > 10.0f) {
            this.func_110160_i(true, true);
        } else {
            super.testLeash(distance);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.staminaUpdate();
        if (!this.func_130014_f_().field_72995_K && this.isPet() && this.func_70068_e((Entity)this.getPlayerOwner()) <= 64.0) {
            this.ownerEffects();
        }
    }

    public void staminaUpdate() {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.stamina < this.getStaminaMax() && this.staminaRecovery >= this.getStaminaRecoveryMax() / 2.0f) {
            this.setStamina(Math.min(this.stamina + this.staminaRecovery, this.getStaminaMax()));
        }
        if (this.staminaRecovery < this.getStaminaRecoveryMax()) {
            this.staminaRecovery = Math.min(this.staminaRecovery + this.getStaminaRecoveryMax() / (float)this.getStaminaRecoveryWarmup(), this.getStaminaRecoveryMax());
        }
    }

    public void ownerEffects() {
        if (!this.canBurn()) {
            this.getPlayerOwner().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 105, 1));
        }
        for (Object possibleEffect : this.getPlayerOwner().func_70651_bq().toArray(new Object[0])) {
            PotionEffect effectInstance;
            if (!(possibleEffect instanceof PotionEffect) || this.func_70687_e(effectInstance = (PotionEffect)possibleEffect)) continue;
            this.getPlayerOwner().func_184589_d(effectInstance.func_188419_a());
        }
    }

    public boolean isPet() {
        if (!this.isTamed() || this.getPlayerOwner() == null) {
            return false;
        }
        if (this.creatureInfo.isMountable()) {
            return false;
        }
        if (this.isTemporary) {
            return false;
        }
        return this.getPetEntry() == null || this.isPetType("pet");
    }

    public void copyPetBehaviourTo(TameableCreatureEntity target) {
        target.setPVP(this.isPVP());
        target.setPassive(this.isPassive());
        target.setAssist(this.isAssisting());
        target.setAggressive(this.isAggressive());
        target.setSitting(this.isSitting());
        target.setFollowing(this.isFollowing());
    }

    public boolean canPerch(EntityLivingBase target) {
        if (!this.creatureInfo.isPerchable()) {
            return false;
        }
        return this.getPlayerOwner() == target;
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (this.canPerch((EntityLivingBase)player) && !player.func_70093_af() && !this.func_130014_f_().field_72995_K) {
            commands.put(BaseCreatureEntity.COMMAND_PIORITIES.MAIN.id, "Perch");
        } else if (!this.func_130014_f_().field_72995_K && this.isTamed() && (itemStack == null || player.func_70093_af()) && player == this.getPlayerOwner()) {
            commands.put(BaseCreatureEntity.COMMAND_PIORITIES.MAIN.id, "GUI");
        }
        if (!this.func_130014_f_().field_72995_K && itemStack != null && !player.func_70093_af()) {
            String equipSlot;
            if (!this.isTamed() && this.isTamingItem(itemStack) && CreatureManager.getInstance().config.tamingEnabled) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.IMPORTANT.id, "Tame");
            }
            if (this.isTamed() && this.isHealingItem(itemStack) && this.func_110143_aJ() < this.func_110138_aP()) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Feed");
            }
            if (this.isTamed() && !this.isTemporary && !this.isPetType("minion") && itemStack.func_77973_b() instanceof ChargeItem) {
                if (this.isLevelingChargeItem(itemStack)) {
                    commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Charge");
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("item.lycanitesmobs.charge.creature.invalid")));
                }
            }
            if (this.isTamed() && !this.func_70631_g_() && this.canEquip() && player == this.getPlayerOwner() && (equipSlot = this.inventory.getSlotForEquipment(itemStack)) != null && (this.inventory.getEquipmentStack(equipSlot) == null || this.inventory.getEquipmentStack(equipSlot).func_77973_b() != itemStack.func_77973_b())) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.EQUIPPING.id, "Equip Item");
            }
            if (itemStack.func_77973_b() instanceof ItemSoulstone && this.isTamed()) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Soulstone");
            }
        }
        return commands;
    }

    @Override
    public boolean performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("GUI")) {
            this.playTameSound();
            this.openGUI(player);
            return true;
        }
        if (command.equals("Tame")) {
            this.tame(player);
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        if (command.equals("Feed")) {
            int healAmount = 4;
            if (itemStack.func_77973_b() instanceof ItemFood) {
                ItemFood itemFood = (ItemFood)itemStack.func_77973_b();
                healAmount = itemFood.func_150905_g(itemStack);
            }
            this.func_70691_i(healAmount);
            this.playEatSound();
            if (this.func_130014_f_().field_72995_K) {
                EnumParticleTypes particle = EnumParticleTypes.HEART;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                for (int i = 0; i < 25; ++i) {
                    this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        if (command.equals("Charge")) {
            this.addExperience(this.getExperienceFromChargeItem(itemStack));
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        if (command.equals("Equip Item")) {
            ItemStack equippedItem = this.inventory.getEquipmentStack(this.inventory.getSlotForEquipment(itemStack));
            if (equippedItem != null) {
                this.dropItem(equippedItem);
            }
            ItemStack equipStack = itemStack.func_77946_l();
            equipStack.func_190920_e(1);
            this.inventory.setEquipmentStack(equipStack.func_77946_l());
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        if (command.equals("Soulstone")) {
            return false;
        }
        if (command.equals("Sit")) {
            this.playTameSound();
            this.func_70624_b(null);
            this.clearMovement();
            this.setSitting(!this.isSitting());
            this.field_70703_bu = false;
            return true;
        }
        if (command.equals("Perch")) {
            this.playTameSound();
            this.perchOnEntity((EntityLivingBase)player);
            return true;
        }
        return super.performCommand(command, player, itemStack);
    }

    @Override
    public boolean canNameTag(EntityPlayer player) {
        if (!this.isTamed()) {
            return super.canNameTag(player);
        }
        if (this.isTamed() && player == this.getPlayerOwner()) {
            return super.canNameTag(player);
        }
        return false;
    }

    @Override
    public void performGUICommand(EntityPlayer player, byte guiCommandID) {
        if (!this.petControlsEnabled()) {
            return;
        }
        if (player != this.func_70902_q()) {
            return;
        }
        if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.PVP.id) {
            this.setPVP(!this.isPVP());
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id) {
            this.setPassive(true);
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id) {
            this.setPassive(false);
            this.setAssist(false);
            this.setAggressive(false);
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id) {
            this.setPassive(false);
            this.setAssist(true);
            this.setAggressive(false);
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id) {
            this.setPassive(false);
            this.setAssist(true);
            this.setAggressive(true);
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id) {
            this.setSitting(false);
            this.setFollowing(true);
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id) {
            this.setSitting(false);
            this.setFollowing(false);
        } else if (guiCommandID == BaseCreatureEntity.PET_COMMAND_ID.SIT.id) {
            this.setSitting(true);
            this.setFollowing(false);
        }
        this.playTameSound();
        if (this.petEntry != null && this.petEntry.summonSet != null) {
            this.petEntry.summonSet.updateBehaviour(this);
        }
        super.performGUICommand(player, guiCommandID);
    }

    public Team func_96124_cp() {
        Entity owner;
        if (this.isTamed() && (owner = this.func_70902_q()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity target) {
        if (target == null) {
            return false;
        }
        if (this.func_130014_f_().field_72995_K) {
            return super.func_184191_r(target);
        }
        if (this.isTamed()) {
            TameableCreatureEntity tamedTarget;
            if (target == this.getPlayerOwner() || target == this.func_70902_q()) {
                return true;
            }
            if (!(!(target instanceof EntityPlayer) || this.func_130014_f_().func_73046_m().func_71219_W() && this.isPVP())) {
                return true;
            }
            if (target instanceof TameableCreatureEntity ? (tamedTarget = (TameableCreatureEntity)target).isTamed() && (!this.func_130014_f_().func_73046_m().func_71219_W() || !this.isPVP() || tamedTarget.getPlayerOwner() == this.getPlayerOwner()) : target instanceof IEntityOwnable && (tamedTarget = (IEntityOwnable)target).func_70902_q() != null && (!this.func_130014_f_().func_73046_m().func_71219_W() || !this.isPVP() || tamedTarget.func_70902_q() == this.func_70902_q())) {
                return true;
            }
            if (this.getPlayerOwner() != null) {
                if (this.getPlayerOwner().func_184187_bx() == target) {
                    return true;
                }
                return this.getPlayerOwner().func_184191_r(target);
            }
            if (this.func_70902_q() != null) {
                if (this.func_70902_q().func_184187_bx() == target) {
                    return true;
                }
                return this.func_70902_q().func_184191_r(target);
            }
            return false;
        }
        return super.func_184191_r(target);
    }

    @Override
    public boolean doRangedDamage(Entity target, EntityThrowable projectile, float damage, boolean noPierce) {
        float totalDamage = damage * ((float)this.creatureStats.getDamage() / 2.0f);
        if (target instanceof EntityLiving) {
            EntityLiving livingTarget = (EntityLiving)target;
            if (this.getPlayerOwner() != null && livingTarget.func_110143_aJ() > 0.0f && livingTarget.func_110143_aJ() - totalDamage <= 0.0f) {
                DamageSource creditSource = this.getDamageSource(null, true);
                creditSource.func_76348_h().func_151518_m();
                return target.func_70097_a(creditSource, totalDamage);
            }
        }
        return super.doRangedDamage(target, projectile, damage, noPierce);
    }

    @Override
    public boolean attackEntityAsMob(Entity target, double damageScale) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (!this.func_70685_l(target)) {
            return false;
        }
        float damage = this.getAttackDamage(damageScale);
        if (target instanceof EntityLiving) {
            EntityLiving livingTarget = (EntityLiving)target;
            if (this.getPlayerOwner() != null && livingTarget.func_110143_aJ() > 0.0f && livingTarget.func_110143_aJ() - damage <= 0.0f) {
                DamageSource creditSource = this.getDamageSource(null, true);
                creditSource.func_76348_h().func_151518_m();
                return target.func_70097_a(creditSource, damage);
            }
        }
        return super.attackEntityAsMob(target, damageScale);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (this.isPassive()) {
            return false;
        }
        if (this.isTamed()) {
            return true;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (this.isPassive()) {
            return false;
        }
        if (this.isTamed()) {
            if (this.func_70902_q() == targetEntity || this.getPlayerOwner() == targetEntity) {
                return false;
            }
            if (!this.func_130014_f_().field_72995_K) {
                TameableCreatureEntity targetTameable;
                boolean canPVP;
                boolean bl = canPVP = this.func_130014_f_().func_73046_m().func_71219_W() && this.isPVP();
                if (targetEntity instanceof EntityPlayer && !canPVP) {
                    return false;
                }
                if (targetEntity instanceof TameableCreatureEntity && (targetTameable = (TameableCreatureEntity)targetEntity).isTamed()) {
                    if (!canPVP) {
                        return false;
                    }
                    if (targetTameable.getPlayerOwner() == this.getPlayerOwner()) {
                        return false;
                    }
                }
            }
            return true;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource, boolean playerCredit) {
        if (this.isTamed() && this.func_70902_q() != null) {
            if (nestedDamageSource == null) {
                nestedDamageSource = (EntityDamageSource)DamageSource.func_76358_a((EntityLivingBase)this);
            }
            return new MinionEntityDamageSource((DamageSource)nestedDamageSource, this.func_70902_q(), playerCredit);
        }
        return super.getDamageSource(nestedDamageSource, playerCredit);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        Entity entity;
        if (this.func_180431_b(damageSrc)) {
            return false;
        }
        if (!this.isPassive()) {
            this.setSitting(false);
        }
        if ((entity = damageSrc.func_76364_f()) instanceof EntityThrowable) {
            entity = ((EntityThrowable)entity).func_85052_h();
        }
        if (this.isTamed() && this.func_70902_q() == entity) {
            return false;
        }
        return super.func_70097_a(damageSrc, damageAmount);
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if ("inWall".equals(type) && this.isTamed()) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (this.isTamed()) {
            if (entity instanceof EntityPlayer && this.func_130014_f_().func_73046_m() != null && !this.func_130014_f_().func_73046_m().func_71219_W()) {
                return false;
            }
            if (entity == this.getPlayerOwner()) {
                return false;
            }
        }
        return super.isDamageEntityApplicable(entity);
    }

    public void setOwnerId(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)Optional.fromNullable((Object)ownerUUID));
        this.setTamed(ownerUUID != null);
    }

    public Entity func_70902_q() {
        UUID uuid = this.func_184753_b();
        if (uuid == null) {
            return super.getOwner();
        }
        return this.func_130014_f_().func_152378_a(uuid);
    }

    public void setPlayerOwner(EntityPlayer player) {
        this.setOwnerId(player.func_110124_au());
    }

    public UUID func_184753_b() {
        if (this.func_130014_f_().field_72995_K) {
            try {
                return (UUID)this.getUUIDFromDataManager(OWNER_ID).orNull();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.ownerUUID;
    }

    public EntityPlayer getPlayerOwner() {
        if (this.func_130014_f_().field_72995_K) {
            Entity owner = this.func_70902_q();
            if (owner instanceof EntityPlayer) {
                return (EntityPlayer)owner;
            }
            return null;
        }
        if (this.ownerUUID == null) {
            return null;
        }
        return this.func_130014_f_().func_152378_a(this.ownerUUID);
    }

    public String getOwnerName() {
        Entity owner = this.func_70902_q();
        if (owner != null) {
            if (owner instanceof EntityPlayer) {
                return ((EntityPlayer)owner).getDisplayNameString();
            }
            return owner.func_70005_c_();
        }
        return "";
    }

    @Override
    public boolean isTamed() {
        try {
            return (this.getByteFromDataManager(TAMED) & TAMED_ID.IS_TAMED.id) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setTamed(boolean isTamed) {
        byte tamed = this.getByteFromDataManager(TAMED);
        if (isTamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamed | TAMED_ID.IS_TAMED.id)));
            this.spawnEventType = "";
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamed - (tamed & TAMED_ID.IS_TAMED.id))));
        }
        this.func_174805_g(isTamed);
    }

    public boolean isTamingItem(ItemStack itemstack) {
        CreatureTreatItem itemTreat;
        if (itemstack.func_190926_b() || this.creatureInfo.creatureType == null || this.isBoss()) {
            return false;
        }
        if (itemstack.func_77973_b() instanceof CreatureTreatItem && (itemTreat = (CreatureTreatItem)itemstack.func_77973_b()).getCreatureType() == this.creatureInfo.creatureType) {
            return this.creatureInfo.isTameable();
        }
        return false;
    }

    public boolean tame(EntityPlayer player) {
        if (this.func_130014_f_().field_72995_K || this.isRareVariant() || this.isBoss()) {
            return super.isTamed();
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(player);
        if (extendedPlayer == null) {
            return this.isTamed();
        }
        extendedPlayer.studyCreature((Entity)this, CreatureManager.getInstance().config.creatureTreatKnowledge, false, true);
        if (this.isTamed()) {
            return true;
        }
        CreatureKnowledge creatureKnowledge = extendedPlayer.getBeastiary().getCreatureKnowledge(this.creatureInfo.getName());
        if (creatureKnowledge == null || creatureKnowledge.rank < 2) {
            return this.isTamed();
        }
        CreatureRelationshipEntry relationshipEntry = this.relationships.getOrCreateEntry((Entity)player);
        int reputationAmount = 50 + this.func_70681_au().nextInt(50);
        relationshipEntry.increaseReputation(reputationAmount);
        if (this.creatureInfo.isTameable() && relationshipEntry.getReputation() >= this.creatureInfo.getTamingReputation()) {
            this.setPlayerOwner(player);
            this.onTamedByPlayer();
            this.unsetTemporary();
            String tameMessage = LanguageManager.translate("message.pet.tamed");
            tameMessage = tameMessage.replace("%creature%", this.getSpeciesName());
            player.func_145747_a((ITextComponent)new TextComponentString(tameMessage));
            this.playTameEffect(this.isTamed());
            player.func_71064_a(ObjectManager.getStat(this.creatureInfo.getName() + ".tame"), 1);
            if (this.field_71088_bW > this.func_82147_ab()) {
                this.field_71088_bW = this.func_82147_ab();
            }
        }
        this.playTameEffect(this.isTamed());
        return this.isTamed();
    }

    public void onTamedByPlayer() {
        this.refreshAttributes();
        this.clearMovement();
        this.func_70624_b(null);
        this.setSitting(false);
        this.setFollowing(true);
        this.setPassive(false);
        this.setAggressive(false);
        this.setPVP(true);
        this.playTameSound();
        this.spawnEventType = "";
    }

    @Override
    public void onCreateBaby(AgeableCreatureEntity partner, AgeableCreatureEntity baby) {
        if (this.isTamed() && this.func_70902_q() instanceof EntityPlayer && partner instanceof TameableCreatureEntity && baby instanceof TameableCreatureEntity) {
            TameableCreatureEntity partnerTameable = (TameableCreatureEntity)partner;
            TameableCreatureEntity babyTameable = (TameableCreatureEntity)baby;
            if (partnerTameable.getPlayerOwner() == this.getPlayerOwner()) {
                babyTameable.setPlayerOwner((EntityPlayer)this.func_70902_q());
            }
        }
        super.onCreateBaby(partner, baby);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte status) {
        if (status == 7) {
            this.playTameEffect(true);
        } else if (status == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(status);
        }
    }

    public boolean isHealingItem(ItemStack itemStack) {
        return this.creatureInfo.canEat(itemStack);
    }

    public boolean isLevelingChargeItem(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ChargeItem) {
            ChargeItem chargeItem = (ChargeItem)itemStack.func_77973_b();
            for (ElementInfo elementInfo : this.getElements()) {
                if (!chargeItem.getElements().contains(elementInfo)) continue;
                return true;
            }
        }
        return false;
    }

    public int getExperienceFromChargeItem(ItemStack itemStack) {
        int experience = 0;
        if (itemStack.func_77973_b() instanceof ChargeItem) {
            ChargeItem chargeItem = (ChargeItem)itemStack.func_77973_b();
            for (ElementInfo elementInfo : this.getElements()) {
                if (!chargeItem.getElements().contains(elementInfo)) continue;
                experience += ChargeItem.CHARGE_EXPERIENCE;
            }
        }
        return experience;
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        if (!this.creatureInfo.isFarmable() && (!this.isTamed() || this.isPetType("minion") || this.isPetType("familiar") || this.func_110143_aJ() < this.func_110138_aP())) {
            return false;
        }
        return super.isBreedingItem(itemStack);
    }

    @Override
    public void summonMinion(EntityLivingBase minion, double angle, double distance) {
        if (this.getPlayerOwner() != null && minion instanceof TameableCreatureEntity) {
            ((TameableCreatureEntity)minion).setPlayerOwner(this.getPlayerOwner());
            this.copyPetBehaviourTo((TameableCreatureEntity)minion);
        }
        super.summonMinion(minion, angle, distance);
    }

    public boolean petControlsEnabled() {
        return true;
    }

    public byte behaviourBitMask() {
        return this.getByteFromDataManager(TAMED);
    }

    public boolean isSitting() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.MOVE_SIT.id) != 0;
    }

    public void setSitting(boolean set) {
        if (!this.isTamed()) {
            return;
        }
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.MOVE_SIT.id)));
            this.setHome((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.sittingGuardRange);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.MOVE_SIT.id))));
            this.detachHome();
        }
    }

    public boolean isFollowing() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.MOVE_FOLLOW.id) != 0;
    }

    public void setFollowing(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.MOVE_FOLLOW.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.MOVE_FOLLOW.id))));
        }
    }

    public boolean isPassive() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.STANCE_PASSIVE.id) != 0;
    }

    public void setPassive(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_PASSIVE.id)));
            this.func_70624_b(null);
            this.setStealth(0.0f);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_PASSIVE.id))));
        }
    }

    @Override
    public boolean isAggressive() {
        if (!this.isTamed()) {
            return super.isAggressive();
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.STANCE_AGGRESSIVE.id) != 0;
    }

    public void setAggressive(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_AGGRESSIVE.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_AGGRESSIVE.id))));
        }
    }

    public boolean isAssisting() {
        if (!this.isTamed()) {
            return false;
        }
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.STANCE_ASSIST.id) != 0;
    }

    public void setAssist(boolean set) {
        if (!this.petControlsEnabled()) {
            set = true;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_ASSIST.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_ASSIST.id))));
        }
    }

    public boolean isPVP() {
        return (this.getByteFromDataManager(TAMED) & TAMED_ID.PVP.id) != 0;
    }

    public void setPVP(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = this.getByteFromDataManager(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.PVP.id)));
        } else {
            this.func_70624_b(null);
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.PVP.id))));
        }
    }

    public float getCreatureHunger() {
        if (this.func_130014_f_() == null) {
            return this.getCreatureHungerMax();
        }
        if (!this.func_130014_f_().field_72995_K) {
            return this.hunger;
        }
        try {
            return this.getFloatFromDataManager(HUNGER);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setCreatureHunger(float setHunger) {
        this.hunger = setHunger;
    }

    public float getCreatureHungerMax() {
        return 20.0f;
    }

    public float getStamina() {
        if (this.func_130014_f_() != null && this.func_130014_f_().field_72995_K) {
            try {
                this.stamina = this.getFloatFromDataManager(STAMINA);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stamina;
    }

    public void setStamina(float setStamina) {
        this.stamina = setStamina;
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(STAMINA, (Object)Float.valueOf(setStamina));
        }
    }

    public float getStaminaMax() {
        return 100.0f;
    }

    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    public int getStaminaRecoveryWarmup() {
        return 200;
    }

    public float getStaminaCost() {
        return 1.0f;
    }

    public void applyStaminaCost() {
        float newStamina = this.getStamina() - this.getStaminaCost();
        if (newStamina < 0.0f) {
            newStamina = 0.0f;
        }
        this.setStamina(newStamina);
        this.staminaRecovery = 0.0f;
    }

    public float getStaminaPercent() {
        return this.getStamina() / this.getStaminaMax();
    }

    public String getStaminaType() {
        return "energy";
    }

    @Override
    public AgeableCreatureEntity createChild(AgeableCreatureEntity baby) {
        AgeableCreatureEntity spawnedBaby = super.createChild(baby);
        UUID ownerId = this.func_184753_b();
        if (ownerId != null && spawnedBaby != null && spawnedBaby instanceof TameableCreatureEntity) {
            TameableCreatureEntity tamedBaby = (TameableCreatureEntity)spawnedBaby;
            tamedBaby.setOwnerId(ownerId);
        }
        return spawnedBaby;
    }

    @Override
    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.isTamed()) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    @Override
    public boolean canBeTempted() {
        return super.canBeTempted();
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    @Override
    public boolean func_82171_bF() {
        return this.isTamed();
    }

    protected void playTameEffect(boolean success) {
        EnumParticleTypes particle = EnumParticleTypes.HEART;
        if (!success) {
            particle = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Override
    public boolean canBeColored(EntityPlayer player) {
        if (player == null) {
            return true;
        }
        return this.isTamed() && player == this.getPlayerOwner();
    }

    @Override
    public boolean showBossInfo() {
        if (this.isTamed()) {
            return false;
        }
        return super.showBossInfo();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_186855_b("OwnerId")) {
            this.setOwnerId(nbtTagCompound.func_186857_a("OwnerId"));
        } else {
            this.setOwnerId(null);
        }
        if (nbtTagCompound.func_74764_b("FromSummoningPedestal")) {
            this.fromSummoningPedestal = nbtTagCompound.func_74767_n("FromSummoningPedestal");
        }
        if (nbtTagCompound.func_74764_b("Sitting")) {
            this.setSitting(nbtTagCompound.func_74767_n("Sitting"));
        } else {
            this.setSitting(false);
        }
        if (nbtTagCompound.func_74764_b("Following")) {
            this.setFollowing(nbtTagCompound.func_74767_n("Following"));
        } else {
            this.setFollowing(true);
        }
        if (nbtTagCompound.func_74764_b("Passive")) {
            this.setPassive(nbtTagCompound.func_74767_n("Passive"));
        } else {
            this.setPassive(false);
        }
        if (nbtTagCompound.func_74764_b("Aggressive")) {
            this.setAggressive(nbtTagCompound.func_74767_n("Aggressive"));
        } else {
            this.setAggressive(false);
        }
        if (nbtTagCompound.func_74764_b("PVP")) {
            this.setPVP(nbtTagCompound.func_74767_n("PVP"));
        } else {
            this.setPVP(true);
        }
        if (nbtTagCompound.func_74764_b("Hunger")) {
            this.setCreatureHunger(nbtTagCompound.func_74760_g("Hunger"));
        } else {
            this.setCreatureHunger(this.getCreatureHungerMax());
        }
        if (nbtTagCompound.func_74764_b("Stamina")) {
            this.setStamina(nbtTagCompound.func_74760_g("Stamina"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        if (this.func_184753_b() != null) {
            nbtTagCompound.func_186854_a("OwnerId", this.func_184753_b());
        }
        nbtTagCompound.func_74757_a("FromSummoningPedestal", this.fromSummoningPedestal);
        nbtTagCompound.func_74757_a("Sitting", this.isSitting());
        nbtTagCompound.func_74757_a("Following", this.isFollowing());
        nbtTagCompound.func_74757_a("Passive", this.isPassive());
        nbtTagCompound.func_74757_a("Aggressive", this.isAggressive());
        nbtTagCompound.func_74757_a("PVP", this.isPVP());
        nbtTagCompound.func_74776_a("Hunger", this.getCreatureHunger());
        nbtTagCompound.func_74776_a("Stamina", this.getStamina());
    }

    @Override
    public int func_70627_aG() {
        if (this.isTamed()) {
            return 600;
        }
        return super.func_70627_aG();
    }

    @Override
    protected SoundEvent func_184639_G() {
        String sound = "_say";
        if (this.isTamed() && this.func_110143_aJ() < this.func_110138_aP()) {
            sound = "_beg";
        }
        return AssetManager.getSound(this.getSoundName() + sound);
    }

    public void playTameSound() {
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_tame"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playEatSound() {
        this.func_184185_a(AssetManager.getSound(this.getSoundName() + "_eat"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public static enum TAMED_ID {
        IS_TAMED(1),
        MOVE_SIT(2),
        MOVE_FOLLOW(4),
        STANCE_PASSIVE(8),
        STANCE_AGGRESSIVE(16),
        STANCE_ASSIST(32),
        PVP(64);

        public final byte id;

        private TAMED_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

