/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityBanshee;
import com.lycanitesmobs.core.entity.creature.EntityEpion;
import com.lycanitesmobs.core.entity.creature.EntityGeist;
import com.lycanitesmobs.core.entity.creature.EntityReaper;
import com.lycanitesmobs.core.entity.goals.GoalConditions;
import com.lycanitesmobs.core.entity.goals.actions.FindNearbyPlayersGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.EffectAuraGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.FaceTargetGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.FireProjectilesGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.ForceGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.GrowGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.HealWhenNoPlayersGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.SuicideGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.SummonMinionsGoal;
import com.lycanitesmobs.core.entity.goals.targeting.CopyMasterAttackTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAmalgalich
extends BaseCreatureEntity
implements IMob,
IGroupHeavy,
IGroupBoss {
    private ForceGoal consumptionGoalP0;
    private ForceGoal consumptionGoalP2;
    private int consumptionDuration = 300;
    private int consumptionWindUp = 60;
    private int consumptionAnimationTime = 0;

    public EntityAmalgalich(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.hasAttackSound = true;
        this.setAttackCooldownMax(30);
        this.hasJumpSound = false;
        this.field_70144_Y = 1.0f;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.damageMax = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
        this.damageLimit = BaseCreatureEntity.BOSS_DAMAGE_LIMIT;
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex, (EntityAIBase)new FindNearbyPlayersGoal(this));
        this.consumptionDuration = 300;
        this.consumptionWindUp = 60;
        this.consumptionAnimationTime = 0;
        int consumptionGoalCooldown = 400;
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new FaceTargetGoal(this));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new HealWhenNoPlayersGoal(this));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new SummonMinionsGoal(this).setMinionInfo("banshee").setAntiFlight(true));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new FireProjectilesGoal(this).setProjectile("spectralbolt").setFireRate(40).setVelocity(1.0f).setScale(8.0f).setAllPlayers(true).setOverhead(true).setOffset(new Vec3d(0.0, 6.0, 0.0)));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new FireProjectilesGoal(this).setProjectile("spectralbolt").setFireRate(60).setVelocity(1.0f).setScale(8.0f).setOverhead(true).setOffset(new Vec3d(0.0, 8.0, 0.0)));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new EffectAuraGoal(this).setEffect("decay").setAmplifier(0).setEffectSeconds(5).setRange(52.0f).setCheckSight(false));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new SummonMinionsGoal(this).setMinionInfo("reaper").setSummonRate(100).setSummonCap(5).setPerPlayer(true).setConditions(new GoalConditions().setBattlePhase(0)));
        this.consumptionGoalP0 = new ForceGoal(this).setRange(64.0f).setCooldown(consumptionGoalCooldown).setDuration(this.consumptionDuration).setWindUp(this.consumptionWindUp).setForce(-0.75f).setPhase(0).setDismount(true);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new EffectAuraGoal(this).setRange(1.0f).setCooldown(consumptionGoalCooldown + this.consumptionWindUp).setDuration(this.consumptionDuration - this.consumptionWindUp).setTickRate(5).setDamageAmount(1000.0f).setCheckSight(false).setTargetTypes((byte)(BaseCreatureEntity.TARGET_TYPES.ALLY.id | BaseCreatureEntity.TARGET_TYPES.ENEMY.id)).setConditions(new GoalConditions().setBattlePhase(0)));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)this.consumptionGoalP0);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new SummonMinionsGoal(this).setMinionInfo("geist").setSummonRate(100).setSummonCap(5).setPerPlayer(true).setConditions(new GoalConditions().setBattlePhase(1)));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new SummonMinionsGoal(this).setMinionInfo("epion").setSummonRate(100).setSummonCap(3).setPerPlayer(true).setConditions(new GoalConditions().setBattlePhase(1)));
        this.consumptionGoalP2 = new ForceGoal(this).setRange(64.0f).setCooldown(consumptionGoalCooldown).setDuration(this.consumptionDuration).setWindUp(this.consumptionWindUp).setForce(-0.75f).setPhase(2).setDismount(true);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)this.consumptionGoalP2);
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new EffectAuraGoal(this).setRange(1.0f).setCooldown(consumptionGoalCooldown + this.consumptionWindUp).setDuration(this.consumptionDuration - this.consumptionWindUp).setTickRate(5).setDamageAmount(1000.0f).setCheckSight(false).setTargetTypes((byte)(BaseCreatureEntity.TARGET_TYPES.ALLY.id | BaseCreatureEntity.TARGET_TYPES.ENEMY.id)).setConditions(new GoalConditions().setBattlePhase(2)));
        this.field_70714_bg.func_75776_a(this.nextIdleGoalIndex, (EntityAIBase)new FireProjectilesGoal(this).setProjectile("lobdarklings").setFireRate(200).setVelocity(0.8f).setScale(2.0f).setRandomCount(3).setAngle(360).setPhase(2));
        super.func_184651_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(200.0, 50.0, 200.0).func_72317_d(0.0, -25.0, 0.0);
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        if (this.getArenaCenter() == null) {
            this.setArenaCenter(this.func_180425_c());
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            double arenaY = this.field_70163_u;
            if (this.func_130014_f_().func_175623_d(arenaPos)) {
                arenaY = arenaPos.func_177956_o();
            } else if (this.func_130014_f_().func_175623_d(arenaPos.func_177982_a(0, 1, 0))) {
                arenaY = arenaPos.func_177982_a(0, 1, 0).func_177956_o();
            }
            if (this.field_70165_t != (double)arenaPos.func_177958_n() || this.field_70163_u != arenaY || this.field_70161_v != (double)arenaPos.func_177952_p()) {
                this.func_70107_b(arenaPos.func_177958_n(), arenaY, arenaPos.func_177952_p());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.consumptionAnimationTime = !this.extraAnimation01() ? this.consumptionDuration : --this.consumptionAnimationTime;
        }
    }

    @Override
    public void updateBattlePhase() {
        double healthNormal = this.func_110143_aJ() / this.func_110138_aP();
        if (healthNormal <= 0.2) {
            this.setBattlePhase(2);
            return;
        }
        if (healthNormal <= 0.6) {
            this.setBattlePhase(1);
            return;
        }
        this.setBattlePhase(0);
    }

    @Override
    public boolean rollWanderChance() {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase target) {
        if (target instanceof EntityBanshee || target instanceof EntityReaper || target instanceof EntityGeist) {
            return false;
        }
        return super.canAttackEntity(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("spectralbolt", target, range, 0.0f, new Vec3d(0.0, 8.0, 0.0), 1.2f, 6.0f, 0.0f);
        super.attackRanged(target, range);
    }

    public float getConsumptionAnimation() {
        if (this.consumptionAnimationTime >= this.consumptionDuration) {
            return 0.0f;
        }
        int windUpThreshhold = this.consumptionDuration - this.consumptionWindUp;
        if (this.consumptionAnimationTime > windUpThreshhold) {
            return 1.0f - (float)(this.consumptionAnimationTime - windUpThreshhold) / (float)this.consumptionWindUp;
        }
        float finishingTime = (float)this.consumptionWindUp / 2.0f;
        if ((float)this.consumptionAnimationTime < finishingTime) {
            return (float)this.consumptionAnimationTime / finishingTime;
        }
        return 1.0f;
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        if (this.getBattlePhase() == 0) {
            return this.consumptionGoalP0.cooldownTime <= 0;
        }
        if (this.getBattlePhase() == 2) {
            return this.consumptionGoalP2.cooldownTime <= 0;
        }
        return super.extraAnimation01();
    }

    @Override
    public boolean addMinion(EntityLivingBase minion) {
        boolean minionAdded = super.addMinion(minion);
        if (minionAdded && minion instanceof BaseCreatureEntity) {
            BaseCreatureEntity minionCreature = (BaseCreatureEntity)minion;
            minionCreature.field_70715_bh.func_75776_a(minionCreature.nextFindTargetIndex++, (EntityAIBase)new CopyMasterAttackTargetGoal(minionCreature));
            if (minion instanceof EntityGeist) {
                minionCreature.field_70714_bg.func_75776_a(minionCreature.nextIdleGoalIndex++, (EntityAIBase)new GrowGoal(minionCreature).setGrowthAmount(0.1f).setTickRate(20));
                minionCreature.field_70714_bg.func_75776_a(minionCreature.nextIdleGoalIndex++, (EntityAIBase)new SuicideGoal(minionCreature).setCountdown(400));
            }
        }
        return minionAdded;
    }

    @Override
    public void onMinionDeath(EntityLivingBase minion, DamageSource damageSource) {
        super.onMinionDeath(minion, damageSource);
        if (minion instanceof EntityEpion) {
            int extinguishWidth = 10;
            int extinguishHeight = 30;
            if (!this.func_130014_f_().field_72995_K) {
                for (int x = (int)minion.field_70165_t - extinguishWidth; x <= (int)minion.field_70165_t + extinguishWidth; ++x) {
                    for (int y = (int)minion.field_70163_u - extinguishHeight; y <= (int)minion.field_70163_u + 2; ++y) {
                        for (int z = (int)minion.field_70161_v - extinguishWidth; z <= (int)minion.field_70161_v + extinguishWidth; ++z) {
                            Block block = this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                            if (block != ObjectManager.getBlock("shadowfire")) continue;
                            BlockPos placePos = new BlockPos(x, y, z);
                            this.func_130014_f_().func_175698_g(placePos);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onTryToDamageMinion(EntityLivingBase minion, float damageAmount) {
        super.onTryToDamageMinion(minion, damageAmount);
        if (damageAmount >= 1000.0f) {
            minion.func_70106_y();
            this.func_70691_i(25.0f);
        }
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (this.isBlocking()) {
            return true;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        return super.isBlocking();
    }

    @Override
    public boolean canAttackWhileBlocking() {
        return true;
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityPigZombie) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof EntityIronGolem) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71075_bZ.field_75102_a && player.field_70163_u > this.field_70163_u + CreatureManager.getInstance().config.bossAntiFlight) {
                return false;
            }
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damageAmount) {
        if (this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof EntityPlayer && !this.playerTargets.contains(damageSrc.func_76346_g())) {
            this.playerTargets.add((EntityPlayer)damageSrc.func_76346_g());
        }
        return super.func_70097_a(damageSrc, damageAmount);
    }

    public void func_70020_e(NBTTagCompound nbtTagCompound) {
        super.func_70020_e(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

