/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityBelph;
import com.lycanitesmobs.core.entity.creature.EntityRahovart;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireOrb;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBehemoth
extends TameableCreatureEntity
implements IMob {
    protected static final DataParameter<Integer> HELLFIRE_ENERGY = EntityDataManager.func_187226_a(EntityBehemoth.class, (DataSerializer)DataSerializers.field_187192_b);
    public int hellfireEnergy = 0;
    public List<EntityHellfireOrb> hellfireOrbs = new ArrayList<EntityHellfireOrb>();

    public EntityBehemoth(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.hasAttackSound = false;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(false).setRange(1.0).setMaxChaseDistance(8.0f));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(1.0).setRange(16.0f).setMinChaseDistance(0.0f).setChaseTime(-1));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
        } else {
            try {
                this.hellfireEnergy = (Integer)this.field_70180_af.func_187225_a(HELLFIRE_ENERGY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.func_130014_f_().field_72995_K && this.hellfireEnergy > 0) {
            EntityRahovart.updateHellfireOrbs((EntityLivingBase)this, this.updateTick, 3, this.hellfireEnergy, 1.0f, this.hellfireOrbs);
        }
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0) {
            int trailHeight = 1;
            int trailWidth = 1;
            if (this.isRareVariant()) {
                trailWidth = 3;
            }
            for (int y = 0; y < trailHeight; ++y) {
                Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block == null || block != Blocks.field_150350_a && block != Blocks.field_150480_ab && block != Blocks.field_150433_aE && block != Blocks.field_150329_H && block != ObjectManager.getBlock("frostfire") && block != ObjectManager.getBlock("icefire") && block != ObjectManager.getBlock("scorchfire") && block != ObjectManager.getBlock("doomfire")) continue;
                if (trailWidth == 1) {
                    this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), ObjectManager.getBlock("hellfire").func_176223_P());
                    continue;
                }
                for (int x = -(trailWidth / 2); x < trailWidth / 2 + 1; ++x) {
                    for (int z = -(trailWidth / 2); z < trailWidth / 2 + 1; ++z) {
                        this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(x, y, z), ObjectManager.getBlock("hellfire").func_176223_P());
                    }
                }
            }
        }
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase target) {
        if (target instanceof EntityBelph) {
            return false;
        }
        return super.canAttackEntity(target);
    }

    @Override
    public boolean canAttackWithPickup() {
        return true;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)target;
            if (this.canPickupEntity(entityLivingBase)) {
                this.pickupEntity(entityLivingBase);
            } else if (this.getPickupEntity() == target && this.func_70681_au().nextBoolean()) {
                this.dropPickupEntity();
                Vec3d throwVelocity = this.getFacingPositionDouble(0.0, 1.0, 0.0, 2.0, this.field_70177_z);
                target.field_70159_w = throwVelocity.field_72450_a;
                target.field_70181_x = throwVelocity.field_72448_b;
                target.field_70179_y = throwVelocity.field_72449_c;
            }
        }
        return true;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("hellfireball", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        Vec3d offset = this.getFacingPositionDouble(0.0, 2.0, 0.0, 1.5, this.field_70177_z);
        return new double[]{offset.field_72450_a, offset.field_72448_b, offset.field_72449_c};
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!this.func_145818_k_() || !"Krampus".equals(this.func_95999_t())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_krampus";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

