/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityVespid;
import com.lycanitesmobs.core.entity.creature.EntityVespidQueen;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.FireProjectilesGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAvoidTargetGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityConba
extends TameableCreatureEntity
implements IMob {
    AttackMeleeGoal aiAttackMelee;
    public boolean vespidInfection = false;
    public int vespidInfectionTime = 0;

    public EntityConba(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        this.aiAttackMelee = new AttackMeleeGoal(this).setLongMemory(true).setEnabled(false);
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)this.aiAttackMelee);
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new FireProjectilesGoal(this).setProjectile("poop").setFireRate(20).setVelocity(1.2f));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (EntityAIBase)new FindAvoidTargetGoal(this).setTargetClass(EntityPlayer.class).setTameTargetting(false));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (EntityAIBase)new FindAvoidTargetGoal(this).setTargetClass(EntityVillager.class));
    }

    @Override
    public String getSpeciesName() {
        String entityName;
        String infection = "";
        if (this.vespidInfection && (entityName = this.creatureInfo.getName()) != null) {
            infection = LanguageManager.translate("entity." + this.creatureInfo.modInfo.modid + "." + entityName + ".infected") + " ";
        }
        return super.getSpeciesName();
    }

    @Override
    public String getTextureName() {
        if (this.vespidInfection) {
            return super.getTextureName() + "_infected";
        }
        return super.getTextureName();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            if (this.hasAvoidTarget()) {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.leap(1.0f, 0.6, (Entity)this.func_70638_az());
                }
            } else if (this.field_70146_Z.nextInt(50) == 0 && this.isMoving()) {
                this.leap(1.0, 0.6);
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.vespidInfection && "theswarm".equals(this.spawnEventType)) {
                this.vespidInfection = true;
            }
            if (this.vespidInfection && !this.func_130014_f_().field_72995_K) {
                this.aiAttackMelee.setEnabled(true);
                if (this.vespidInfectionTime++ >= 1200) {
                    this.spawnVespidSwarm();
                    this.func_70106_y();
                }
            } else {
                this.aiAttackMelee.setEnabled(false);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.vespidInfection = this.extraAnimation01();
            if (this.vespidInfection) {
                for (int i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public boolean shouldCreatureGroupFlee(EntityLivingBase target) {
        if (this.isTamed()) {
            return false;
        }
        return super.shouldCreatureGroupFlee(target);
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase target) {
        if (target instanceof EntityVespid || target instanceof EntityVespidQueen) {
            return false;
        }
        return super.canAttackEntity(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("poop", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 1.2f, 2.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && this.vespidInfection) {
            this.spawnVespidSwarm();
        }
        super.func_70645_a(damageSource);
    }

    public void spawnVespidSwarm() {
        int j = 2 + this.field_70146_Z.nextInt(5) + this.func_130014_f_().func_175659_aa().func_151525_a() - 1;
        for (int k = 0; k < j; ++k) {
            float f = ((float)(k % 2) - 0.5f) * this.field_70130_N / 4.0f;
            float f1 = ((float)(k / 2) - 0.5f) * this.field_70130_N / 4.0f;
            EntityVespid vespid = (EntityVespid)CreatureManager.getInstance().getCreature("vespid").createEntity(this.func_130014_f_());
            vespid.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            vespid.applyVariant(this.getVariantIndex());
            vespid.setGrowingAge(vespid.growthTime);
            vespid.spawnEventType = this.spawnEventType;
            this.func_130014_f_().func_72838_d((Entity)vespid);
            if (this.func_70638_az() == null) continue;
            vespid.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean extraAnimation01() {
        if (!this.func_130014_f_().field_72995_K) {
            return this.vespidInfection;
        }
        return this.extraAnimation01;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    public void func_70020_e(NBTTagCompound nbtTagCompound) {
        super.func_70020_e(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("VespidInfection")) {
            this.vespidInfection = nbtTagCompound.func_74767_n("VespidInfection");
        }
        if (nbtTagCompound.func_74764_b("VespidInfectionTime")) {
            this.vespidInfectionTime = nbtTagCompound.func_74762_e("VespidInfectionTime");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("VespidInfection", this.vespidInfection);
        if (this.vespidInfection) {
            nbtTagCompound.func_74768_a("VespidInfectionTime", this.vespidInfectionTime);
        }
    }
}

