/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityBalayang;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAvoidTargetGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityGorgomite
extends BaseCreatureEntity
implements IMob {
    private int swarmLimit = 5;

    public EntityGorgomite(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.hasAttackSound = true;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
        this.field_70715_bh.func_75776_a(this.nextSpecialTargetIndex++, (EntityAIBase)new FindAvoidTargetGoal(this).setTargetClass(EntityBalayang.class));
    }

    @Override
    public void loadCreatureFlags() {
        this.swarmLimit = this.creatureInfo.getFlag("swarmLimit", this.swarmLimit);
    }

    @Override
    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.func_70638_az() instanceof EntityPlayer && this.updateTick % 60L == 0L) {
            this.allyUpdate();
        }
        super.func_70636_d();
    }

    public void allyUpdate() {
        float random;
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.swarmLimit > 0 && this.countAllies(64.0) < this.swarmLimit && (random = this.field_70146_Z.nextFloat()) <= 0.25f) {
            this.spawnAlly(this.field_70165_t - 2.0 + (double)(random * 4.0f), this.field_70163_u, this.field_70161_v - 2.0 + (double)(random * 4.0f));
        }
    }

    public void spawnAlly(double x, double y, double z) {
        BaseCreatureEntity minion = (BaseCreatureEntity)this.creatureInfo.createEntity(this.func_130014_f_());
        minion.func_70012_b(x, y, z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        minion.setMinion(true);
        minion.applyVariant(this.getVariantIndex());
        this.func_130014_f_().func_72838_d((Entity)minion);
        if (this.func_70638_az() != null) {
            minion.func_70604_c(this.func_70638_az());
        }
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        this.allyUpdate();
        super.func_70645_a(par1DamageSource);
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }
}

