/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.google.common.base.Predicate;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityMaug
extends RideableCreatureEntity {
    protected boolean leapedAbilityQueued = false;
    protected boolean leapedAbilityReady = false;

    public EntityMaug(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(4.0f, 0.5, (Entity)this.func_70638_az());
        }
        if (this.leapedAbilityQueued && !this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = false;
            this.leapedAbilityReady = true;
        }
        if (this.leapedAbilityReady && this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityReady = false;
            double distance = 4.0;
            List possibleTargets = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase possibleTarget) {
                    return possibleTarget.func_70089_S() && possibleTarget != EntityMaug.this && !EntityMaug.this.func_184215_y((Entity)possibleTarget) && !EntityMaug.this.func_184191_r((Entity)possibleTarget) && EntityMaug.this.func_70686_a(possibleTarget.getClass()) && EntityMaug.this.canAttackEntity(possibleTarget);
                }
            });
            if (!possibleTargets.isEmpty()) {
                for (EntityLivingBase possibleTarget : possibleTargets) {
                    boolean doDamage = true;
                    if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget))) {
                        doDamage = false;
                    }
                    if (!doDamage) continue;
                    possibleTarget.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                }
            }
            this.playAttackSound();
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76421_d)) {
            rider.func_184589_d(MobEffects.field_76421_d);
        }
        if (rider.func_70644_a(MobEffects.field_76438_s)) {
            rider.func_184589_d(MobEffects.field_76438_s);
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (!this.field_70122_E) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.95;
    }

    @Override
    public void leap(double distance, double leapHeight) {
        super.leap(distance, leapHeight);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void leap(float range, double leapHeight, Entity target) {
        super.leap(range, leapHeight, target);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (!this.field_70122_E) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.playJumpSound();
        this.leap(2.0, 1.5);
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 15.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }
}

