/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.TemptGoal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EntityPixen
extends TameableCreatureEntity
implements IMob {
    protected boolean wantsToLand;
    protected boolean isLanded;
    public int auraRate = 60;
    public List<String> auraEffects = new ArrayList<String>();
    public int auraDuration = 100;
    public int auraAmplifier = 0;

    public EntityPixen(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.flySoundSpeed = 5;
        this.field_70138_W = 1.0f;
        this.setupMob();
        this.auraEffects.add("minecraft:speed");
        this.auraEffects.add("minecraft:haste");
        this.auraEffects.add("minecraft:jump_boost");
        this.auraEffects.add("lycanitesmobs:fallresist");
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (EntityAIBase)new TemptGoal(this).setAlwaysTempted(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(1.0).setRange(14.0f).setMinChaseDistance(5.0f).setCheckSight(false));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.isLanded) {
                this.wantsToLand = false;
                if (!this.isSitting() && this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                    this.leap(1.0, 1.0);
                    this.isLanded = false;
                }
            } else if (this.wantsToLand) {
                if (this.isSafeToLand()) {
                    this.isLanded = true;
                }
            } else if (this.updateTick % 100L == 0L && this.func_70681_au().nextBoolean()) {
                this.wantsToLand = true;
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.auraRate > 0 && !this.isPetType("familiar") && this.updateTick % (long)this.auraRate == 0L) {
            List<EntityLivingBase> aoeTargets = this.getNearbyEntities(EntityLivingBase.class, null, 4.0);
            for (EntityLivingBase entityObj : aoeTargets) {
                EntityLivingBase target = entityObj;
                if (target == this || target instanceof EntityPixen || target == this.func_70638_az() || target == this.getAvoidTarget()) continue;
                int randomIndex = this.func_70681_au().nextInt(this.auraEffects.size());
                Potion effect = (Potion)GameRegistry.findRegistry(Potion.class).getValue(new ResourceLocation(this.auraEffects.get(randomIndex)));
                if (effect == null) continue;
                target.func_70690_d(new PotionEffect(effect, this.auraDuration, this.auraAmplifier));
            }
        }
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.wantsToLand || !this.isLanded) {
            BlockPos groundPos = wanderPosition.func_177977_b();
            while (groundPos.func_177956_o() > 0 && this.func_130014_f_().func_180495_p(groundPos).func_177230_c() == Blocks.field_150350_a) {
                groundPos = groundPos.func_177977_b();
            }
            if (this.func_130014_f_().func_180495_p(groundPos).func_185904_a().func_76220_a()) {
                return groundPos.func_177984_a();
            }
        }
        return super.getWanderPosition(wanderPosition);
    }

    @Override
    public double getFlightOffset() {
        if (!this.wantsToLand) {
            super.getFlightOffset();
        }
        return 0.0;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("tricksterflare", target, range, 0.0f, new Vec3d(0.0, 0.0, 0.0), 0.75f, 1.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public boolean isFlying() {
        return !this.isLanded;
    }

    @Override
    public boolean isStrongSwimmer() {
        return false;
    }

    @Override
    public boolean func_70648_aU() {
        return false;
    }

    @Override
    public boolean canBeTempted() {
        return !this.isInPack() && this.func_70643_av() == null;
    }

    @Override
    public boolean isAggressive() {
        if (!this.isInPack() && this.func_70643_av() == null) {
            return false;
        }
        return super.isAggressive();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }
}

