/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.RapidFireProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySerpix
extends TameableCreatureEntity
implements IGroupHeavy {
    public EntitySerpix(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.babySpawnChance = 0.25;
        this.growthTime = -120000;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new StealthGoal(this).setStealthTime(60));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.5).setStaminaTime(100).setRange(12.0f).setMinChaseDistance(8.0f));
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("blizzard");
        if (projectileInfo == null) {
            return;
        }
        ArrayList<RapidFireProjectileEntity> projectiles = new ArrayList<RapidFireProjectileEntity>();
        RapidFireProjectileEntity projectileEntry = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectiles.add(projectileEntry);
        RapidFireProjectileEntity projectileEntry2 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry2.offsetX += 1.0;
        projectiles.add(projectileEntry2);
        RapidFireProjectileEntity projectileEntry3 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry3.offsetX -= 1.0;
        projectiles.add(projectileEntry3);
        RapidFireProjectileEntity projectileEntry4 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry4.offsetZ += 1.0;
        projectiles.add(projectileEntry4);
        RapidFireProjectileEntity projectileEntry5 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry5.offsetZ -= 1.0;
        projectiles.add(projectileEntry5);
        RapidFireProjectileEntity projectileEntry6 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry6.offsetY += 1.0;
        projectiles.add(projectileEntry6);
        RapidFireProjectileEntity projectileEntry7 = new RapidFireProjectileEntity(projectileInfo, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry7.offsetY -= 10.0;
        projectiles.add(projectileEntry7);
        BlockPos launchPos = this.getFacingPosition(4.0);
        for (RapidFireProjectileEntity projectile : projectiles) {
            projectile.setProjectileScale(1.0f);
            projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
            float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.field_70165_t - (double)launchPos.func_177958_n() + (double)accuracy;
            double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
            double d2 = target.field_70161_v - (double)launchPos.func_177952_p() + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 1.2f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            projectile.func_70107_b(launchPos.func_177958_n(), launchPos.func_177956_o(), launchPos.func_177952_p());
            this.func_130014_f_().func_72838_d((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean canStealth() {
        if (this.isTamed() && this.isSitting()) {
            return false;
        }
        IBlockState blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151584_j) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151597_y) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151596_z) {
                return true;
            }
        }
        return blockState.func_177230_c() == Blocks.field_150424_aL;
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        if (type.equals("cactus")) {
            return false;
        }
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }
}

