/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityVolcan
extends TameableCreatureEntity
implements IMob {
    public int blockMeltingRadius = 2;

    public EntityVolcan(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void loadCreatureFlags() {
        this.blockMeltingRadius = this.creatureInfo.getFlag("blockMeltingRadius", this.blockMeltingRadius);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L) {
            List<EntityLivingBase> aoeTargets = this.getNearbyEntities(EntityLivingBase.class, null, 4.0);
            for (EntityLivingBase entityObj : aoeTargets) {
                EntityLivingBase target = entityObj;
                if (target == this || !this.func_70686_a(target.getClass()) || !this.canAttackEntity(target) || !this.func_70635_at().func_75522_a((Entity)target)) continue;
                target.func_70015_d(2);
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.updateTick % 40L == 0L && this.blockMeltingRadius > 0 && !this.isTamed() && this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing")) {
            int range = this.blockMeltingRadius;
            int w = -((int)Math.ceil(this.field_70130_N) + range);
            while ((double)w <= Math.ceil(this.field_70130_N) + (double)range) {
                int d = -((int)Math.ceil(this.field_70130_N) + range);
                while ((double)d <= Math.ceil(this.field_70130_N) + (double)range) {
                    int h = -((int)Math.ceil(this.field_70131_O) + range);
                    while ((double)h <= Math.ceil(this.field_70131_O)) {
                        Block block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(w, h, d)).func_177230_c();
                        if (block == Blocks.field_150347_e || block == Blocks.field_150351_n) {
                            IBlockState blockState = Blocks.field_150356_k.func_176203_a(11);
                            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(w, h, d), blockState);
                        }
                        ++h;
                    }
                    ++d;
                }
                ++w;
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.DRIP_LAVA, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (target instanceof EntitySilverfish) {
            target.func_70106_y();
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (itemStack != null && itemStack.func_77973_b() == Items.field_151133_ar && this.isTamed()) {
            commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Water");
        }
        return commands;
    }

    @Override
    public boolean performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("Water")) {
            this.replacePlayersItem(player, itemStack, new ItemStack(Items.field_151129_at));
            return true;
        }
        return super.performCommand(command, player, itemStack);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 0.0f;
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("cactus") || type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean waterDamage() {
        return true;
    }
}

