/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ProjectileBehaviourFireProjectiles
extends ProjectileBehaviour {
    public String projectileName;
    public int tickRate = 10;
    public int persistentCount = 0;
    public int impactCount = 5;
    public float velocity = 1.2f;

    @Override
    public void loadFromJSON(JsonObject json) {
        this.projectileName = json.get("projectileName").getAsString();
        if (json.has("tickRate")) {
            this.tickRate = json.get("tickRate").getAsInt();
        }
        if (json.has("impactCount")) {
            this.impactCount = json.get("impactCount").getAsInt();
        }
        if (json.has("persistentCount")) {
            this.persistentCount = json.get("persistentCount").getAsInt();
        }
        if (json.has("velocity")) {
            this.velocity = json.get("velocity").getAsFloat();
        }
    }

    @Override
    public void onProjectileUpdate(BaseProjectileEntity projectile) {
        if (this.tickRate < 0 || projectile.updateTick % (long)this.tickRate != 0L || projectile.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.persistentCount <= 0 || ((CustomProjectileEntity)projectile).spawnedProjectiles.size() < this.persistentCount) {
            this.createProjectile(projectile);
        }
    }

    @Override
    public void onProjectileImpact(BaseProjectileEntity projectile, World world, BlockPos pos) {
        if (projectile.func_130014_f_().field_72995_K) {
            return;
        }
        for (int i = 0; i < this.impactCount; ++i) {
            this.createProjectile(projectile);
        }
        for (BaseProjectileEntity spawnedProjectile : ((CustomProjectileEntity)projectile).spawnedProjectiles) {
            spawnedProjectile.func_70106_y();
        }
    }

    public BaseProjectileEntity createProjectile(BaseProjectileEntity projectile) {
        BaseProjectileEntity childProjectile;
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(this.projectileName);
        if (projectileInfo == null) {
            return null;
        }
        if (projectile.func_85052_h() != null) {
            childProjectile = projectileInfo.createProjectile(projectile.func_130014_f_(), projectile.func_85052_h());
            childProjectile.func_70107_b(projectile.func_174791_d().field_72450_a, projectile.func_174791_d().field_72448_b, projectile.func_174791_d().field_72449_c);
        } else {
            childProjectile = projectileInfo.createProjectile(projectile.func_130014_f_(), projectile.func_174791_d().field_72450_a, projectile.func_174791_d().field_72448_b, projectile.func_174791_d().field_72449_c);
        }
        if (childProjectile instanceof CustomProjectileEntity) {
            ((CustomProjectileEntity)childProjectile).setParent(projectile);
        }
        if (this.persistentCount > 0 && childProjectile instanceof CustomProjectileEntity) {
            ((CustomProjectileEntity)childProjectile).laserAngle = 360.0f / (float)this.persistentCount * (float)((CustomProjectileEntity)projectile).spawnedProjectiles.size();
            ((CustomProjectileEntity)projectile).spawnedProjectiles.add(childProjectile);
        }
        double motionT = projectile.field_70159_w + projectile.field_70181_x + projectile.field_70179_y;
        if (projectile.field_70159_w < 0.0) {
            motionT -= projectile.field_70159_w * 2.0;
        }
        if (projectile.field_70181_x < 0.0) {
            motionT -= projectile.field_70181_x * 2.0;
        }
        if (projectile.field_70179_y < 0.0) {
            motionT -= projectile.field_70179_y * 2.0;
        }
        childProjectile.func_70186_c(projectile.field_70159_w / motionT + (projectile.func_130014_f_().field_73012_v.nextGaussian() - 0.5), projectile.field_70181_x / motionT + (projectile.func_130014_f_().field_73012_v.nextGaussian() - 0.5), projectile.field_70179_y / motionT + (projectile.func_130014_f_().field_73012_v.nextGaussian() - 0.5), this.velocity, 0.0f);
        projectile.func_184185_a(childProjectile.getLaunchSound(), 1.0f, 1.0f / (projectile.func_130014_f_().field_73012_v.nextFloat() * 0.4f + 0.8f));
        projectile.func_130014_f_().func_72838_d((Entity)childProjectile);
        return childProjectile;
    }
}

