/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileBehaviourLaser
extends ProjectileBehaviour {
    public double speed = 1.0;
    public float width = 1.0f;
    public double range = 16.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("speed")) {
            this.speed = json.get("speed").getAsDouble();
        }
        if (json.has("width")) {
            this.width = json.get("width").getAsFloat();
        }
        if (json.has("range")) {
            this.range = json.get("range").getAsDouble();
        }
    }

    @Override
    public void onProjectileUpdate(BaseProjectileEntity projectile) {
        if (!(projectile instanceof CustomProjectileEntity)) {
            return;
        }
        projectile.movement = false;
        ((CustomProjectileEntity)projectile).syncThrower();
        ((CustomProjectileEntity)projectile).laserWidth = this.width;
        if (projectile.func_85052_h() != null) {
            Object entityToFollow = projectile.func_85052_h();
            if (((CustomProjectileEntity)projectile).getParent() != null) {
                entityToFollow = ((CustomProjectileEntity)projectile).getParent();
            }
            double xPos = entityToFollow.func_174791_d().field_72450_a;
            double yPos = entityToFollow.func_174813_aQ().field_72338_b + (double)entityToFollow.field_70131_O * 0.5;
            double zPos = entityToFollow.func_174791_d().field_72449_c;
            projectile.func_70107_b(xPos, yPos, zPos);
            projectile.field_70159_w = entityToFollow.field_70159_w;
            projectile.field_70181_x = entityToFollow.field_70181_x;
            projectile.field_70179_y = entityToFollow.field_70179_y;
        }
        this.updateEnd(projectile);
    }

    public void updateEnd(BaseProjectileEntity projectile) {
        double targetX = projectile.func_174791_d().field_72450_a;
        double targetY = projectile.func_174791_d().field_72448_b;
        double targetZ = projectile.func_174791_d().field_72449_c;
        boolean lockedLaser = false;
        if (((CustomProjectileEntity)projectile).getParent() != null) {
            double[] target = projectile.getFacingPosition((Entity)projectile, this.range, ((CustomProjectileEntity)projectile).laserAngle);
            targetX = target[0] + (double)(MathHelper.func_76134_b((float)(((float)projectile.updateTick + ((CustomProjectileEntity)projectile).laserAngle) * 0.25f)) * 1.0f - 0.5f);
            targetY = target[1] + (double)((MathHelper.func_76134_b((float)(((float)projectile.updateTick + ((CustomProjectileEntity)projectile).laserAngle) * 0.25f)) * 1.0f - 0.5f) * 10.0f);
            targetZ = target[2] + (double)(MathHelper.func_76134_b((float)(((float)projectile.updateTick + ((CustomProjectileEntity)projectile).laserAngle) * 0.25f)) * 1.0f - 0.5f);
        } else if (projectile.func_85052_h() != null) {
            Entity attackTarget;
            if (projectile.func_85052_h() instanceof BaseCreatureEntity && ((BaseCreatureEntity)projectile.func_85052_h()).func_70638_az() != null) {
                ((CustomProjectileEntity)projectile).setTarget((Entity)((BaseCreatureEntity)projectile.func_85052_h()).func_70638_az());
            }
            if ((attackTarget = ((CustomProjectileEntity)projectile).getTarget()) != null) {
                targetX = attackTarget.func_174791_d().field_72450_a;
                targetY = attackTarget.func_174791_d().field_72448_b + (double)(attackTarget.field_70131_O / 2.0f);
                targetZ = attackTarget.func_174791_d().field_72449_c;
                lockedLaser = true;
            } else {
                Vec3d lookDirection = projectile.func_85052_h().func_70040_Z();
                targetX = projectile.func_85052_h().func_174791_d().field_72450_a + lookDirection.field_72450_a * this.range;
                targetY = projectile.func_85052_h().func_174791_d().field_72448_b + (double)projectile.func_85052_h().func_70047_e() + lookDirection.field_72448_b * this.range;
                targetZ = projectile.func_85052_h().func_174791_d().field_72449_c + lookDirection.field_72449_c * this.range;
            }
        }
        HashSet<Entity> excludedEntities = new HashSet<Entity>();
        excludedEntities.add((Entity)projectile);
        if (projectile.func_85052_h() != null) {
            excludedEntities.add((Entity)projectile.func_85052_h());
            if (projectile.func_85052_h().func_184179_bs() != null) {
                excludedEntities.add(projectile.func_85052_h().func_184179_bs());
            }
        }
        RayTraceResult rayTraceResult = Utilities.raytrace(projectile.func_130014_f_(), projectile.func_174791_d().field_72450_a, projectile.func_174791_d().field_72448_b, projectile.func_174791_d().field_72449_c, targetX, targetY, targetZ, this.width, excludedEntities);
        Entity entityHit = null;
        if (rayTraceResult != null) {
            if (!lockedLaser) {
                targetX = rayTraceResult.field_72307_f.field_72450_a;
                targetY = rayTraceResult.field_72307_f.field_72448_b;
                targetZ = rayTraceResult.field_72307_f.field_72449_c;
            }
            if (rayTraceResult.field_72308_g != null) {
                entityHit = rayTraceResult.field_72308_g;
                targetY += (double)(entityHit.field_70131_O / 2.0f);
            }
        }
        ((CustomProjectileEntity)projectile).setLaserEnd(new Vec3d(targetX, targetY, targetZ));
        if (projectile.updateTick % 10L == 0L && projectile.func_70089_S() && entityHit != null && ((CustomProjectileEntity)projectile).getLaserEnd().func_72438_d(entityHit.func_174791_d()) <= (double)(this.width * 10.0f)) {
            boolean doDamage = true;
            if (entityHit instanceof EntityLivingBase) {
                doDamage = projectile.canDamage((EntityLivingBase)entityHit);
            }
            if (doDamage) {
                this.updateDamage(projectile, entityHit);
            }
        }
        if (projectile.projectileLife % 2 == 0) {
            projectile.func_184185_a(projectile.getBeamSound(), 1.0f, 1.0f / (projectile.func_130014_f_().field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    }

    public boolean updateDamage(BaseProjectileEntity projectile, Entity target) {
        boolean attackSuccess;
        float damage;
        float damageInit = damage = projectile.getDamage(target);
        double targetKnockbackResistance = 0.0;
        if (projectile.knockbackChance < 1.0 && (projectile.knockbackChance <= 0.0 || projectile.func_130014_f_().field_73012_v.nextDouble() <= projectile.knockbackChance) && target instanceof EntityLivingBase) {
            targetKnockbackResistance = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        }
        if (projectile.func_85052_h() instanceof BaseCreatureEntity) {
            BaseCreatureEntity creatureThrower = (BaseCreatureEntity)projectile.func_85052_h();
            attackSuccess = creatureThrower.doRangedDamage(target, projectile, damage, projectile.isBlockedByEntity(target, projectile.func_174791_d()));
        } else {
            double pierceDamage = 1.0;
            if ((double)damage <= pierceDamage) {
                attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)projectile, (Entity)projectile.func_85052_h()).func_76348_h().func_151518_m(), damage);
            } else {
                int hurtResistantTimeBefore = target.field_70172_ad;
                target.func_70097_a(DamageSource.func_76356_a((Entity)projectile, (Entity)projectile.func_85052_h()).func_76348_h().func_151518_m(), (float)pierceDamage);
                target.field_70172_ad = hurtResistantTimeBefore;
                damage = (float)((double)damage - pierceDamage);
                attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)projectile, (Entity)projectile.func_85052_h()), damage);
            }
        }
        if (target instanceof EntityLivingBase) {
            projectile.onDamage((EntityLivingBase)target, damageInit, attackSuccess);
        }
        if (projectile.knockbackChance < 1.0 && (projectile.knockbackChance <= 0.0 || projectile.func_130014_f_().field_73012_v.nextDouble() <= projectile.knockbackChance) && target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
        }
        return attackSuccess;
    }

    @Override
    public void onProjectileImpact(BaseProjectileEntity projectile, World world, BlockPos pos) {
    }
}

