/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.special;

import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.pets.PetEntry;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemSoulContract
extends ItemBase {
    public ItemSoulContract() {
        this.func_77625_d(1);
        this.itemName = "soul_contract";
        this.setup();
    }

    public UUID getOwnerUUID(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        UUID uuid = null;
        if (nbt.func_186855_b("ownerUUID")) {
            uuid = nbt.func_186857_a("ownerUUID");
        }
        return uuid;
    }

    public UUID getPetEntryUUID(ItemStack itemStack) {
        NBTTagCompound nbt = this.getTagCompound(itemStack);
        UUID uuid = null;
        if (nbt.func_186855_b("petEntryUUID")) {
            uuid = nbt.func_186857_a("petEntryUUID");
        }
        return uuid;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        super.func_77624_a(itemStack, world, tooltip, tooltipFlag);
        UUID ownerUUID = this.getOwnerUUID(itemStack);
        UUID petEntryUUID = this.getPetEntryUUID(itemStack);
        if (ownerUUID != null && petEntryUUID != null) {
            EntityPlayer owner = world.func_152378_a(ownerUUID);
            ExtendedPlayer extendedOwner = ExtendedPlayer.getForPlayer(owner);
            if (owner == null || extendedOwner == null) {
                tooltip.add(LanguageManager.translate("item.lycanitesmobs.soul_contract.offline"));
                return;
            }
            PetEntry petEntry = extendedOwner.petManager.getEntry(petEntryUUID);
            if (petEntry == null) {
                tooltip.add(LanguageManager.translate("item.lycanitesmobs.soul_contract.released"));
                tooltip.add(LanguageManager.translate("item.lycanitesmobs.soul_contract.owner") + " " + owner.func_145748_c_());
                return;
            }
            tooltip.add(LanguageManager.translate("item.lycanitesmobs.soul_contract.bound") + " " + petEntry.getDisplayName());
            tooltip.add(LanguageManager.translate("item.lycanitesmobs.soul_contract.owner") + " " + owner.func_145748_c_().func_150254_d());
        }
    }

    @Override
    public boolean onItemRightClickOnEntity(EntityPlayer player, Entity entity, ItemStack itemStack) {
        if (!(entity instanceof TameableCreatureEntity) || !((TameableCreatureEntity)entity).isBoundPet()) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.invalid")));
            }
            return false;
        }
        TameableCreatureEntity tameableCreatureEntity = (TameableCreatureEntity)entity;
        UUID ownerUUID = this.getOwnerUUID(itemStack);
        UUID petEntryUUID = this.getPetEntryUUID(itemStack);
        if (ownerUUID == null || petEntryUUID == null) {
            return this.bindSoul(itemStack, player, tameableCreatureEntity);
        }
        return this.transferSoul(itemStack, player, tameableCreatureEntity, ownerUUID, petEntryUUID);
    }

    public boolean bindSoul(ItemStack itemStack, EntityPlayer player, TameableCreatureEntity tameableCreatureEntity) {
        if (tameableCreatureEntity.getPlayerOwner() != player || "familiar".equalsIgnoreCase(tameableCreatureEntity.getPetEntry().getType())) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.not_owner")));
            }
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            NBTTagCompound nbt = this.getTagCompound(itemStack);
            nbt.func_186854_a("ownerUUID", player.func_110124_au());
            nbt.func_186854_a("petEntryUUID", tameableCreatureEntity.getPetEntry().petEntryID);
            itemStack.func_77982_d(nbt);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemStack);
            player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.bound")));
        }
        return true;
    }

    public boolean transferSoul(ItemStack itemStack, EntityPlayer player, TameableCreatureEntity tameableCreatureEntity, UUID ownerUUID, UUID petEntryUUID) {
        if (player.func_110124_au().equals(ownerUUID)) {
            if (petEntryUUID.equals(tameableCreatureEntity.getPetEntry().petEntryID)) {
                if (!player.func_130014_f_().field_72995_K) {
                    NBTTagCompound nbt = this.getTagCompound(itemStack);
                    nbt.func_82580_o("ownerUUID");
                    nbt.func_82580_o("petEntryUUID");
                    itemStack.func_77982_d(nbt);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemStack);
                    player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.unbound")));
                }
                return true;
            }
            return this.bindSoul(itemStack, player, tameableCreatureEntity);
        }
        if (!petEntryUUID.equals(tameableCreatureEntity.getPetEntry().petEntryID)) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.wrong_target")));
            }
            return false;
        }
        EntityPlayer owner = player.func_130014_f_().func_152378_a(ownerUUID);
        ExtendedPlayer extendedOwner = ExtendedPlayer.getForPlayer(owner);
        if (owner == null || extendedOwner == null) {
            if (!player.func_130014_f_().field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.owner_missing")));
            }
            return false;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(player);
        if (extendedPlayer == null) {
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            extendedOwner.petManager.removeEntry(tameableCreatureEntity.getPetEntry());
            extendedPlayer.petManager.addEntry(tameableCreatureEntity.getPetEntry());
            extendedOwner.sendPetEntriesToPlayer(tameableCreatureEntity.getPetEntry().getType());
            extendedOwner.sendPetEntryRemoveToPlayer(tameableCreatureEntity.getPetEntry());
            extendedPlayer.sendPetEntriesToPlayer(tameableCreatureEntity.getPetEntry().getType());
            owner.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.transferred")));
            player.func_145747_a((ITextComponent)new TextComponentString(LanguageManager.translate("message.soul_contract.transferred")));
        }
        tameableCreatureEntity.setPlayerOwner(player);
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        return true;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.getOwnerUUID(itemStack) != null && this.getPetEntryUUID(itemStack) != null;
    }
}

