/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureRelationshipEntry;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageCreature
implements IMessage,
IMessageHandler<MessageCreature, IMessage> {
    int entityID;
    int playerReputation = 0;

    public MessageCreature() {
    }

    public MessageCreature(BaseCreatureEntity creatureEntity, int playerReputation) {
        this.entityID = creatureEntity.func_145782_y();
        this.playerReputation = playerReputation;
    }

    public IMessage onMessage(MessageCreature message, MessageContext ctx) {
        if (ctx.side != Side.CLIENT) {
            return null;
        }
        EntityPlayer player = LycanitesMobs.proxy.getClientPlayer();
        World world = player.func_130014_f_();
        Entity entity = world.func_73045_a(message.entityID);
        if (!(entity instanceof BaseCreatureEntity)) {
            return null;
        }
        BaseCreatureEntity creatureEntity = (BaseCreatureEntity)entity;
        CreatureRelationshipEntry relationshipEntry = creatureEntity.relationships.getOrCreateEntry((Entity)player);
        relationshipEntry.setReputation(message.playerReputation);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            this.entityID = packet.readInt();
            this.playerReputation = packet.readInt();
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem decoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeInt(this.entityID);
        packet.writeInt(this.playerReputation);
    }
}

