/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageCreatureKnowledge
implements IMessage,
IMessageHandler<MessageCreatureKnowledge, IMessage> {
    public String creatureName;
    public int rank;
    public int experience;

    public MessageCreatureKnowledge() {
    }

    public MessageCreatureKnowledge(CreatureKnowledge creatureKnowledge) {
        this.creatureName = creatureKnowledge.creatureName;
        this.rank = creatureKnowledge.rank;
        this.experience = creatureKnowledge.experience;
    }

    public IMessage onMessage(MessageCreatureKnowledge message, MessageContext ctx) {
        if (ctx.side != Side.CLIENT) {
            return null;
        }
        EntityPlayer player = LycanitesMobs.proxy.getClientPlayer();
        ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
        if (playerExt == null) {
            return null;
        }
        playerExt.beastiary.addCreatureKnowledge(new CreatureKnowledge(playerExt.beastiary, message.creatureName, message.rank, message.experience), false);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        try {
            this.creatureName = packet.func_150789_c(256);
            this.rank = packet.readInt();
            this.experience = packet.readInt();
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem decoding the packet: " + packet + ".");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.func_180714_a(this.creatureName);
        packet.writeInt(this.rank);
        packet.writeInt(this.experience);
    }
}

