/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.network;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageEntityPerched
implements IMessage,
IMessageHandler<MessageEntityPerched, IMessage> {
    public int perchedOnEntityID;
    public int perchedByEntityID;

    public MessageEntityPerched() {
    }

    public MessageEntityPerched(Entity perchedOnEntity, Entity perchedByEntity) {
        this.perchedOnEntityID = perchedOnEntity.func_145782_y();
        this.perchedByEntityID = perchedByEntity != null ? perchedByEntity.func_145782_y() : 0;
    }

    public IMessage onMessage(MessageEntityPerched message, MessageContext ctx) {
        Entity perchedByEntity;
        if (ctx.side != Side.CLIENT) {
            return null;
        }
        EntityPlayer player = LycanitesMobs.proxy.getClientPlayer();
        World world = player.func_130014_f_();
        Entity perchedOnEntity = world.func_73045_a(message.perchedOnEntityID);
        Entity entity = perchedByEntity = message.perchedByEntityID != 0 ? world.func_73045_a(message.perchedByEntityID) : null;
        if (!(perchedOnEntity instanceof EntityLivingBase)) {
            return null;
        }
        ExtendedEntity perchedOnEntityExt = ExtendedEntity.getForEntity((EntityLivingBase)perchedOnEntity);
        if (perchedOnEntityExt != null) {
            perchedOnEntityExt.setPerchedByEntity(perchedByEntity);
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.perchedOnEntityID = packet.readInt();
        this.perchedByEntityID = packet.readInt();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.writeInt(this.perchedOnEntityID);
        packet.writeInt(this.perchedByEntityID);
    }
}

