/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.location;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.spawner.location.RandomSpawnLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class VillageSpawnLocation
extends RandomSpawnLocation {
    public int villageRange = 128;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        if (json.has("villageRange")) {
            this.villageRange = json.get("villageRange").getAsInt();
        }
    }

    @Override
    public List<BlockPos> getSpawnPositions(World world, EntityPlayer player, BlockPos triggerPos) {
        LycanitesMobs.logDebug("JSONSpawner", "Getting Nearest Village Within Range");
        Village village = world.func_175714_ae().func_176056_a(triggerPos, this.villageRange);
        if (village == null) {
            LycanitesMobs.logDebug("JSONSpawner", "No Village within range found.");
            return new ArrayList<BlockPos>();
        }
        double villageDistance = Math.sqrt(village.func_180608_a().func_177951_i((Vec3i)triggerPos));
        if (villageDistance > (double)this.villageRange) {
            LycanitesMobs.logDebug("JSONSpawner", "No Village within range, nearest was: " + villageDistance + " at: " + village.func_180608_a());
            return new ArrayList<BlockPos>();
        }
        LycanitesMobs.logDebug("JSONSpawner", "Found a Village within range, at: " + village.func_180608_a());
        return super.getSpawnPositions(world, player, village.func_180608_a());
    }
}

