/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.worldgen.mobevents;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.block.BlockFireBase;
import com.lycanitesmobs.core.entity.creature.EntityAmalgalich;
import com.lycanitesmobs.core.entity.projectile.EntityShadowfireBarrier;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.mobevent.effects.StructureBuilder;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AmalgalichStructureBuilder
extends StructureBuilder {
    public AmalgalichStructureBuilder() {
        this.name = "amalgalich";
    }

    @Override
    public void build(World world, EntityPlayer player, BlockPos pos, int level, int ticks, int variant) {
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        int originX = pos.func_177958_n();
        int originY = pos.func_177956_o();
        int originZ = pos.func_177952_p();
        originX += 20;
        int height = 40;
        if (originY < 5) {
            originY = 5;
        }
        if (world.func_72800_K() <= height) {
            originY = 5;
        } else if (originY + height >= world.func_72800_K()) {
            originY = Math.max(5, world.func_72800_K() - height - 1);
        }
        if (ticks == 1) {
            for (int i = 0; i < 5; ++i) {
                EntityShadowfireBarrier baseProjectileEntity = new EntityShadowfireBarrier(world, originX, originY + 10 * i, originZ);
                baseProjectileEntity.projectileLife = 400;
                world.func_72838_d((Entity)baseProjectileEntity);
                if (worldExt == null) continue;
                worldExt.bossUpdate((Entity)baseProjectileEntity);
            }
        }
        if (ticks == 60) {
            this.buildArenaFloor(world, originX, originY, originZ);
        }
        if (ticks == 100) {
            this.buildObstacles(world, originX, originY, originZ);
        }
        if (ticks >= 200 && ticks % 10 == 0) {
            world.func_72876_a(null, (double)(originX - 20 + world.field_73012_v.nextInt(40)), (double)(originY + 25 + world.field_73012_v.nextInt(10)), (double)(originZ - 20 + world.field_73012_v.nextInt(40)), 2.0f, true);
        }
        if (ticks == 400) {
            MobEventPlayerServer mobEventPlayerServer;
            EntityAmalgalich baseCreatureEntity = new EntityAmalgalich(world);
            baseCreatureEntity.func_70012_b(originX, originY + 1, originZ, 0.0f, 0.0f);
            world.func_72838_d((Entity)baseCreatureEntity);
            baseCreatureEntity.setArenaCenter(new BlockPos(originX, originY + 1, originZ));
            if (worldExt != null && (mobEventPlayerServer = worldExt.getMobEventPlayerServer(this.name)) != null) {
                mobEventPlayerServer.mobEvent.onSpawn(baseCreatureEntity, world, player, pos, level, ticks, variant);
            }
        }
    }

    public void buildArenaFloor(World world, int originX, int originY, int originZ) {
        int radius = 60;
        int height = 40;
        Block primaryBlock = ObjectManager.getBlock("shadowstonetile");
        Block secondaryBlock = ObjectManager.getBlock("shadowcrystal");
        double secondaryChance = 0.05;
        int stripNumber = 1;
        for (int x = originX - radius; x < originX + radius; ++x) {
            float stripNormal = (float)stripNumber / (float)radius;
            if (stripNumber > radius) {
                stripNormal = (float)(radius - (stripNumber - radius)) / (float)radius;
            }
            int stripRadius = Math.round((float)radius * (float)Math.sin(Math.toRadians(90.0f * stripNormal)));
            for (int z = originZ - stripRadius; z < originZ + stripRadius; ++z) {
                int y = originY;
                Block buildBlock = primaryBlock;
                if (world.field_73012_v.nextDouble() <= secondaryChance) {
                    buildBlock = secondaryBlock;
                }
                world.func_180501_a(new BlockPos(x, y, z), buildBlock.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x, y - 1, z), buildBlock.func_176223_P(), 2);
                world.func_180501_a(new BlockPos(x, y - 2, z), buildBlock.func_176223_P(), 2);
                ++y;
                while (y <= originY + height && y < world.func_72800_K()) {
                    world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
                    ++y;
                }
            }
            ++stripNumber;
        }
    }

    public void buildObstacles(World world, int originX, int originY, int originZ) {
        double angle = 0.0;
        int radius = 50;
        ArrayList<int[]> decorationCoords = new ArrayList<int[]>();
        while (angle < 360.0) {
            double angleRadians = Math.toRadians(angle += 5.0 + 5.0 * world.field_73012_v.nextDouble());
            double x = (double)radius * Math.cos(angleRadians) - Math.sin(angleRadians);
            double z = (double)radius * Math.sin(angleRadians) + Math.cos(angleRadians);
            decorationCoords.add(this.buildPillar(world, originX + (int)Math.ceil(x), originY, originZ + (int)Math.ceil(z)));
        }
    }

    public int[] buildPillar(World world, int originX, int originY, int originZ) {
        int radiusMax = 6;
        int height = 30;
        Block primaryBlock = ObjectManager.getBlock("shadowstonebrick");
        Block secondaryBlock = ObjectManager.getBlock("shadowstone");
        Block tetriaryBlock = ObjectManager.getBlock("shadowstonechiseled");
        Block capBlock = Blocks.field_150343_Z;
        Block hazardBlock = ObjectManager.getBlock("shadowfire");
        double secondaryChance = 0.4;
        double tetriaryChance = 0.05;
        int[] decorationCoord = new int[]{originX, originY, originZ};
        int radius = radiusMax;
        int radiusHeight = height - 10;
        for (int y = originY; y <= originY + height; ++y) {
            boolean lowerRadius = --radiusHeight <= 0;
            int stripNumber = 1;
            for (int x = originX - radius; x <= originX + radius; ++x) {
                float stripNormal = (float)stripNumber / (float)radius;
                if (stripNumber > radius) {
                    stripNormal = (float)(radius - (stripNumber - radius)) / (float)radius;
                }
                int stripRadius = Math.round((float)radius * (float)Math.sin(Math.toRadians(90.0f * stripNormal)));
                for (int z = originZ - stripRadius; z <= originZ + stripRadius; ++z) {
                    if (lowerRadius || y == originY + height) {
                        world.func_180501_a(new BlockPos(x, y, z), hazardBlock.func_176223_P().func_177226_a((IProperty)BlockFireBase.STATIC, (Comparable)Boolean.valueOf(true)), 2);
                        continue;
                    }
                    if (radiusHeight - 1 <= 0 || y == originY + height - 1) {
                        world.func_180501_a(new BlockPos(x, y, z), capBlock.func_176223_P(), 2);
                        continue;
                    }
                    if (world.field_73012_v.nextDouble() > secondaryChance) {
                        world.func_180501_a(new BlockPos(x, y, z), primaryBlock.func_176223_P(), 2);
                        continue;
                    }
                    if (world.field_73012_v.nextDouble() > tetriaryChance) {
                        world.func_180501_a(new BlockPos(x, y, z), secondaryBlock.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(new BlockPos(x, y, z), tetriaryBlock.func_176223_P(), 2);
                }
                ++stripNumber;
            }
            if (!lowerRadius) continue;
            radiusHeight = radiusMax;
            --radius;
        }
        return decorationCoord;
    }

    public void buildDecoration(World world, int originX, int originY, int originZ) {
        Block primaryBlock = Blocks.field_150343_Z;
        Block hazardBlock = ObjectManager.getBlock("shadowfire");
        world.func_180501_a(new BlockPos(originX, originY + 1, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 2, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 3, originZ), hazardBlock.func_176223_P().func_177226_a((IProperty)BlockFireBase.STATIC, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(originX + 1, originY + 1, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX + 1, originY + 2, originZ), hazardBlock.func_176223_P().func_177226_a((IProperty)BlockFireBase.STATIC, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(originX - 1, originY + 1, originZ), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX - 1, originY + 2, originZ), hazardBlock.func_176223_P().func_177226_a((IProperty)BlockFireBase.STATIC, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(originX, originY + 1, originZ + 1), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 2, originZ + 1), hazardBlock.func_176223_P().func_177226_a((IProperty)BlockFireBase.STATIC, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(originX, originY + 1, originZ - 1), primaryBlock.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(originX, originY + 2, originZ - 1), hazardBlock.func_176223_P().func_177226_a((IProperty)BlockFireBase.STATIC, (Comparable)Boolean.valueOf(true)), 2);
    }
}

