/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.setbonus.common.bonuselements;

import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import com.fantasticsource.mctools.potions.Potions;
import com.fantasticsource.setbonus.client.ClientData;
import com.fantasticsource.setbonus.common.Bonus;
import com.fantasticsource.setbonus.common.bonuselements.ABonusElement;
import com.fantasticsource.setbonus.server.ServerData;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;

public class PotionBonus
extends ABonusElement {
    public ArrayList<FantasticPotionEffect> potions;

    protected PotionBonus(String parsableBonusElement, Bonus bonus, ArrayList<FantasticPotionEffect> potions) {
        super(parsableBonusElement, bonus);
        this.potions = potions;
    }

    public static PotionBonus getInstance(String parsablePotionBonus, Side side) {
        Bonus bonus;
        String[] tokens = parsablePotionBonus.split(",");
        if (tokens.length < 2) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.notEnoughPotionBonusArgs", (Object[])new Object[]{parsablePotionBonus}));
            return null;
        }
        Bonus bonus2 = bonus = side == Side.SERVER ? (Bonus)ServerData.bonuses.get(tokens[0].trim()) : (Bonus)ClientData.bonuses.get(tokens[0].trim());
        if (bonus == null) {
            System.err.println(I18n.func_74837_a((String)"setbonus.error.potionBonusIDNotFound", (Object[])new Object[]{tokens[0].trim(), parsablePotionBonus}));
            return null;
        }
        ArrayList potions = Potions.parsePotions((String[])Arrays.copyOfRange(tokens, 1, tokens.length), (boolean)true);
        if (potions.size() == 0) {
            return null;
        }
        return new PotionBonus(parsablePotionBonus, bonus, potions);
    }

    @Override
    public void activate(EntityPlayer player) {
        long tick = ServerTickTimer.currentTick();
        for (FantasticPotionEffect potion : this.potions) {
            if (potion.interval != 0 && tick % (long)potion.interval != 0L) continue;
            player.func_70690_d(new PotionEffect((PotionEffect)potion));
        }
    }

    @Override
    public void deactivate(EntityPlayer player) {
        for (PotionEffect potionEffect : this.potions) {
            player.func_184589_d(potionEffect.func_188419_a());
        }
    }

    @Override
    public void updateActive(EntityPlayer player) {
        long tick = ServerTickTimer.currentTick();
        for (FantasticPotionEffect potion : this.potions) {
            if (potion.interval != 0 && tick % (long)potion.interval != 0L) continue;
            player.func_70690_d(new PotionEffect((PotionEffect)potion));
        }
    }
}

