/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common.blocks;

import c4.comforts.common.ConfigHandler;
import c4.comforts.common.blocks.BlockBase;
import c4.comforts.common.blocks.BlockRope;
import c4.comforts.common.entities.EntityRest;
import c4.comforts.common.items.ComfortsItems;
import c4.comforts.common.tileentities.TileEntityHammock;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHammock
extends BlockBase {
    protected static final AxisAlignedBB HAMMOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockHammock(EnumDyeColor color) {
        super("hammock", color);
        this.setExplosivePower(1.0f);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ConfigHandler.restHammocks && !playerIn.func_70093_af()) {
            TileEntity tileentity;
            if (worldIn.field_72995_K) {
                return true;
            }
            if (state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD) {
                BlockPos blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D));
                IBlockState blockstate = worldIn.func_180495_p(blockpos);
                if (blockstate.func_177230_c() != this) {
                    return true;
                }
                if (((Boolean)blockstate.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                    EntityPlayer entityplayer = this.getPlayerInComfort(worldIn, blockpos);
                    if (entityplayer != null) {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textOccupied, new Object[0]), true);
                        return true;
                    }
                    blockstate = blockstate.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false));
                    worldIn.func_180501_a(blockpos, blockstate, 4);
                }
            }
            if ((tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityHammock) {
                TileEntityHammock tileentityhammock = (TileEntityHammock)tileentity;
                if (tileentityhammock.isOccupied()) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textOccupied, new Object[0]), true);
                    return true;
                }
                EntityRest rest = new EntityRest(worldIn, pos);
                worldIn.func_72838_d((Entity)rest);
                playerIn.func_184220_m((Entity)rest);
                tileentityhammock.setOccupied(true);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
            IBlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d()));
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                if (blockstate.func_177230_c() instanceof BlockRope && ((Boolean)blockstate.func_177229_b((IProperty)BlockRope.SUPPORTING)).booleanValue() && blockstate.func_177229_b((IProperty)field_185512_D) == enumfacing) {
                    worldIn.func_175656_a(pos.func_177972_a(enumfacing.func_176734_d()), blockstate.func_177226_a((IProperty)BlockRope.SUPPORTING, (Comparable)Boolean.valueOf(false)));
                }
            } else if (!(blockstate.func_177230_c() instanceof BlockRope)) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
            IBlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(enumfacing));
            if (blockstate1.func_177230_c() instanceof BlockRope && ((Boolean)blockstate1.func_177229_b((IProperty)BlockRope.SUPPORTING)).booleanValue() && blockstate1.func_177229_b((IProperty)field_185512_D) == enumfacing.func_176734_d()) {
                worldIn.func_175656_a(pos.func_177972_a(enumfacing), blockstate1.func_177226_a((IProperty)BlockRope.SUPPORTING, (Comparable)Boolean.valueOf(false)));
            }
        } else if (!(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() instanceof BlockRope)) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ComfortsItems.HAMMOCK, 1, this.color);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT ? Items.field_190931_a : ComfortsItems.HAMMOCK;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return HAMMOCK_AABB;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityHammock();
    }
}

