/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.scalinghealth.config.Config;

@Mod.EventBusSubscriber(modid="scalinghealth")
public final class PlayerBonusRegenHandler {
    private static final Map<String, Integer> TIMERS = new HashMap<String, Integer>();

    private PlayerBonusRegenHandler() {
    }

    static int getTimerForPlayer(EntityPlayer player) {
        if (player == null || !TIMERS.containsKey(player.func_70005_c_())) {
            return -1;
        }
        return TIMERS.get(player.func_70005_c_());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || !Config.Player.BonusRegen.enabled) {
            return;
        }
        EntityPlayer player = event.player;
        int health = (int)Math.ceil(player.func_110143_aJ());
        if ((float)health >= player.func_110138_aP()) {
            return;
        }
        String name = player.func_70005_c_();
        if (!TIMERS.containsKey(name)) {
            TIMERS.put(name, Config.Player.BonusRegen.initialDelay);
        }
        int foodLevel = player.func_71024_bL().func_75116_a();
        boolean foodLevelOk = MathUtils.inRangeInclusive((int)foodLevel, (int)Config.Player.BonusRegen.minFood, (int)Config.Player.BonusRegen.maxFood);
        boolean healthLevelOk = MathUtils.inRangeExclusive((int)health, (int)Config.Player.BonusRegen.minHealth, (int)Config.Player.BonusRegen.maxHealth);
        if (foodLevelOk && healthLevelOk) {
            int timer = TIMERS.get(name);
            if (--timer <= 0) {
                player.func_70691_i(PlayerBonusRegenHandler.getRegenTickHealAmount((EntityLivingBase)player));
                player.func_71020_j(Config.Player.BonusRegen.exhaustion);
                timer = Config.Player.BonusRegen.delay;
            }
            TIMERS.put(name, timer);
        }
    }

    private static float getRegenTickHealAmount(EntityLivingBase entity) {
        if (Config.Player.BonusRegen.scaleWithMaxHealth) {
            IAttributeInstance attr = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
            double baseHealth = attr.func_111125_b();
            double maxHealth = attr.func_111126_e();
            return (float)(maxHealth / baseHealth);
        }
        return 1.0f;
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (!entityLiving.field_70170_p.field_72995_K && entityLiving instanceof EntityPlayer) {
            TIMERS.put(entityLiving.func_70005_c_(), Config.Player.BonusRegen.initialDelay);
        }
    }
}

