/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.lib.util.AttributeHelper;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.compat.gamestages.SHGameStagesCompat;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.lib.EnumAreaDifficultyMode;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageDataSync;
import net.silentchaos512.scalinghealth.network.message.MessageWorldDataSync;
import net.silentchaos512.scalinghealth.scoreboard.SHScoreCriteria;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.world.ScalingHealthSavedData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class SHPlayerDataHandler {
    private static final String NBT_ROOT = "scalinghealth_data";
    private static final Map<Integer, PlayerData> playerData = new ConcurrentHashMap<Integer, PlayerData>();

    private SHPlayerDataHandler() {
    }

    @Nullable
    public static PlayerData get(EntityPlayer player) {
        PlayerData data;
        if (player instanceof FakePlayer && !Config.FakePlayer.haveDifficulty) {
            return null;
        }
        int key = SHPlayerDataHandler.getKey(player);
        if (!playerData.containsKey(key)) {
            playerData.put(key, new PlayerData(player));
        }
        if ((data = playerData.get(key)) != null && data.playerWR.get() != player) {
            NBTTagCompound tags = new NBTTagCompound();
            data.writeToNBT(tags);
            playerData.remove(key);
            data = SHPlayerDataHandler.get(player);
            assert (data != null);
            data.readFromNBT(tags);
        }
        return data;
    }

    private static void cleanup() {
        ArrayList<Integer> remove = new ArrayList<Integer>();
        for (int i : playerData.keySet()) {
            PlayerData d = playerData.get(i);
            if (d == null || d.playerWR.get() != null) continue;
            remove.add(i);
        }
        for (int i : remove) {
            playerData.remove(i);
        }
    }

    private static int getKey(EntityPlayer player) {
        return player.hashCode() << 1 + (player.field_70170_p.field_72995_K ? 1 : 0);
    }

    private static NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        NBTTagCompound persistentData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(NBT_ROOT)) {
            persistentData.func_74782_a(NBT_ROOT, (NBTBase)new NBTTagCompound());
        }
        return persistentData.func_74775_l(NBT_ROOT);
    }

    public static class PlayerData {
        static final String NBT_DIFFICULTY = "difficulty";
        static final String NBT_HEALTH = "health";
        static final String NBT_MAX_HEALTH = "max_health";
        static final String NBT_LAST_LOGIN = "last_login";
        private static final UUID UUID_XP_HEALTH_BONUS = UUID.fromString("3d3cb1b5-03b0-496a-aaac-60bf63ba139b");
        double difficulty = 0.0;
        float health = 20.0f;
        float maxHealth = Config.Player.Health.startingHealth;
        Calendar lastTimePlayed = Calendar.getInstance();
        WeakReference<EntityPlayer> playerWR;
        private final boolean client;
        private int lastPosX = 0;
        private int lastPosY = 0;
        private int lastPosZ = 0;

        public PlayerData(EntityPlayer player) {
            this.playerWR = new WeakReference<EntityPlayer>(player);
            this.client = player.field_70170_p.field_72995_K;
            this.load();
        }

        public double getDifficulty() {
            return this.difficulty;
        }

        public void setDifficulty(double value) {
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            this.difficulty = Config.Difficulty.DIFFICULTY_EXEMPT_PLAYERS.contains(player) ? 0.0 : MathHelper.func_151237_a((double)value, (double)Config.Difficulty.minValue, (double)Config.Difficulty.maxValue);
            if (player != null) {
                SHScoreCriteria.updateScore(player, (int)this.difficulty);
            }
        }

        public void incrementDifficulty(double amount) {
            this.incrementDifficulty(amount, false);
        }

        public void incrementDifficulty(double amount, boolean alsoAffectWorldDifficulty) {
            ScalingHealthSavedData data;
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null) {
                if (!player.field_70170_p.func_82736_K().func_82766_b("ScalingHealthDifficulty")) {
                    return;
                }
                if (Config.Difficulty.DIMENSION_INCREASE_MULTIPLIER.containsKey(player.field_71093_bK)) {
                    amount *= (double)Config.Difficulty.DIMENSION_INCREASE_MULTIPLIER.get(player.field_71093_bK).floatValue();
                }
            }
            this.setDifficulty(this.difficulty + amount);
            if (alsoAffectWorldDifficulty && player != null && (data = ScalingHealthSavedData.get(player.field_70170_p)) != null) {
                data.difficulty += amount;
                data.func_76185_a();
            }
        }

        public float getHealth() {
            return this.health;
        }

        public float getMaxHealth() {
            if (this.maxHealth < 2.0f) {
                this.maxHealth = Config.Player.Health.startingHealth;
            }
            return this.maxHealth;
        }

        public void setMaxHealth(float value) {
            if (!Config.Player.Health.allowModify) {
                return;
            }
            int configMax = Config.Player.Health.maxHealth <= 0 ? Integer.MAX_VALUE : Config.Player.Health.maxHealth;
            this.maxHealth = MathHelper.func_76131_a((float)value, (float)2.0f, (float)configMax);
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null) {
                ModifierHandler.setMaxHealth((EntityLivingBase)player, this.maxHealth, 0);
            }
            this.save();
            this.sendUpdateMessage();
        }

        public void incrementMaxHealth(float amount) {
            this.setMaxHealth(this.maxHealth + amount);
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null) {
                int current = (int)player.func_110143_aJ();
                EntityHelper.heal((EntityLivingBase)player, (float)amount, (boolean)Config.Items.Heart.healingEvent);
                int newHealth = (int)player.func_110143_aJ();
                if (current + (int)amount != newHealth) {
                    ScalingHealth.logHelper.warn("Another mod seems to have canceled healing from a max health increase (player {})", new Object[]{player.func_70005_c_()});
                }
            }
        }

        public Calendar getLastTimePlayed() {
            return this.lastTimePlayed;
        }

        private void tick() {
            if (!this.client) {
                EntityPlayer player = (EntityPlayer)this.playerWR.get();
                if (player == null) {
                    return;
                }
                if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                    float amount = Config.Difficulty.perSecond;
                    if (this.lastPosX == (int)player.field_70165_t && this.lastPosZ == (int)player.field_70161_v) {
                        amount *= Config.Difficulty.idleMulti;
                    }
                    this.incrementDifficulty(amount, false);
                    this.lastPosX = (int)player.field_70165_t;
                    this.lastPosY = (int)player.field_70163_u;
                    this.lastPosZ = (int)player.field_70161_v;
                    if (!Config.Difficulty.DIFFICULTY_BY_GAME_STAGES.isEmpty() && Loader.isModLoaded((String)"gamestages")) {
                        this.setDifficulty(SHGameStagesCompat.getDifficultyFromStages(player));
                    }
                    if (!Config.Player.Health.byXP.isEmpty()) {
                        int highestLevel = 0;
                        for (int key : Config.Player.Health.byXP.keySet()) {
                            if (key <= highestLevel || key > player.field_71068_ca) continue;
                            highestLevel = key;
                        }
                        if (Config.Player.Health.byXP.containsKey(highestLevel)) {
                            float modAmount = Config.Player.Health.byXP.get(highestLevel) - Config.Player.Health.startingHealth;
                            AttributeHelper.apply((EntityLivingBase)player, (IAttribute)SharedMonsterAttributes.field_111267_a, (UUID)UUID_XP_HEALTH_BONUS, (String)"health_from_xp", (double)modAmount, (int)0);
                        } else {
                            AttributeHelper.remove((EntityLivingBase)player, (IAttribute)SharedMonsterAttributes.field_111267_a, (UUID)UUID_XP_HEALTH_BONUS);
                        }
                    }
                }
                this.health = player.func_110143_aJ();
                if (player.field_70170_p.func_82737_E() % (long)Config.PACKET_DELAY == 0L) {
                    this.save();
                    this.sendUpdateMessage();
                }
            }
        }

        private void sendUpdateMessage() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                PlayerData data = SHPlayerDataHandler.get(player);
                if (data != null) {
                    MessageDataSync message = new MessageDataSync(data, player);
                    NetworkHandler.INSTANCE.sendTo((IMessage)message, playerMP);
                    if (Config.Difficulty.AREA_DIFFICULTY_MODE == EnumAreaDifficultyMode.SERVER_WIDE) {
                        MessageWorldDataSync message2 = new MessageWorldDataSync(ScalingHealthSavedData.get(player.field_70170_p));
                        NetworkHandler.INSTANCE.sendTo((IMessage)message2, playerMP);
                    }
                }
            }
        }

        public void save() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = SHPlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(tags);
            }
        }

        public void writeToNBT(NBTTagCompound tags) {
            tags.func_74780_a(NBT_DIFFICULTY, this.difficulty);
            tags.func_74776_a(NBT_HEALTH, this.health);
            tags.func_74776_a(NBT_MAX_HEALTH, this.maxHealth);
            int year = this.lastTimePlayed.get(1);
            int month = this.lastTimePlayed.get(2) + 1;
            int date = this.lastTimePlayed.get(5);
            String dateString = year + "/" + month + "/" + date;
            tags.func_74778_a(NBT_LAST_LOGIN, dateString);
        }

        public void load() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = SHPlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(tags);
            }
        }

        public void readFromNBT(NBTTagCompound tags) {
            this.difficulty = tags.func_74769_h(NBT_DIFFICULTY);
            this.health = tags.func_74760_g(NBT_HEALTH);
            this.maxHealth = tags.func_74760_g(NBT_MAX_HEALTH);
            String lastDatePlayed = tags.func_74779_i(NBT_LAST_LOGIN);
            String[] dateParts = lastDatePlayed.split("/");
            if (dateParts.length >= 3) {
                try {
                    int year = Integer.parseInt(dateParts[0]);
                    int month = Integer.parseInt(dateParts[1]) - 1;
                    int date = Integer.parseInt(dateParts[2]);
                    this.lastTimePlayed.set(year, month, date);
                }
                catch (NumberFormatException ex) {
                    ScalingHealth.logHelper.warn("Could not parse player's last login time.", new Object[0]);
                    ex.printStackTrace();
                }
            }
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                SHPlayerDataHandler.cleanup();
            }
        }

        @SubscribeEvent
        public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                PlayerData data = SHPlayerDataHandler.get(player);
                if (data != null) {
                    data.tick();
                }
                if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 5L * (long)Config.PACKET_DELAY == 0L) {
                    for (EntityPlayer p : EventHandler.getNearbyPlayers(player)) {
                        PlayerData data1 = SHPlayerDataHandler.get(p);
                        if (data1 == null) continue;
                        MessageDataSync message = new MessageDataSync(data1, p);
                        NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
                    }
                }
            }
        }

        private static Collection<EntityPlayer> getNearbyPlayers(EntityPlayer center) {
            int radius = Config.Difficulty.searchRadius;
            int radiusSquared = radius <= 0 ? Integer.MAX_VALUE : radius * radius;
            BlockPos centerPos = center.func_180425_c();
            return center.field_70170_p.func_175661_b(EntityPlayer.class, p -> p != null && !p.equals((Object)center) && p.func_174818_b(centerPos) < (double)radiusSquared);
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
                PlayerData data = SHPlayerDataHandler.get(event.player);
                if (data != null) {
                    MessageDataSync message = new MessageDataSync(data, event.player);
                    NetworkHandler.INSTANCE.sendTo((IMessage)message, playerMP);
                } else {
                    ScalingHealth.LOGGER.error("Player data for '{}' not found!", (Object)event.player.func_70005_c_());
                }
                if (Config.Difficulty.AREA_DIFFICULTY_MODE == EnumAreaDifficultyMode.SERVER_WIDE) {
                    MessageWorldDataSync message2 = new MessageWorldDataSync(ScalingHealthSavedData.get(event.player.field_70170_p));
                    NetworkHandler.INSTANCE.sendTo((IMessage)message2, playerMP);
                }
            }
        }
    }
}

