/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.Village;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Villagers {
    public static final ResourceLocation FARMER_TYPE = new ResourceLocation("minecraft:farmer");
    public static final ResourceLocation NITWIT_TYPE = new ResourceLocation("minecraft:nitwit");

    public static final boolean isKnownVillagerProfession(int profession) {
        return profession >= 0 && profession < 6;
    }

    public static boolean isFarmer(@Nullable EntityVillager villager) {
        return villager != null && FARMER_TYPE.equals((Object)villager.getProfessionForge().getRegistryName());
    }

    public static boolean isNitwit(@Nullable EntityVillager villager) {
        return villager != null && NITWIT_TYPE.equals((Object)villager.getProfessionForge().getRegistryName());
    }

    @Nullable
    public static final Village getVillagerVillage(@Nullable EntityVillager villager) {
        if (villager != null) {
            try {
                return (Village)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"villageObj", "field_70954_d"});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isPlayerReputationTooLow(@Nullable EntityVillager villager, EntityPlayer player) {
        if (!SharedGlue.isRealPlayer((Entity)player)) {
            return true;
        }
        Village village = Villagers.getVillagerVillage(villager);
        return village != null ? village.isPlayerReputationTooLow(player.func_110124_au()) : false;
    }

    public static int getVillagerCareer(@Nullable EntityVillager villager) {
        if (villager != null) {
            try {
                return (Integer)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"careerId", "field_175563_bv"});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getVillagerCareerLevel(@Nullable EntityVillager villager) {
        if (villager != null) {
            try {
                return (Integer)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"careerLevel", "field_175562_bw"});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    private Villagers() {
    }

    public static final void init() {
    }
}

