/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStone;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jwaresoftware.mcmods.lib.Locations;

@ParametersAreNonnullByDefault
public final class Whatis {
    @GameRegistry.ObjectHolder(value="minecraft:wheat_seeds")
    public static final Item wheat_seeds = null;
    @GameRegistry.ObjectHolder(value="minecraft:red_mushroom")
    public static final Block red_mushroom = null;
    @GameRegistry.ObjectHolder(value="minecraft:brown_mushroom")
    public static final Block brown_mushroom = null;
    @GameRegistry.ObjectHolder(value="minecraft:brown_mushroom_block")
    public static final Block brown_mushroom_block = null;
    @GameRegistry.ObjectHolder(value="minecraft:red_mushroom_block")
    public static final Block red_mushroom_block = null;
    @GameRegistry.ObjectHolder(value="minecraft:hopper")
    public static final Block hopper = null;

    public static final boolean isCobblestone(IBlockState what) {
        return what.func_177230_c() == Blocks.field_150347_e || what.func_177230_c() == Blocks.field_150341_Y;
    }

    public static final boolean isRawstone(IBlockState what) {
        return what.func_177230_c() == Blocks.field_150348_b ? what.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.STONE : false;
    }

    public static final boolean isCake(IBlockState what) {
        return what.func_177230_c() == Blocks.field_150414_aQ || what.func_177230_c() instanceof BlockCake;
    }

    public static final boolean isLikelyTree(World world, BlockPos blockpos, @Nonnull IBlockState blockstate) {
        if (!blockstate.func_177230_c().isWood((IBlockAccess)world, blockpos)) {
            return false;
        }
        if (!Locations.isOverworld(world)) {
            return false;
        }
        int radius = 3;
        int i = radius + 1;
        int leaf_block_count = 0;
        if (world.func_175707_a(blockpos.func_177982_a(-i, -i, -i), blockpos.func_177982_a(i, i, i))) {
            for (BlockPos test_blockpos : BlockPos.func_177980_a((BlockPos)blockpos.func_177982_a(-radius, -radius, -radius), (BlockPos)blockpos.func_177982_a(radius, radius, radius))) {
                IBlockState test_blockstate = world.func_180495_p(test_blockpos);
                if (!test_blockstate.func_177230_c().isLeaves(test_blockstate, (IBlockAccess)world, test_blockpos)) continue;
                ++leaf_block_count;
            }
        }
        return leaf_block_count > 6;
    }

    public static final boolean isLikelySapling(World world, IBlockState blockstate) {
        Block block = blockstate.func_177230_c();
        if (block instanceof BlockSapling) {
            return true;
        }
        boolean likely = block.getClass().getSimpleName().endsWith("Sapling");
        if (likely && block instanceof IGrowable) {
            if (!(block instanceof BlockBush)) {
                boolean found = false;
                for (IProperty p : blockstate.func_177227_a()) {
                    if (!(p instanceof PropertyInteger) || !"stage".equals(p.func_177701_a()) && !"age".equals(p.func_177701_a())) continue;
                    found = true;
                    break;
                }
                likely = found;
            }
        } else {
            likely = false;
        }
        return likely;
    }

    public static boolean isLikelySpawner(IBlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return block == Blocks.field_150474_ac || block == Blocks.field_150418_aU || block instanceof BlockSilverfish;
    }

    private Whatis() {
    }

    public static final void init() {
    }
}

