/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Loader;

public final class BaublesHelper {
    private static final String _MOD_ID = "baubles";

    public static final ItemStack findBauble(@Nonnull Predicate<ItemStack> test, @Nonnull EntityPlayer player) {
        if (Loader.isModLoaded((String)_MOD_ID)) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack bauble = baubles.getStackInSlot(i);
                if (!test.apply((Object)bauble)) continue;
                return bauble;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static final void iterateBaubles(@Nonnull Function<OwnedBauble, Void> function, @Nonnull EntityPlayer player) {
        if (Loader.isModLoaded((String)_MOD_ID)) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack bauble = baubles.getStackInSlot(i);
                function.apply((Object)new OwnedBauble(player, bauble));
            }
        }
    }

    public static final <T> T iterateBaubles(@Nonnull Function<OwnedBauble, T> function, @Nonnull EntityPlayer player, T r) {
        if (Loader.isModLoaded((String)_MOD_ID)) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack bauble = baubles.getStackInSlot(i);
                r = function.apply((Object)new OwnedBauble(player, bauble, r));
            }
        }
        return r;
    }

    public static final class GenericLuckyCharmImpl
    implements ICapabilityProvider {
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? bauble -> BaubleType.CHARM : null);
        }
    }

    public static final class GenericAmuletImpl
    implements ICapabilityProvider {
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? bauble -> BaubleType.AMULET : null);
        }
    }

    public static final class GenericTrinketImpl
    implements ICapabilityProvider {
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? bauble -> BaubleType.TRINKET : null);
        }
    }

    public static final class OwnedBauble {
        @Nonnull
        public final EntityPlayer owner;
        @Nonnull
        public final ItemStack bauble;
        public Object ticket;

        OwnedBauble(EntityPlayer player, ItemStack stack) {
            this.owner = player;
            this.bauble = stack;
        }

        OwnedBauble(EntityPlayer player, ItemStack stack, Object r) {
            this(player, stack);
            this.ticket = r;
        }
    }
}

