/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.text.DecimalFormat;
import java.util.Arrays;
import meldexun.entityculling.asm.hook.RenderGlobalHook;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.util.CullingThread;
import meldexun.entityculling.util.IBoundingBoxCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityCulling
extends DummyModContainer {
    public static final String MOD_ID = "entity_culling";
    private static CullingThread cullingThread;
    private static final DecimalFormat FORMAT;
    public static boolean isCubicChunksInstalled;
    public static boolean isFairyLightsInstalled;

    public EntityCulling() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.name = "Entity Culling";
        meta.version = "4.2.5";
        meta.modId = MOD_ID;
        meta.authorList = Arrays.asList("Meldexun");
        meta.url = "https://github.com/Meldexun/EntityCulling";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void onFMLConstructionEvent(FMLConstructionEvent event) {
        ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        CullingThread.updateBlacklists();
        IBoundingBoxCache.updateBlacklist();
        MinecraftForge.EVENT_BUS.register((Object)this);
        cullingThread = new CullingThread();
        cullingThread.start();
    }

    @Subscribe
    public void onFMLPostInitializationEvent(FMLPostInitializationEvent event) {
        isCubicChunksInstalled = Loader.isModLoaded((String)"cubicchunks");
        isFairyLightsInstalled = Loader.isModLoaded((String)"fairylights");
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            CullingThread.updateBlacklists();
            IBoundingBoxCache.updateBlacklist();
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!EntityCullingConfig.debugCullInfo) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        this.drawOnLeft("Time: " + FORMAT.format(Arrays.stream(EntityCulling.cullingThread.time).average().getAsDouble() / 1000000.0) + "ms", scaled.func_78326_a(), 160);
        this.drawOnLeft("E: " + RenderGlobalHook.entityRenderer.renderedEntities + "/" + RenderGlobalHook.entityRenderer.occludedEntities + "/" + RenderGlobalHook.entityRenderer.totalEntities, scaled.func_78326_a(), 170);
        this.drawOnLeft("TE: " + RenderGlobalHook.tileEntityRenderer.renderedTileEntities + "/" + RenderGlobalHook.tileEntityRenderer.occludedTileEntities + "/" + RenderGlobalHook.tileEntityRenderer.totalTileEntities, scaled.func_78326_a(), 180);
    }

    private void drawOnLeft(String string, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(string, x - mc.field_71466_p.func_78256_a(string), y, -1);
    }

    static {
        FORMAT = new DecimalFormat("#.#");
    }
}

