/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.asm.hook;

import meldexun.entityculling.asm.EntityCullingClassTransformer;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.renderer.entity.EntityRenderer;
import meldexun.entityculling.renderer.entity.EntityRendererOptifine;
import meldexun.entityculling.renderer.tileentity.TileEntityRenderer;
import meldexun.entityculling.renderer.tileentity.TileEntityRendererOptifine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;

public final class RenderGlobalHook {
    public static EntityRenderer entityRenderer = EntityCullingClassTransformer.OPTIFINE_DETECTED ? new EntityRendererOptifine() : new EntityRenderer();
    public static TileEntityRenderer tileEntityRenderer = EntityCullingClassTransformer.OPTIFINE_DETECTED ? new TileEntityRendererOptifine() : new TileEntityRenderer();

    public static void setup(ICamera frustum) {
        if (!EntityCullingConfig.enabled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        double partialTicks = mc.func_184121_ak();
        double x = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTicks;
        double y = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTicks;
        double z = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTicks;
        entityRenderer.setup(frustum, x, y, z);
        tileEntityRenderer.setup(frustum, x, y, z);
    }

    public static boolean renderEntities(float partialTicks) {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        entityRenderer.renderEntities(partialTicks);
        return true;
    }

    public static boolean renderTileEntities(float partialTicks) {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        tileEntityRenderer.renderTileEntities(partialTicks);
        return true;
    }

    public static boolean shouldRenderChunkShadow(RenderGlobal.ContainerLocalRenderInformation containerLocalRenderInformation) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.terrainShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.optifineShaderOptions.terrainShadowsDistanceLimited) {
            return true;
        }
        RenderChunk renderChunk = containerLocalRenderInformation.field_178036_a;
        BlockPos pos = renderChunk.func_178568_j();
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        float partialTicks = mc.func_184121_ak();
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        if (Math.abs((double)pos.func_177958_n() + 8.0 - x) > EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxHorizontalDistance * 16.0) {
            return false;
        }
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks + (double)entity.func_70047_e();
        if (Math.abs((double)pos.func_177956_o() + 8.0 - y) > EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxVerticalDistance * 16.0) {
            return false;
        }
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return Math.abs((double)pos.func_177952_p() + 8.0 - z) <= EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxHorizontalDistance * 16.0;
    }
}

