/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.config;

import net.minecraftforge.common.config.Config;

@Config(modid="entity_culling")
public class EntityCullingConfig {
    @Config.RequiresMcRestart
    @Config.Comment(value={"Ideally should be set to equal the render distance. Ram usage (in Bytes) = 1063 * (2x + 1) ^ 3"})
    public static int cacheSize = 12;
    @Config.Comment(value={"Enabling this should give more FPS because (tile-) entities are culled more accuratly. Also this does only not need the cache but the cache still requires memory. This might cause (tile-) entity flickering and lags due to the higher CPU usage."})
    public static boolean cachelessMode = false;
    public static boolean debugCullInfo = false;
    public static boolean debugRenderBoxes = false;
    public static boolean disabledInSpectator = true;
    @Config.RequiresWorldRestart
    @Config.Comment(value={"Disable all changes from this mod."})
    public static boolean enabled = true;
    @Config.Comment(value={"If you feel the need to increase this value because of entities being culled falsely then another modder probably messed up his render bounding boxes and he should fix them instead."})
    @Config.RangeDouble(min=9.765625E-4, max=1024.0)
    public static double raytraceThreshold = 1.0;
    @Config.Comment(value={"Most tile entities have static bounding boxes and thus they can be cached. Tile entities whose bounding boxes are likely to change every frame or so should be added to the blacklist. Tile entities whose bounding only change every once in a while should be covered by cache updates (update speed adjustable through tileEntityCachedBoundingBoxUpdateInterval)"})
    public static boolean tileEntityCachedBoundingBoxEnabled = true;
    @Config.Comment(value={"Every frame there is a 1 in x chance to update the cached bounding box. Higher = better performance, Lower = tile entities with dynamic bounding boxes get updated faster."})
    @Config.RangeInt(min=2, max=1000000)
    public static int tileEntityCachedBoundingBoxUpdateInterval = 100;
    @Config.RequiresWorldRestart
    @Config.Comment(value={"Tile entities whose bounding boxes won't be cached (Accepts modid or modid:tileentity)."})
    public static String[] tileEntityCachedBoundingBoxBlacklist = new String[0];
    public static Entity entity = new Entity();
    public static TileEntity tileEntity = new TileEntity();
    public static OptifineShaderOptions optifineShaderOptions = new OptifineShaderOptions();

    private EntityCullingConfig() {
    }

    public static class OptifineShaderOptions {
        public boolean entityShadowsCulling = true;
        public boolean entityShadowsCullingLessAggressiveMode = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double entityShadowsCullingLessAggressiveModeDiff = 4.0;
        public boolean entityShadowsEnabled = true;
        public boolean entityShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double entityShadowsMaxDistance = 4.0;
        public boolean terrainShadowsEnabled = true;
        public boolean terrainShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double terrainShadowsMaxHorizontalDistance = 8.0;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double terrainShadowsMaxVerticalDistance = 4.0;
        public boolean tileEntityShadowsCulling = true;
        public boolean tileEntityShadowsCullingLessAggressiveMode = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double tileEntityShadowsCullingLessAggressiveModeDiff = 4.0;
        public boolean tileEntityShadowsEnabled = true;
        public boolean tileEntityShadowsDistanceLimited = true;
        @Config.RangeDouble(min=0.0, max=64.0)
        public double tileEntityShadowsMaxDistance = 4.0;
    }

    public static class TileEntity {
        @Config.Comment(value={"Skip rendering of entities that are not visible (hidden behind blocks). This might cause issues where a tile entity is partly behind a block and thus does not get rendered but it's usually not really noticable."})
        public boolean skipHiddenTileEntityRendering = true;
        @Config.Comment(value={"Tile entities with a width or height greater than this value will always get rendered."})
        @Config.RangeDouble(min=0.0, max=256.0)
        public double skipHiddenTileEntityRenderingSize = 16.0;
        @Config.Comment(value={"Tile entities which will always be rendered. (Format: 'modid:tile_entity_name')"})
        public String[] skipHiddenTileEntityRenderingBlacklist = new String[0];
    }

    public static class Entity {
        public boolean alwaysRenderBosses = true;
        public boolean alwaysRenderEntitiesWithName = true;
        public boolean alwaysRenderPlayers = true;
        public boolean alwaysRenderViewEntity = true;
        @Config.Comment(value={"Skip rendering of entities that are not visible (hidden behind blocks). Bosses will be rendered normally. This might cause issues where an entity is partly behind a block and thus does not get rendered but it's usually not really noticable."})
        public boolean skipHiddenEntityRendering = true;
        @Config.Comment(value={"Entities with a width or height greater than this value will always get rendered."})
        @Config.RangeDouble(min=0.0, max=256.0)
        public double skipHiddenEntityRenderingSize = 16.0;
        @Config.Comment(value={"Tile entities which will always be rendered. (Format: 'modid:entity_name')"})
        public String[] skipHiddenEntityRenderingBlacklist = new String[0];
    }
}

