/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.renderer.entity;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.integration.FairyLights;
import meldexun.entityculling.util.BoundingBoxHelper;
import meldexun.entityculling.util.ICullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.MinecraftForgeClient;

public class EntityRenderer {
    protected final Queue<Entity> entityListStaticPass0 = new ArrayDeque<Entity>();
    protected final Queue<Entity> entityListMultipassPass0 = new ArrayDeque<Entity>();
    protected final Queue<Entity> entityListOutlinePass0 = new ArrayDeque<Entity>();
    protected final Queue<Entity> entityListStaticPass1 = new ArrayDeque<Entity>();
    protected final Queue<Entity> entityListMultipassPass1 = new ArrayDeque<Entity>();
    public int renderedEntities;
    public int occludedEntities;
    public int totalEntities;

    public void setup(ICamera camera, double camX, double camY, double camZ) {
        this.renderedEntities = 0;
        this.occludedEntities = 0;
        this.totalEntities = 0;
        this.clearEntityLists();
        this.fillEntityLists(camera, camX, camY, camZ);
    }

    protected void clearEntityLists() {
        this.entityListStaticPass0.clear();
        this.entityListMultipassPass0.clear();
        this.entityListOutlinePass0.clear();
        this.entityListStaticPass1.clear();
        this.entityListMultipassPass1.clear();
    }

    protected void fillEntityLists(ICamera camera, double camX, double camY, double camZ) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.field_72996_f.forEach(entity -> this.addToRenderLists(entity, camera, camX, camY, camZ));
    }

    protected <T extends Entity> boolean addToRenderLists(T entity, ICamera camera, double camX, double camY, double camZ) {
        if (EntityCullingConfig.debugRenderBoxes) {
            this.drawBox(entity, camX, camY, camZ);
        }
        ++this.totalEntities;
        if (!entity.shouldRenderInPass(0) && !entity.shouldRenderInPass(1)) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        Render renderer = renderManager.func_78713_a(entity);
        if (renderer == null) {
            return false;
        }
        if (!(renderer.func_177071_a(entity, camera, camX, camY, camZ) || entity.func_184215_y((Entity)mc.field_71439_g) || EntityCulling.isFairyLightsInstalled && FairyLights.isFairyLightEntity(entity))) {
            return false;
        }
        if (!this.shouldRenderEntity(entity, camX, camY, camZ)) {
            return false;
        }
        boolean rendered = false;
        if (entity.shouldRenderInPass(0)) {
            if (!this.isOcclusionCulled(entity)) {
                this.entityListStaticPass0.add(entity);
                if (renderer.func_188295_H_()) {
                    this.entityListMultipassPass0.add(entity);
                }
                rendered = true;
            }
            if (this.shouldRenderOutlines(entity)) {
                this.entityListOutlinePass0.add(entity);
            }
        }
        if (entity.shouldRenderInPass(1) && !this.isOcclusionCulled(entity)) {
            this.entityListStaticPass1.add(entity);
            if (renderer.func_188295_H_()) {
                this.entityListMultipassPass1.add(entity);
            }
            rendered = true;
        }
        if (rendered) {
            ++this.renderedEntities;
        } else {
            ++this.occludedEntities;
        }
        Entity[] parts = entity.func_70021_al();
        if (parts != null) {
            Arrays.stream(entity.func_70021_al()).filter(part -> renderManager.func_78713_a(part).getClass() != RenderEntity.class).forEach(part -> this.addToRenderLists(part, camera, camX, camY, camZ));
        }
        return true;
    }

    protected void drawBox(Entity entity, double camX, double camY, double camZ) {
        if (entity == Minecraft.func_71410_x().func_175606_aa()) {
            return;
        }
        AxisAlignedBB aabb = entity.func_184177_bl().func_186662_g(0.5);
        if (aabb.func_181656_b()) {
            aabb = new AxisAlignedBB(entity.field_70165_t - 2.0, entity.field_70163_u - 2.0, entity.field_70161_v - 2.0, entity.field_70165_t + 2.0, entity.field_70163_u + 2.0, entity.field_70161_v + 2.0);
        }
        BoundingBoxHelper.drawBox(aabb, camX, camY, camZ);
    }

    protected boolean isOcclusionCulled(Entity entity) {
        return ((ICullable)entity).isCulled();
    }

    protected boolean shouldRenderEntity(Entity entity, double camX, double camY, double camZ) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O != 0) {
            return true;
        }
        Entity viewEntity = mc.func_175606_aa();
        if (entity != viewEntity) {
            return true;
        }
        if (!(viewEntity instanceof EntityLivingBase)) {
            return true;
        }
        return ((EntityLivingBase)viewEntity).func_70608_bn();
    }

    protected boolean shouldRenderOutlines(Entity entity) {
        if (entity.func_184202_aL()) {
            return true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71439_g.func_175149_v()) {
            return false;
        }
        if (!mc.field_71474_y.field_178883_an.func_151470_d()) {
            return false;
        }
        return entity instanceof EntityPlayer;
    }

    public void renderEntities(float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager renderManager = mc.func_175598_ae();
        if (pass == 0) {
            this.entityListStaticPass0.forEach(entity -> {
                this.preRenderEntity((Entity)entity);
                renderManager.func_188388_a(entity, partialTicks, false);
                this.postRenderEntity();
            });
            this.entityListMultipassPass0.forEach(entity -> {
                this.preRenderEntity((Entity)entity);
                renderManager.func_188389_a(entity, partialTicks);
                this.postRenderEntity();
            });
            if (this.isRenderEntityOutlines() && (!this.entityListOutlinePass0.isEmpty() || mc.field_71438_f.field_184386_ad)) {
                mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                mc.field_71438_f.field_175015_z.func_147614_f();
                boolean bl = mc.field_71438_f.field_184386_ad = !this.entityListOutlinePass0.isEmpty();
                if (!this.entityListOutlinePass0.isEmpty()) {
                    GlStateManager.func_179143_c((int)519);
                    GlStateManager.func_179106_n();
                    mc.field_71438_f.field_175015_z.func_147610_a(false);
                    RenderHelper.func_74518_a();
                    renderManager.func_178632_c(true);
                    this.entityListOutlinePass0.forEach(entity -> {
                        this.preRenderEntity((Entity)entity);
                        renderManager.func_188388_a(entity, partialTicks, false);
                        this.postRenderEntity();
                    });
                    renderManager.func_178632_c(false);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179132_a((boolean)false);
                    mc.field_71438_f.field_174991_A.func_148018_a(partialTicks);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179127_m();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179142_g();
                    GlStateManager.func_179143_c((int)515);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179141_d();
                }
                mc.func_147110_a().func_147610_a(false);
            }
        } else if (pass == 1) {
            this.entityListStaticPass1.forEach(entity -> {
                this.preRenderEntity((Entity)entity);
                renderManager.func_188388_a(entity, partialTicks, false);
                this.postRenderEntity();
            });
            this.entityListMultipassPass1.forEach(entity -> {
                this.preRenderEntity((Entity)entity);
                renderManager.func_188389_a(entity, partialTicks);
                this.postRenderEntity();
            });
        }
    }

    protected void preRenderEntity(Entity entity) {
    }

    protected void postRenderEntity() {
    }

    protected boolean isRenderEntityOutlines() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71438_f.field_175015_z != null && mc.field_71438_f.field_174991_A != null;
    }
}

