/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.renderer.tileentity;

import java.util.ArrayDeque;
import java.util.Queue;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.util.BoundingBoxHelper;
import meldexun.entityculling.util.IBoundingBoxCache;
import meldexun.entityculling.util.ICullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;

public class TileEntityRenderer {
    protected final Queue<TileEntity> tileEntityListPass0 = new ArrayDeque<TileEntity>();
    protected final Queue<TileEntity> tileEntityListPass1 = new ArrayDeque<TileEntity>();
    public int renderedTileEntities;
    public int occludedTileEntities;
    public int totalTileEntities;

    public void setup(ICamera camera, double camX, double camY, double camZ) {
        this.renderedTileEntities = 0;
        this.occludedTileEntities = 0;
        this.totalTileEntities = 0;
        this.clearTileEntityLists();
        this.fillTileEntityLists(camera, camX, camY, camZ);
    }

    protected void clearTileEntityLists() {
        this.tileEntityListPass0.clear();
        this.tileEntityListPass1.clear();
    }

    protected void fillTileEntityLists(ICamera camera, double camX, double camY, double camZ) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.field_147482_g.forEach(tileEntity -> this.addToRenderLists((TileEntity)tileEntity, camera, camX, camY, camZ));
    }

    protected void addToRenderLists(TileEntity tileEntity, ICamera camera, double camX, double camY, double camZ) {
        if (EntityCullingConfig.debugRenderBoxes) {
            this.drawBox(tileEntity, camX, camY, camZ);
        }
        ++this.totalTileEntities;
        if (!tileEntity.shouldRenderInPass(0) && !tileEntity.shouldRenderInPass(1)) {
            return;
        }
        if (!camera.func_78546_a(((IBoundingBoxCache)tileEntity).getOrCacheBoundingBox())) {
            return;
        }
        if (tileEntity.func_145835_a(camX, camY, camZ) >= tileEntity.func_145833_n()) {
            return;
        }
        if (this.isOcclusionCulled(tileEntity)) {
            ++this.occludedTileEntities;
            return;
        }
        ++this.renderedTileEntities;
        if (tileEntity.shouldRenderInPass(0)) {
            this.tileEntityListPass0.add(tileEntity);
        }
        if (tileEntity.shouldRenderInPass(1)) {
            this.tileEntityListPass1.add(tileEntity);
        }
    }

    protected void drawBox(TileEntity tileEntity, double camX, double camY, double camZ) {
        AxisAlignedBB aabb = ((IBoundingBoxCache)tileEntity).getOrCacheBoundingBox();
        if (aabb.func_181656_b()) {
            BlockPos pos = tileEntity.func_174877_v();
            aabb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
        }
        BoundingBoxHelper.drawBox(aabb, camX, camY, camZ);
    }

    protected boolean isOcclusionCulled(TileEntity tileEntity) {
        return ((ICullable)tileEntity).isCulled();
    }

    public void renderTileEntities(float partialTicks) {
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == 0) {
            this.tileEntityListPass0.forEach(tileEntity -> {
                this.preRenderTileEntity((TileEntity)tileEntity);
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                this.postRenderTileEntity();
            });
        } else if (pass == 1) {
            this.tileEntityListPass1.forEach(tileEntity -> {
                this.preRenderTileEntity((TileEntity)tileEntity);
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
                this.postRenderTileEntity();
            });
            this.drawPoints();
        }
    }

    protected void preRenderTileEntity(TileEntity tileEntity) {
    }

    protected void postRenderTileEntity() {
    }

    protected void drawPoints() {
        BoundingBoxHelper.drawPoints();
    }
}

