/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import meldexun.entityculling.asm.EntityCullingClassTransformer;
import meldexun.entityculling.config.EntityCullingConfig;
import meldexun.entityculling.util.CachedBlockAccess;
import meldexun.entityculling.util.IBoundingBoxCache;
import meldexun.entityculling.util.ICullable;
import meldexun.entityculling.util.IntUtil;
import meldexun.entityculling.util.MathUtil;
import meldexun.entityculling.util.RaytraceInfo;
import meldexun.raytraceutil.RayTracingCache;
import meldexun.raytraceutil.RayTracingEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CullingThread
extends Thread {
    private static final Set<Class<? extends Entity>> ENTITY_BLACKLIST = new HashSet<Class<? extends Entity>>();
    private static final Set<Class<? extends TileEntity>> TILE_ENTITY_BLACKLIST = new HashSet<Class<? extends TileEntity>>();
    private final CachedBlockAccess cachedBlockAccess = new CachedBlockAccess();
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final RayTracingEngine engine = new RayTracingEngine((x, y, z) -> {
        this.mutablePos.func_181079_c(x, y, z);
        return this.cachedBlockAccess.func_180495_p((BlockPos)this.mutablePos).func_185914_p();
    });
    private final RayTracingCache cache = new RayTracingCache(EntityCullingConfig.cacheSize);
    private final RayTracingEngine.MutableRayTraceResult mutableRayTraceResult = new RayTracingEngine.MutableRayTraceResult();
    private double sleepOverhead = 0.0;
    private int counter = 0;
    public long[] time = new long[100];
    private boolean result = false;
    private static List<RaytraceInfo> privateDebugRayList = new ArrayList<RaytraceInfo>();
    public static List<RaytraceInfo> publicDebugRayList = new ArrayList<RaytraceInfo>();
    private boolean spectator;
    private Frustum frustum;
    private double camX;
    private double camY;
    private double camZ;
    private int camBlockX;
    private int camBlockY;
    private int camBlockZ;
    private double x;
    private double y;
    private double z;

    public CullingThread() {
        this.setName("Culling Thread");
        this.setDaemon(true);
    }

    public static void updateBlacklists() {
        ENTITY_BLACKLIST.clear();
        TILE_ENTITY_BLACKLIST.clear();
        for (String s : EntityCullingConfig.entity.skipHiddenEntityRenderingBlacklist) {
            Class entityClass = EntityList.func_192839_a((String)s);
            if (entityClass == null) continue;
            ENTITY_BLACKLIST.add(entityClass);
        }
        for (String s : EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingBlacklist) {
            Class tileEntityClass = (Class)TileEntity.field_190562_f.func_82594_a((Object)new ResourceLocation(s));
            if (tileEntityClass == null) continue;
            TILE_ENTITY_BLACKLIST.add(tileEntityClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Minecraft mc = Minecraft.func_71410_x();
        while (true) {
            long t = System.nanoTime();
            try {
                privateDebugRayList.clear();
                WorldClient world = mc.field_71441_e;
                EntityPlayerSP player = mc.field_71439_g;
                Entity renderViewEntity = mc.func_175606_aa();
                if (world != null && player != null && renderViewEntity != null) {
                    this.cachedBlockAccess.setupCached((World)world);
                    this.spectator = player.func_175149_v();
                    float partialTicks = mc.func_184121_ak();
                    this.x = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
                    this.y = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
                    this.z = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
                    this.frustum = new Frustum((ClippingHelper)ClippingHelperImpl.field_78563_e);
                    this.frustum.func_78547_a(this.x, this.y, this.z);
                    Vec3d cameraPosition = ActiveRenderInfo.getCameraPosition();
                    this.camX = this.x + cameraPosition.field_72450_a;
                    this.camY = this.y + cameraPosition.field_72448_b;
                    this.camZ = this.z + cameraPosition.field_72449_c;
                    this.camBlockX = MathHelper.func_76128_c((double)this.camX);
                    this.camBlockY = MathHelper.func_76128_c((double)this.camY);
                    this.camBlockZ = MathHelper.func_76128_c((double)this.camZ);
                    Iterator entityIterator = world.field_72996_f.iterator();
                    while (entityIterator.hasNext()) {
                        Entity entity;
                        try {
                            entity = (Entity)entityIterator.next();
                        }
                        catch (ConcurrentModificationException | NoSuchElementException e) {
                            break;
                        }
                        if (entity == null) continue;
                        this.updateEntityCullingState(entity);
                    }
                    Iterator tileEntityIterator = world.field_147482_g.iterator();
                    while (tileEntityIterator.hasNext()) {
                        TileEntity tileEntity;
                        try {
                            tileEntity = (TileEntity)tileEntityIterator.next();
                        }
                        catch (ConcurrentModificationException | NoSuchElementException e) {
                            break;
                        }
                        if (tileEntity == null) continue;
                        this.updateTileEntityCullingState(tileEntity);
                    }
                }
                Class<CullingThread> clazz = CullingThread.class;
                // MONITORENTER : meldexun.entityculling.util.CullingThread.class
                List<RaytraceInfo> temp = publicDebugRayList;
                publicDebugRayList = privateDebugRayList;
                privateDebugRayList = temp;
                // MONITOREXIT : clazz
            }
            catch (Throwable e) {
                mc.func_71404_a(new CrashReport("Culling Thread crashed!", e));
            }
            finally {
                this.cachedBlockAccess.clearCache();
                this.cache.clearCache();
            }
            this.time[this.counter] = t = System.nanoTime() - t;
            this.counter = (this.counter + 1) % this.time.length;
            double d = (double)t / 1000000.0 + this.sleepOverhead;
            this.sleepOverhead = d % 1.0;
            long sleepTime = 10L - (long)d;
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private void updateEntityCullingState(Entity entity) {
        ((ICullable)entity).setCulled(!this.checkEntityVisibility(entity));
        if (EntityCullingClassTransformer.OPTIFINE_DETECTED) {
            ((ICullable)entity).setShadowCulled(!this.checkEntityShadowVisibility(entity));
        }
    }

    private void updateTileEntityCullingState(TileEntity tileEntity) {
        ((ICullable)tileEntity).setCulled(!this.checkTileEntityVisibility(tileEntity));
        if (EntityCullingClassTransformer.OPTIFINE_DETECTED) {
            ((ICullable)tileEntity).setShadowCulled(!this.checkTileEntityShadowVisibility(tileEntity));
        }
    }

    private boolean checkEntityVisibility(Entity entity) {
        AxisAlignedBB aabb;
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (EntityCullingConfig.disabledInSpectator && this.spectator) {
            return true;
        }
        if (!EntityCullingConfig.entity.skipHiddenEntityRendering) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderBosses && !entity.func_184222_aU()) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderEntitiesWithName && entity.func_94059_bO()) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderPlayers && entity instanceof EntityPlayer) {
            return true;
        }
        if (EntityCullingConfig.entity.alwaysRenderViewEntity && entity == Minecraft.func_71410_x().func_175606_aa()) {
            return true;
        }
        if (!ENTITY_BLACKLIST.isEmpty() && ENTITY_BLACKLIST.contains(entity.getClass())) {
            return true;
        }
        try {
            aabb = entity.func_184177_bl();
        }
        catch (Exception e) {
            return !((ICullable)entity).isCulled();
        }
        double minX = aabb.field_72340_a - 0.5;
        double minY = aabb.field_72338_b - 0.5;
        double minZ = aabb.field_72339_c - 0.5;
        double maxX = aabb.field_72336_d + 0.5;
        double maxY = aabb.field_72337_e + 0.5;
        double maxZ = aabb.field_72334_f + 0.5;
        if (maxX - minX > EntityCullingConfig.entity.skipHiddenEntityRenderingSize || maxY - minY > EntityCullingConfig.entity.skipHiddenEntityRenderingSize || maxZ - minZ > EntityCullingConfig.entity.skipHiddenEntityRenderingSize) {
            return true;
        }
        if (!entity.func_145770_h(this.x, this.y, this.z)) {
            return true;
        }
        if (!this.frustum.func_78548_b(minX, minY, minZ, maxX, maxY, maxZ)) {
            return true;
        }
        if (EntityCullingConfig.debugRenderBoxes) {
            privateDebugRayList.add(new RaytraceInfo((minX + maxX) * 0.5, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5, true));
        }
        this.result = this.checkPointUncached(this.camX, this.camY, this.camZ, (minX + maxX) * 0.5, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5, EntityCullingConfig.raytraceThreshold);
        this.result |= this.checkBoxCached(minX, minY, minZ, maxX, maxY, maxZ);
        return this.result;
    }

    private boolean checkTileEntityVisibility(TileEntity tileEntity) {
        AxisAlignedBB aabb;
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (EntityCullingConfig.disabledInSpectator && this.spectator) {
            return true;
        }
        if (!EntityCullingConfig.tileEntity.skipHiddenTileEntityRendering) {
            return true;
        }
        if (!TILE_ENTITY_BLACKLIST.isEmpty() && TILE_ENTITY_BLACKLIST.contains(tileEntity.getClass())) {
            return true;
        }
        try {
            aabb = ((IBoundingBoxCache)tileEntity).getOrCacheBoundingBox();
        }
        catch (Exception e) {
            return !((ICullable)tileEntity).isCulled();
        }
        if (aabb.field_72336_d - aabb.field_72340_a > EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingSize || aabb.field_72337_e - aabb.field_72338_b > EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingSize || aabb.field_72334_f - aabb.field_72339_c > EntityCullingConfig.tileEntity.skipHiddenTileEntityRenderingSize) {
            return true;
        }
        if (tileEntity.func_145835_a(this.x, this.y, this.z) >= tileEntity.func_145833_n()) {
            return true;
        }
        if (!this.frustum.func_78548_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f)) {
            return true;
        }
        if (EntityCullingConfig.debugRenderBoxes) {
            privateDebugRayList.add(new RaytraceInfo((aabb.field_72340_a + aabb.field_72336_d) * 0.5, (aabb.field_72338_b + aabb.field_72337_e) * 0.5, (aabb.field_72339_c + aabb.field_72334_f) * 0.5, true));
        }
        this.result = this.checkPointUncached(this.camX, this.camY, this.camZ, (aabb.field_72340_a + aabb.field_72336_d) * 0.5, (aabb.field_72338_b + aabb.field_72337_e) * 0.5, (aabb.field_72339_c + aabb.field_72334_f) * 0.5, EntityCullingConfig.raytraceThreshold);
        this.result |= this.checkBoxCached(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        return this.result;
    }

    private boolean checkEntityShadowVisibility(Entity entity) {
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsCulling) {
            return true;
        }
        if (!((ICullable)entity).isCulled()) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.entityShadowsCullingLessAggressiveMode) {
            return false;
        }
        return this.checkPointUncached(this.camX, this.camY, this.camZ, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v, EntityCullingConfig.optifineShaderOptions.entityShadowsCullingLessAggressiveModeDiff);
    }

    private boolean checkTileEntityShadowVisibility(TileEntity tileEntity) {
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCulling) {
            return true;
        }
        if (!((ICullable)tileEntity).isCulled()) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveMode) {
            return false;
        }
        BlockPos pos = tileEntity.func_174877_v();
        return this.checkPointUncached(this.camX, this.camY, this.camZ, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, EntityCullingConfig.optifineShaderOptions.tileEntityShadowsCullingLessAggressiveModeDiff);
    }

    private boolean checkBoxCached(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (EntityCullingConfig.cachelessMode) {
            return this.checkBoxUncached(minX, minY, minZ, maxX, maxY, maxZ);
        }
        int startX = MathHelper.func_76128_c((double)minX);
        int startY = MathHelper.func_76128_c((double)minY);
        int startZ = MathHelper.func_76128_c((double)minZ);
        int endX = MathHelper.func_76143_f((double)maxX);
        int endY = MathHelper.func_76143_f((double)maxY);
        int endZ = MathHelper.func_76143_f((double)maxZ);
        if (this.camX >= (double)startX && this.camX <= (double)endX && this.camY >= (double)startY && this.camY <= (double)endY && this.camZ >= (double)startZ && this.camZ <= (double)endZ) {
            this.result = true;
        }
        if (this.camX < (double)startX) {
            IntUtil.forEach(startY, endY, startZ, endZ, (y, z) -> this.checkPointCachedAndDebug(startX, y, z));
        } else if (this.camX > (double)endX) {
            IntUtil.forEach(startY, endY, startZ, endZ, (y, z) -> this.checkPointCachedAndDebug(endX, y, z));
        }
        if (this.camY < (double)startY) {
            IntUtil.forEach(startX, endX, startZ, endZ, (x, z) -> this.checkPointCachedAndDebug(x, startY, z));
        } else if (this.camY > (double)endY) {
            IntUtil.forEach(startX, endX, startZ, endZ, (x, z) -> this.checkPointCachedAndDebug(x, endY, z));
        }
        if (this.camZ < (double)startZ) {
            IntUtil.forEach(startX, endX, startY, endY, (x, y) -> this.checkPointCachedAndDebug(x, y, startZ));
        } else if (this.camZ > (double)endZ) {
            IntUtil.forEach(startX, endX, startY, endY, (x, y) -> this.checkPointCachedAndDebug(x, y, endZ));
        }
        return this.result;
    }

    private void checkPointCachedAndDebug(int x, int y, int z) {
        if (EntityCullingConfig.debugRenderBoxes) {
            privateDebugRayList.add(new RaytraceInfo(x, y, z, !this.result));
        }
        if (!this.result && this.checkPointCached(x, y, z)) {
            this.result = true;
        }
    }

    private boolean checkBoxUncached(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.camX >= minX && this.camX <= maxX && this.camY >= minY && this.camY <= maxY && this.camZ >= minZ && this.camZ <= maxZ) {
            this.result = true;
        }
        int stepsX = MathHelper.func_76143_f((double)(maxX - minX));
        int stepsY = MathHelper.func_76143_f((double)(maxY - minY));
        int stepsZ = MathHelper.func_76143_f((double)(maxZ - minZ));
        if (this.camX < minX) {
            IntUtil.forEach(0, stepsY + 1, 0, stepsZ + 1, (iy, iz) -> {
                double y = MathUtil.lerp(minY, maxY, (double)iy / (double)stepsY);
                double z = MathUtil.lerp(minZ, maxZ, (double)iz / (double)stepsZ);
                this.checkPointUncachedAndDebug(minX, y, z);
            });
        } else if (this.camX > maxX) {
            IntUtil.forEach(0, stepsY + 1, 0, stepsZ + 1, (iy, iz) -> {
                double y = MathUtil.lerp(minY, maxY, (double)iy / (double)stepsY);
                double z = MathUtil.lerp(minZ, maxZ, (double)iz / (double)stepsZ);
                this.checkPointUncachedAndDebug(maxX, y, z);
            });
        }
        if (this.camY < minY) {
            IntUtil.forEach(0, stepsX + 1, 0, stepsZ + 1, (ix, iz) -> {
                double x = MathUtil.lerp(minX, maxX, (double)ix / (double)stepsX);
                double z = MathUtil.lerp(minZ, maxZ, (double)iz / (double)stepsZ);
                this.checkPointUncachedAndDebug(x, minY, z);
            });
        } else if (this.camY > maxY) {
            IntUtil.forEach(0, stepsX + 1, 0, stepsZ + 1, (ix, iz) -> {
                double x = MathUtil.lerp(minX, maxX, (double)ix / (double)stepsX);
                double z = MathUtil.lerp(minZ, maxZ, (double)iz / (double)stepsZ);
                this.checkPointUncachedAndDebug(x, maxY, z);
            });
        }
        if (this.camZ < minZ) {
            IntUtil.forEach(0, stepsX + 1, 0, stepsY + 1, (ix, iy) -> {
                double x = MathUtil.lerp(minX, maxX, (double)ix / (double)stepsX);
                double y = MathUtil.lerp(minY, maxY, (double)iy / (double)stepsY);
                this.checkPointUncachedAndDebug(x, y, minZ);
            });
        } else if (this.camZ > maxZ) {
            IntUtil.forEach(0, stepsX + 1, 0, stepsY + 1, (ix, iy) -> {
                double x = MathUtil.lerp(minX, maxX, (double)ix / (double)stepsX);
                double y = MathUtil.lerp(minY, maxY, (double)iy / (double)stepsY);
                this.checkPointUncachedAndDebug(x, y, maxZ);
            });
        }
        return this.result;
    }

    private void checkPointUncachedAndDebug(double x, double y, double z) {
        if (EntityCullingConfig.debugRenderBoxes) {
            privateDebugRayList.add(new RaytraceInfo(x, y, z, !this.result));
        }
        if (!this.result && this.checkPointUncached(this.camX, this.camY, this.camZ, x, y, z, EntityCullingConfig.raytraceThreshold)) {
            this.result = true;
        }
    }

    private boolean checkPointCached(int endX, int endY, int endZ) {
        return this.cache.getOrSetCachedValue(endX - this.camBlockX, endY - this.camBlockY, endZ - this.camBlockZ, () -> this.checkPointUncached(this.camX, this.camY, this.camZ, endX, endY, endZ, EntityCullingConfig.raytraceThreshold) ? 2 : 1) == 2;
    }

    private boolean checkPointUncached(double startX, double startY, double startZ, double endX, double endY, double endZ, double maxDiff) {
        return this.engine.rayTraceBlocks(startX, startY, startZ, endX, endY, endZ, true, maxDiff, this.mutableRayTraceResult) == null;
    }
}

