/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import meldexun.entityculling.config.EntityCullingConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public interface IBoundingBoxCache {
    public static final Random RAND = new Random(){
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private long seed = 0L;

        @Override
        public void setSeed(long seed) {
            this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }

        @Override
        protected int next(int bits) {
            this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (int)(this.seed >>> 48 - bits);
        }
    };
    public static final Set<String> BLACKLIST = new HashSet<String>();

    public static void updateBlacklist() {
        BLACKLIST.clear();
        Arrays.stream(EntityCullingConfig.tileEntityCachedBoundingBoxBlacklist).forEach(BLACKLIST::add);
    }

    public int isCacheable();

    public void setCacheable(int var1);

    public AxisAlignedBB getCachedBoundingBox();

    public void setCachedBoundingBox(AxisAlignedBB var1);

    default public AxisAlignedBB getOrCacheBoundingBox() {
        if (!EntityCullingConfig.tileEntityCachedBoundingBoxEnabled) {
            return ((TileEntity)this).getRenderBoundingBox();
        }
        if (this.isCacheable() == 0) {
            ResourceLocation registryName = (ResourceLocation)TileEntity.field_190562_f.func_177774_c(((TileEntity)this).getClass());
            if (BLACKLIST.contains(registryName.func_110624_b()) || BLACKLIST.contains(registryName.toString())) {
                this.setCacheable(2);
            } else {
                this.setCachedBoundingBox(((TileEntity)this).getRenderBoundingBox());
                this.setCacheable(1);
            }
        }
        if (this.isCacheable() == 2) {
            return ((TileEntity)this).getRenderBoundingBox();
        }
        if (RAND.nextInt(EntityCullingConfig.tileEntityCachedBoundingBoxUpdateInterval) == 0) {
            this.setCachedBoundingBox(((TileEntity)this).getRenderBoundingBox());
        }
        return this.getCachedBoundingBox();
    }
}

