/*
 * Decompiled with CFR 0.152.
 */
package meldexun.raytraceutil;

public enum Direction {
    WEST,
    EAST,
    DOWN,
    UP,
    NORTH,
    SOUTH;

    public static final Direction[] ALL;
    public static final Direction[] HORIZONTAL;
    public static final Direction[] VERTICAL;
    private Direction opposite;

    public Direction opposite() {
        return this.opposite;
    }

    public static Direction valueOf(int ordinal) {
        return ALL[ordinal];
    }

    public static Direction valueOf(double x, double y, double z) {
        double x1 = Math.abs(x);
        double y1 = Math.abs(y);
        double z1 = Math.abs(z);
        if (x1 >= y1) {
            if (x1 >= z1) {
                return x < 0.0 ? WEST : EAST;
            }
            return z < 0.0 ? NORTH : SOUTH;
        }
        if (y1 >= z1) {
            return y < 0.0 ? DOWN : UP;
        }
        return z < 0.0 ? NORTH : SOUTH;
    }

    static {
        Direction.WEST.opposite = EAST;
        Direction.EAST.opposite = WEST;
        Direction.DOWN.opposite = UP;
        Direction.UP.opposite = DOWN;
        Direction.NORTH.opposite = SOUTH;
        Direction.SOUTH.opposite = NORTH;
        ALL = Direction.values();
        HORIZONTAL = new Direction[]{WEST, EAST, NORTH, SOUTH};
        VERTICAL = new Direction[]{DOWN, UP};
    }
}

