/*
 * Decompiled with CFR 0.152.
 */
package meldexun.raytraceutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;

public class RayTracingCache {
    private final int radiusChunks;
    private final int sizeChunks;
    private final RayTracingCacheChunk[] chunks;
    private final List<RayTracingCacheChunk> dirtyChunks = new ArrayList<RayTracingCacheChunk>();

    public RayTracingCache(int radiusChunks) {
        this.radiusChunks = radiusChunks;
        this.sizeChunks = this.radiusChunks * 2 + 1;
        this.chunks = new RayTracingCacheChunk[this.sizeChunks * this.sizeChunks * this.sizeChunks];
        for (int i = 0; i < this.chunks.length; ++i) {
            this.chunks[i] = new RayTracingCacheChunk();
        }
    }

    public int getOrSetCachedValue(int x, int y, int z, IntSupplier function) {
        RayTracingCacheChunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return -1;
        }
        return chunk.getOrSetCachedValue(x & 0xF, y & 0xF, z & 0xF, function);
    }

    public int getCachedValue(int x, int y, int z) {
        RayTracingCacheChunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return -1;
        }
        return chunk.getCachedValue(x & 0xF, y & 0xF, z & 0xF);
    }

    public void setCachedValue(int x, int y, int z, int value) {
        RayTracingCacheChunk chunk = this.getChunk(x, y, z);
        if (chunk == null) {
            return;
        }
        chunk.setCachedValue(x & 0xF, y & 0xF, z & 0xF, value);
    }

    private RayTracingCacheChunk getChunk(int x, int y, int z) {
        if ((x = (x >> 4) + this.radiusChunks) < 0 || x >= this.sizeChunks) {
            return null;
        }
        if ((y = (y >> 4) + this.radiusChunks) < 0 || y >= this.sizeChunks) {
            return null;
        }
        if ((z = (z >> 4) + this.radiusChunks) < 0 || z >= this.sizeChunks) {
            return null;
        }
        return this.chunks[(z * this.sizeChunks + y) * this.sizeChunks + x];
    }

    public void clearCache() {
        Iterator<RayTracingCacheChunk> iter = this.dirtyChunks.iterator();
        while (iter.hasNext()) {
            iter.next().clearChunk();
            iter.remove();
        }
    }

    private class RayTracingCacheChunk {
        private int[] cache = new int[256];
        private boolean dirty = false;

        private RayTracingCacheChunk() {
        }

        public int getOrSetCachedValue(int x, int y, int z, IntSupplier function) {
            int index = z << 4 | y;
            int cachedSection = this.cache[index];
            int offset = x << 1;
            int cachedValue = cachedSection >>> offset & 3;
            if (cachedValue != 0) {
                return cachedValue;
            }
            cachedValue = function.getAsInt();
            this.cache[index] = cachedSection | (cachedValue & 3) << offset;
            this.markDirty();
            return cachedValue;
        }

        public int getCachedValue(int x, int y, int z) {
            int index = z << 4 | y;
            int offset = x << 1;
            return this.cache[index] >>> offset & 3;
        }

        public void setCachedValue(int x, int y, int z, int value) {
            int index = z << 4 | y;
            int offset = x << 1;
            this.cache[index] = this.cache[index] & ~(3 << offset) | (value & 3) << offset;
            this.markDirty();
        }

        private void markDirty() {
            if (!this.dirty) {
                this.dirty = true;
                RayTracingCache.this.dirtyChunks.add(this);
            }
        }

        public void clearChunk() {
            if (this.dirty) {
                Arrays.fill(this.cache, 0);
                this.dirty = false;
            }
        }
    }
}

