/*
 * Decompiled with CFR 0.152.
 */
package meldexun.raytraceutil;

import meldexun.raytraceutil.Direction;

public class RayTracingEngine {
    private final PositionPredicate positionPrediacte;

    public RayTracingEngine(PositionPredicate positionPrediacte) {
        this.positionPrediacte = positionPrediacte;
    }

    public MutableRayTraceResult rayTraceBlocks(double startX, double startY, double startZ, double endX, double endY, double endZ, boolean ignoreStart, double threshold, MutableRayTraceResult returnValue) {
        double dirX = endX - startX;
        double dirY = endY - startY;
        double dirZ = endZ - startZ;
        if (dirX * dirX + dirY * dirY + dirZ * dirZ <= threshold * threshold) {
            return null;
        }
        int incX = RayTracingEngine.signum(dirX);
        int incY = RayTracingEngine.signum(dirY);
        int incZ = RayTracingEngine.signum(dirZ);
        double dx = incX == 0 ? Double.MAX_VALUE : (double)incX / dirX;
        double dy = incY == 0 ? Double.MAX_VALUE : (double)incY / dirY;
        double dz = incZ == 0 ? Double.MAX_VALUE : (double)incZ / dirZ;
        double percentX = dx * (incX > 0 ? 1.0 - RayTracingEngine.frac(startX) : RayTracingEngine.frac(startX));
        double percentY = dy * (incY > 0 ? 1.0 - RayTracingEngine.frac(startY) : RayTracingEngine.frac(startY));
        double percentZ = dz * (incZ > 0 ? 1.0 - RayTracingEngine.frac(startZ) : RayTracingEngine.frac(startZ));
        Direction facingX = incX > 0 ? Direction.WEST : Direction.EAST;
        Direction facingY = incY > 0 ? Direction.DOWN : Direction.UP;
        Direction facingZ = incZ > 0 ? Direction.NORTH : Direction.SOUTH;
        int x = RayTracingEngine.floor(startX);
        int y = RayTracingEngine.floor(startY);
        int z = RayTracingEngine.floor(startZ);
        if (ignoreStart) {
            if (!this.positionPrediacte.isOpaque(x, y, z)) {
                ignoreStart = false;
            }
        } else if (this.positionPrediacte.isOpaque(x, y, z)) {
            Direction facing = Direction.valueOf(dirX, dirY, dirZ).opposite();
            return returnValue.set(startX, startY, startZ, facing);
        }
        boolean hasHitAnything = false;
        while (percentX <= 1.0 || percentY <= 1.0 || percentZ <= 1.0) {
            double nextHitZ;
            double nextHitY;
            Direction facing;
            if (percentX < percentY) {
                if (percentX < percentZ) {
                    x += incX;
                    percentX += dx;
                    facing = facingX;
                } else {
                    z += incZ;
                    percentZ += dz;
                    facing = facingZ;
                }
            } else if (percentY < percentZ) {
                y += incY;
                percentY += dy;
                facing = facingY;
            } else {
                z += incZ;
                percentZ += dz;
                facing = facingZ;
            }
            if (ignoreStart) {
                if (this.positionPrediacte.isOpaque(x, y, z)) continue;
                ignoreStart = false;
                continue;
            }
            if (!this.positionPrediacte.isOpaque(x, y, z)) continue;
            double d = facing == facingX ? percentX - dx : (facing == facingY ? percentY - dy : percentZ - dz);
            d = Math.min(d, 1.0);
            double hitX = startX + dirX * d;
            double hitY = startY + dirY * d;
            double hitZ = startZ + dirZ * d;
            if (!hasHitAnything) {
                hasHitAnything = true;
                returnValue.set(hitX, hitY, hitZ, facing);
            }
            double d1 = percentX < percentY ? (percentX < percentZ ? percentX : percentZ) : (percentY < percentZ ? percentY : percentZ);
            double nextHitX = startX + dirX * (d1 = Math.min(d1, 1.0));
            if (!((threshold -= Math.sqrt(RayTracingEngine.squareDist(hitX, hitY, hitZ, nextHitX, nextHitY = startY + dirY * d1, nextHitZ = startZ + dirZ * d1))) < 0.0)) continue;
            return returnValue;
        }
        return null;
    }

    private static int signum(double x) {
        if (x == 0.0) {
            return 0;
        }
        return x > 0.0 ? 1 : -1;
    }

    private static double frac(double number) {
        return number - (double)RayTracingEngine.floor(number);
    }

    private static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    private static double squareDist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2 + (z2 -= z1) * z2;
    }

    public static class MutableRayTraceResult {
        public double x;
        public double y;
        public double z;
        public Direction direction;

        public MutableRayTraceResult() {
            this(0.0, 0.0, 0.0, Direction.NORTH);
        }

        public MutableRayTraceResult(double x, double y, double z, Direction direction) {
            this.set(x, y, z, direction);
        }

        public MutableRayTraceResult set(double x, double y, double z, Direction direction) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.direction = direction;
            return this;
        }
    }

    @FunctionalInterface
    public static interface PositionPredicate {
        public boolean isOpaque(int var1, int var2, int var3);
    }
}

