/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;

@Config(modid="iseedragons")
public class StaticConfig {
    @Config.Comment(value={"A list of entities and view distances "})
    @Config.Name(value="EntityDistanceOverrides")
    public static Map<String, Integer> distanceOverrides;
    @Config.Comment(value={"The default % chance for a block to drop items when smashed by a dragon (requires ASM.DragonLag)"})
    public static Integer defaultDropChance;
    @Config.Comment(value={"The default % chance for a block to play sound and particle effects when smashed by a dragon (requires ASM.DragonLag)"})
    public static Integer defaultEffectChance;
    @Config.Comment(value={"Prevents lightning strikes from destroying items"})
    public static boolean disableLightningItemDamage;
    @Config.Comment(value={"Prevents Tough As Nails from creating an extra attack entity event"})
    @Config.RequiresMcRestart
    public static boolean preventTANAttackEntityEvent;
    @Config.Comment(value={"A list of block drop % chances (requires ASM.DragonLag)"})
    @Config.Name(value="DropChances")
    public static Map<String, Integer> dropChances;
    @Config.Comment(value={"A list of block effect % chances (requires ASM.DragonLag)"})
    @Config.Name(value="EffectChances")
    public static Map<String, Integer> effectChances;
    @Config.Comment(value={"A list of tools/armor and there new repair item (note: only list one tool of a given 'ToolMaterial')"})
    @Config.Name(value="RepairFixes")
    public static Map<String, String> repairFixes;
    @Config.Comment(value={"A list of items that need to do extra damage to undead enemies"})
    @Config.Name(value="ExtraUndeadDamage")
    public static Map<String, Float> extraUndeadDamage;
    @Config.Comment(value={"A list of dimension IDs that Ice and Fire should NOT generate ANY structures in."})
    @Config.Name(value="iceandfire_structure_dim_blacklist")
    public static int[] generatorBlacklist;
    @Config.Comment(value={"Minimum brightness override (can be negative)"})
    public static float minBrightness;
    @Config.Comment(value={"Maximum brightness override (can be negative)"})
    public static float maxBrightness;
    @Config.Comment(value={"Entities that can NOT be stoned by the Gorgon/Gorgon Head"})
    @Config.Name(value="unstoneable_entities")
    public static String[] unstoneableEntitys;
    @Config.Comment(value={"Core modifications"})
    @Config.Name(value="ASM")
    public static ASM asm;

    static {
        defaultDropChance = 100;
        defaultEffectChance = 100;
        disableLightningItemDamage = false;
        preventTANAttackEntityEvent = true;
        minBrightness = 0.0f;
        maxBrightness = 1.0f;
        asm = new ASM();
        distanceOverrides = new LinkedHashMap<String, Integer>();
        distanceOverrides.put("iceandfire:firedragon", 256);
        distanceOverrides.put("iceandfire:icedragon", 256);
        distanceOverrides.put("iceandfire:seaserpent", 256);
        distanceOverrides.put("iceandfire:cyclops", 256);
        distanceOverrides.put("battletower:golem", 256);
        dropChances = new LinkedHashMap<String, Integer>();
        dropChances.put("iceandfire:ash", 2);
        dropChances.put("iceandfire:chared_cobblestone", 2);
        dropChances.put("iceandfire:chared_stone", 2);
        dropChances.put("iceandfire:chared_grass", 2);
        dropChances.put("iceandfire:chared_dirt", 2);
        dropChances.put("iceandfire:chared_gravel", 2);
        dropChances.put("iceandfire:chared_grass_path", 2);
        dropChances.put("minecraft:cobblestone", 3);
        dropChances.put("minecraft:dirt", 3);
        dropChances.put("minecraft:grass", 4);
        dropChances.put("minecraft:sand", 3);
        dropChances.put("minecraft:stone", 2);
        dropChances.put("iceandfire:frozen_cobblestone", 2);
        dropChances.put("iceandfire:frozen_stone", 2);
        dropChances.put("iceandfire:frozen_grass", 2);
        dropChances.put("iceandfire:frozen_dirt", 2);
        dropChances.put("iceandfire:frozen_gravel", 2);
        dropChances.put("iceandfire:frozen_grass_path", 2);
        dropChances.put("iceandfire:frozen_splinters", 2);
        effectChances = new LinkedHashMap<String, Integer>();
        effectChances.put("iceandfire:ash", 5);
        effectChances.put("iceandfire:chared_cobblestone", 5);
        effectChances.put("iceandfire:chared_stone", 5);
        effectChances.put("iceandfire:chared_dirt", 5);
        effectChances.put("iceandfire:chared_gravel", 5);
        effectChances.put("minecraft:dirt", 5);
        effectChances.put("minecraft:stone", 5);
        effectChances.put("iceandfire:frozen_cobblestone", 5);
        effectChances.put("iceandfire:frozen_stone", 5);
        effectChances.put("iceandfire:frozen_dirt", 5);
        effectChances.put("iceandfire:frozen_gravel", 5);
        effectChances.put("iceandfire:frozen_splinters", 5);
        repairFixes = new LinkedHashMap<String, String>();
        repairFixes.put("aquaculture:neptunium_pickaxe", "aquaculture:loot,1");
        repairFixes.put("aquaculture:neptunium_chestplate", "aquaculture:loot,1");
        extraUndeadDamage = new LinkedHashMap<String, Float>();
        extraUndeadDamage.put("minecraft:bedrock", Float.valueOf(100.0f));
        generatorBlacklist = new int[]{111};
        unstoneableEntitys = new String[]{"minecraft:wither", "iceandfire:gorgon"};
    }

    @Config.RequiresMcRestart
    public static final class ASM {
        @Config.Comment(value={"Patches EntityDragonBase to help with lag"})
        @Config.Name(value="DragonLag")
        public boolean dragonLag = true;
        @Config.Comment(value={"Patches ItemModAxe to allow axes to work on modded wood blocks"})
        @Config.Name(value="IceAndFireAxeFix")
        public boolean iceAndFireAxeFix = true;
        @Config.Comment(value={"Mutes harmless noisy warnings/errors in the RLCraft modpack"})
        @Config.Name(value="STFU")
        public boolean stfu = true;
        @Config.Comment(value={"Prevents Myrmex eggs from being duped when broken with multiple damage events in one tick"})
        @Config.Name(value="FixMyrmexDupeBug")
        public boolean fixMyrmexDupeBug = true;
        @Config.Comment(value={"Removes everything from the vanilla achievements system! Can be used to stop log spam when recipes are tweaked."})
        @Config.Name(value="NukeAchievements")
        public boolean nukeAchievements = false;
        @Config.Comment(value={"Fixes a bug and allows the last Ice and Fire Sea Serpent type to spawn"})
        @Config.Name(value="FixSeaSerpentSpawn")
        public boolean fixSeaSerpentSpawn = true;
        @Config.Comment(value={"Part of a complex fix to prevent players from using dismount (pressing 'shift') to escape a dragon's jaws"})
        @Config.Name(value="DragonDismountFix")
        public boolean dragonDismountFix = true;
        @Config.Comment(value={"Adds a hook to Ice and Fire's StructureGenerator so we can cancel generation in some worlds"})
        @Config.Name(value="HookStructureGenerator")
        public boolean hookStructureGenerator = true;
        @Config.Comment(value={"Adds a hook to blacklist some entities from being stoned by the Gorgon/Gorgon Head"})
        @Config.Name(value="HookGorgonHead")
        public boolean hookGorgonHead = true;
        @Config.Comment(value={"Patches the dummy from MmmMmmMmmMmm (yes, thats a mod name) to show damage and not hearts"})
        @Config.Name(value="PatchMmmMmm")
        public boolean patchMmmMmm = true;
    }
}

