/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons.asm.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.github.xcube16.iseedragons.asm.helper.InsnComparator;
import io.github.xcube16.iseedragons.asm.helper.ObfHelper;
import io.github.xcube16.iseedragons.asm.helper.ObfRemappingClassWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingMethodAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ASMHelper {
    public static InsnComparator insnComparator = new InsnComparator();
    private static final Multimap<String, String> INTERFACE_LOOKUP_CACHE = HashMultimap.create();
    private static final Printer printer = new Textifier();
    private static final TraceMethodVisitor methodprinter = new TraceMethodVisitor(printer);

    public static String toInternalClassName(String className) {
        return className.replace('.', '/');
    }

    public static boolean isDescriptor(String descriptor) {
        return descriptor.length() == 1 || descriptor.startsWith("L") && descriptor.endsWith(";");
    }

    public static String toDescriptor(String className) {
        return ASMHelper.isDescriptor(className) ? className : "L" + ASMHelper.toInternalClassName(className) + ";";
    }

    public static String toMethodDescriptor(String returnType, String ... paramTypes) {
        StringBuilder paramDescriptors = new StringBuilder();
        for (String paramType : paramTypes) {
            paramDescriptors.append(ASMHelper.toDescriptor(paramType));
        }
        return "(" + paramDescriptors + ")" + ASMHelper.toDescriptor(returnType);
    }

    public static ClassNode readClassFromBytes(byte[] bytes) {
        return ASMHelper.readClassFromBytes(bytes, 0);
    }

    public static ClassNode readClassFromBytes(byte[] bytes, int flags) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, flags);
        return classNode;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        return ASMHelper.writeClassToBytes(classNode, 1);
    }

    public static byte[] writeClassToBytes(ClassNode classNode, int flags) {
        if (ObfHelper.isObfuscated() && !ObfHelper.runsAfterDeobfRemapper()) {
            ObfRemappingClassWriter writer = new ObfRemappingClassWriter(flags);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return ASMHelper.writeClassToBytesNoDeobf(classNode, flags);
    }

    public static byte[] writeClassToBytesNoDeobf(ClassNode classNode) {
        return ASMHelper.writeClassToBytesNoDeobf(classNode, 1);
    }

    public static byte[] writeClassToBytesNoDeobf(ClassNode classNode, int flags) {
        ClassWriter writer = new ClassWriter(flags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void writeClassToFile(ClassNode classNode, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(ASMHelper.writeClassToBytes(classNode));
        fos.close();
    }

    public static InputStream getClassAsStreamFromClassLoader(String className, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(className.replace('.', '/') + ".class");
    }

    public static ClassReader getClassReaderForClassName(String className) throws IOException {
        return new ClassReader(ASMHelper.getClassAsStreamFromClassLoader(className, ASMHelper.class.getClassLoader()));
    }

    public static boolean classHasSuper(ClassReader classReader) {
        return classReader.getSuperName() != null && !classReader.getSuperName().equals("java/lang/Object");
    }

    private static Collection<String> findAllInterfaces(ClassReader classReader) {
        HashSet interfaces = Sets.newHashSet((Object[])classReader.getInterfaces());
        try {
            if (ASMHelper.classHasSuper(classReader)) {
                String className2 = ObfHelper.getInternalClassName(classReader.getSuperName());
                if (INTERFACE_LOOKUP_CACHE.containsKey((Object)className2)) {
                    interfaces.addAll(INTERFACE_LOOKUP_CACHE.get((Object)className2));
                } else {
                    interfaces.addAll(ASMHelper.findAllInterfaces(ASMHelper.getClassReaderForClassName(className2)));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        INTERFACE_LOOKUP_CACHE.putAll((Object)classReader.getClassName(), (Iterable)interfaces);
        return interfaces;
    }

    public static boolean doesClassImplement(ClassReader classReader, String targetInterfaceInternalClassName) {
        if (!INTERFACE_LOOKUP_CACHE.containsKey((Object)classReader.getClassName())) {
            ASMHelper.findAllInterfaces(classReader);
        }
        return INTERFACE_LOOKUP_CACHE.get((Object)classReader.getClassName()).contains(targetInterfaceInternalClassName);
    }

    public static boolean doesClassExtend(ClassReader classReader, String targetSuperInternalClassName) {
        if (!ASMHelper.classHasSuper(classReader)) {
            return false;
        }
        String immediateSuperName = ObfHelper.getInternalClassName(classReader.getSuperName());
        if (immediateSuperName.equals(targetSuperInternalClassName)) {
            return true;
        }
        try {
            return ASMHelper.doesClassExtend(ASMHelper.getClassReaderForClassName(immediateSuperName), targetSuperInternalClassName);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isLabelOrLineNumber(AbstractInsnNode insn) {
        return insn.getType() == 8 || insn.getType() == 15;
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int type) {
        return ASMHelper.getOrFindInstructionOfType(firstInsnToCheck, type, false);
    }

    public static AbstractInsnNode getOrFindInstructionOfType(AbstractInsnNode firstInsnToCheck, int type, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getType() == type) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstructionWithOpcode(AbstractInsnNode firstInsnToCheck, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(firstInsnToCheck, opcode, false);
    }

    public static AbstractInsnNode getOrFindInstructionWithOpcode(AbstractInsnNode firstInsnToCheck, int opcode, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getOpcode() == opcode) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindLabelOrLineNumber(AbstractInsnNode firstInsnToCheck) {
        return ASMHelper.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindLabelOrLineNumber(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (ASMHelper.isLabelOrLineNumber(instruction)) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck) {
        return ASMHelper.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (!ASMHelper.isLabelOrLineNumber(instruction)) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstruction(MethodNode method) {
        return ASMHelper.getOrFindInstruction(method.instructions.getFirst());
    }

    public static AbstractInsnNode findFirstInstructionWithOpcode(MethodNode method, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(method.instructions.getFirst(), opcode);
    }

    public static AbstractInsnNode findLastInstructionWithOpcode(MethodNode method, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(method.instructions.getLast(), opcode, true);
    }

    public static AbstractInsnNode findNextInstruction(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindInstruction(instruction.getNext());
    }

    public static AbstractInsnNode findNextInstructionWithOpcode(AbstractInsnNode instruction, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(instruction.getNext(), opcode);
    }

    public static AbstractInsnNode findNextLabelOrLineNumber(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindLabelOrLineNumber(instruction.getNext());
    }

    public static AbstractInsnNode findPreviousInstruction(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindInstruction(instruction.getPrevious(), true);
    }

    public static AbstractInsnNode findPreviousInstructionWithOpcode(AbstractInsnNode instruction, int opcode) {
        return ASMHelper.getOrFindInstructionWithOpcode(instruction.getPrevious(), opcode, true);
    }

    public static AbstractInsnNode findPreviousLabelOrLineNumber(AbstractInsnNode instruction) {
        return ASMHelper.getOrFindLabelOrLineNumber(instruction.getPrevious(), true);
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || methodDesc != null && !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String srgMethodName, String mcpMethodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(srgMethodName) && !method.name.equals(mcpMethodName) || methodDesc != null && !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static boolean isMethodAbstract(MethodNode method) {
        return (method.access & 0x400) != 0;
    }

    public static LabelNode findEndLabel(MethodNode method) {
        for (AbstractInsnNode instruction = method.instructions.getLast(); instruction != null; instruction = instruction.getPrevious()) {
            if (!(instruction instanceof LabelNode)) continue;
            return (LabelNode)instruction;
        }
        return null;
    }

    public static int removeFromInsnListUntil(InsnList insnList, AbstractInsnNode startInclusive, AbstractInsnNode endNotInclusive) {
        int numDeleted = 0;
        for (AbstractInsnNode insnToRemove = startInclusive; insnToRemove != null && insnToRemove != endNotInclusive; insnToRemove = insnToRemove.getNext()) {
            ++numDeleted;
            insnList.remove(insnToRemove.getPrevious());
        }
        return numDeleted;
    }

    public static void skipInstructions(InsnList insnList, AbstractInsnNode startInclusive, AbstractInsnNode endNotInclusive) {
        LabelNode skipLabel = new LabelNode();
        JumpInsnNode gotoInsn = new JumpInsnNode(167, skipLabel);
        insnList.insertBefore(startInclusive, (AbstractInsnNode)gotoInsn);
        insnList.insertBefore(endNotInclusive, (AbstractInsnNode)skipLabel);
    }

    public static AbstractInsnNode move(AbstractInsnNode start, int distance) {
        AbstractInsnNode movedTo = start;
        for (int i = 0; i < Math.abs(distance) && movedTo != null; ++i) {
            movedTo = distance > 0 ? movedTo.getNext() : movedTo.getPrevious();
        }
        return movedTo;
    }

    public static boolean instructionsMatch(AbstractInsnNode first, AbstractInsnNode second) {
        return insnComparator.areInsnsEqual(first, second);
    }

    public static boolean patternMatches(InsnList checkFor, AbstractInsnNode checkAgainst) {
        return ASMHelper.checkForPatternAt(checkFor, checkAgainst).getFirst() != null;
    }

    public static InsnList checkForPatternAt(InsnList checkFor, AbstractInsnNode checkAgainst) {
        InsnList foundInsnList = new InsnList();
        boolean firstNeedleFound = false;
        AbstractInsnNode lookFor = checkFor.getFirst();
        while (lookFor != null) {
            if (checkAgainst == null) {
                return new InsnList();
            }
            if (ASMHelper.isLabelOrLineNumber(lookFor)) {
                lookFor = lookFor.getNext();
                continue;
            }
            if (ASMHelper.isLabelOrLineNumber(checkAgainst)) {
                if (firstNeedleFound) {
                    foundInsnList.add(checkAgainst);
                }
                checkAgainst = checkAgainst.getNext();
                continue;
            }
            if (!ASMHelper.instructionsMatch(lookFor, checkAgainst)) {
                return new InsnList();
            }
            foundInsnList.add(checkAgainst);
            lookFor = lookFor.getNext();
            checkAgainst = checkAgainst.getNext();
            firstNeedleFound = true;
        }
        return foundInsnList;
    }

    public static InsnList findAndGetFoundInsnList(AbstractInsnNode haystackStart, InsnList needle) {
        int needleStartOpcode = needle.getFirst().getOpcode();
        AbstractInsnNode checkAgainstStart = ASMHelper.getOrFindInstructionWithOpcode(haystackStart, needleStartOpcode);
        while (checkAgainstStart != null) {
            InsnList found = ASMHelper.checkForPatternAt(needle, checkAgainstStart);
            if (found.getFirst() != null) {
                return found;
            }
            checkAgainstStart = ASMHelper.findNextInstructionWithOpcode(checkAgainstStart, needleStartOpcode);
        }
        return new InsnList();
    }

    public static AbstractInsnNode find(InsnList haystack, InsnList needle) {
        return ASMHelper.find(haystack.getFirst(), needle);
    }

    public static AbstractInsnNode find(AbstractInsnNode haystackStart, InsnList needle) {
        if (needle.getFirst() == null) {
            return null;
        }
        InsnList found = ASMHelper.findAndGetFoundInsnList(haystackStart, needle);
        return found.getFirst();
    }

    public static AbstractInsnNode find(InsnList haystack, AbstractInsnNode needle) {
        return ASMHelper.find(haystack.getFirst(), needle);
    }

    public static AbstractInsnNode find(AbstractInsnNode haystackStart, AbstractInsnNode needle) {
        InsnList insnList = new InsnList();
        insnList.add(needle);
        return ASMHelper.find(haystackStart, insnList);
    }

    public static AbstractInsnNode findAndReplace(InsnList haystack, InsnList needle, InsnList replacement) {
        return ASMHelper.findAndReplace(haystack, needle, replacement, haystack.getFirst());
    }

    public static AbstractInsnNode findAndReplace(InsnList haystack, InsnList needle, InsnList replacement, AbstractInsnNode haystackStart) {
        InsnList found = ASMHelper.findAndGetFoundInsnList(haystackStart, needle);
        if (found.getFirst() != null) {
            haystack.insertBefore(found.getFirst(), replacement);
            AbstractInsnNode afterNeedle = found.getLast().getNext();
            ASMHelper.removeFromInsnListUntil(haystack, found.getFirst(), afterNeedle);
            return afterNeedle;
        }
        return null;
    }

    public static int findAndReplaceAll(InsnList haystack, InsnList needle, InsnList replacement) {
        return ASMHelper.findAndReplaceAll(haystack, needle, replacement, haystack.getFirst());
    }

    public static int findAndReplaceAll(InsnList haystack, InsnList needle, InsnList replacement, AbstractInsnNode haystackStart) {
        int numReplaced = 0;
        while ((haystackStart = ASMHelper.findAndReplace(haystack, needle, ASMHelper.cloneInsnList(replacement), haystackStart)) != null) {
            ++numReplaced;
        }
        return numReplaced;
    }

    public static InsnList cloneInsnList(InsnList source) {
        AbstractInsnNode instruction;
        InsnList clone = new InsnList();
        HashMap<LabelNode, LabelNode> labelMap = new HashMap<LabelNode, LabelNode>();
        for (instruction = source.getFirst(); instruction != null; instruction = instruction.getNext()) {
            if (!(instruction instanceof LabelNode)) continue;
            labelMap.put((LabelNode)instruction, new LabelNode());
        }
        for (instruction = source.getFirst(); instruction != null; instruction = instruction.getNext()) {
            clone.add(instruction.clone(labelMap));
        }
        return clone;
    }

    public static LocalVariableNode findLocalVariableOfMethod(MethodNode method, String varName, String varDesc) {
        for (LocalVariableNode localVar : method.localVariables) {
            if (!localVar.name.equals(varName) || !localVar.desc.equals(varDesc)) continue;
            return localVar;
        }
        return null;
    }

    public static MethodNode copyAndRenameMethod(ClassNode classNode, MethodNode method, String newMethodName) {
        MethodVisitor methodCopyVisitor = classNode.visitMethod(method.access, newMethodName, method.desc, method.signature, method.exceptions.toArray(new String[method.exceptions.size()]));
        method.accept((MethodVisitor)new RemappingMethodAdapter(method.access, method.desc, methodCopyVisitor, new Remapper(){}));
        return methodCopyVisitor instanceof MethodNode ? (MethodNode)methodCopyVisitor : null;
    }

    public static String getInsnListAsString(InsnList insnList) {
        insnList.accept((MethodVisitor)methodprinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }

    public static String getMethodAsString(MethodNode method) {
        method.accept((MethodVisitor)methodprinter);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString();
    }
}

