/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import com.google.common.primitives.Longs;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;
import org.minimallycorrect.tickprofiler.util.CollectionsUtil;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class ContentionProfiler
extends Profile {
    private final Map<String, IntegerHolder> monitorMap = new IntHashMap<String>();
    private final Map<String, IntegerHolder> waitingMap = new IntHashMap<String>();
    private final Map<String, IntegerHolder> traceMap = new IntHashMap<String>();
    private long[] threads;
    private int ticks = 0;

    private static String name(StackTraceElement stack) {
        if (stack == null) {
            return null;
        }
        String className = stack.getClassName();
        return className.substring(className.lastIndexOf(46) + 1) + '.' + stack.getMethodName();
    }

    @Override
    public void start() {
        int elements = this.parameters.getInt("elements");
        if (elements <= 0) {
            throw new IllegalArgumentException("elements must be > 0");
        }
        int intervalMs = this.parameters.getInt("interval_ms");
        this.start(() -> {
            List threads = Thread.getAllStackTraces().keySet().stream().map(Thread::getId).collect(Collectors.toList());
            this.threads = Longs.toArray(threads);
        }, () -> this.targets.forEach(it -> {
            TableFormatter tf = it.getTableFormatter();
            this.dump(tf, elements);
            it.sendTables(tf);
        }), () -> {
            this.monitorMap.clear();
            this.waitingMap.clear();
            this.traceMap.clear();
            this.ticks = 0;
        }, intervalMs, this::tick);
    }

    private void dump(TableFormatter tf, int entries) {
        float ticks = this.ticks;
        tf.heading("Monitor").heading("Wasted Cores");
        for (String key : CollectionsUtil.sortedKeys(this.monitorMap, entries)) {
            tf.row(key).row((float)this.monitorMap.get((Object)key).value / ticks);
        }
        tf.finishTable();
        tf.sb.append('\n');
        tf.heading("Wait").heading("Wasted Cores");
        for (String key : CollectionsUtil.sortedKeys(this.waitingMap, entries)) {
            tf.row(key).row((float)this.waitingMap.get((Object)key).value / ticks);
        }
        tf.finishTable();
        tf.sb.append('\n');
        tf.heading("Stack").heading("Wasted Cores");
        for (String key : CollectionsUtil.sortedKeys(this.traceMap, entries)) {
            tf.row(key).row((float)this.traceMap.get((Object)key).value / ticks);
        }
        tf.finishTable();
    }

    private void tick() {
        ThreadInfo[] threads;
        ++this.ticks;
        block3: for (ThreadInfo thread : threads = ManagementFactory.getThreadMXBean().getThreadInfo(this.threads, 6)) {
            if (thread == null) continue;
            Thread.State ts = thread.getThreadState();
            switch (ts) {
                case WAITING: 
                case TIMED_WAITING: 
                case BLOCKED: {
                    LockInfo lockInfo;
                    StackTraceElement[] stackTrace = thread.getStackTrace();
                    StackTraceElement stack = null;
                    StackTraceElement prevStack = null;
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        String className = stackTraceElement.getClassName();
                        if (!className.startsWith("java") && !className.startsWith("sun.")) {
                            stack = stackTraceElement;
                            break;
                        }
                        prevStack = stackTraceElement;
                    }
                    if ((lockInfo = thread.getLockInfo()) != null) {
                        ++(ts == Thread.State.BLOCKED ? this.monitorMap : this.waitingMap).get((Object)lockInfo.toString()).value;
                    }
                    if (stack == null) continue block3;
                    String prev = ContentionProfiler.name(prevStack);
                    ++this.traceMap.get((Object)new StringBuilder().append((String)ContentionProfiler.name((StackTraceElement)stack)).append((String)(prev == null ? "" : new StringBuilder().append((String)" -> ").append((String)prev).toString())).toString()).value;
                }
            }
        }
    }

    private static class IntegerHolder
    implements Comparable<IntegerHolder> {
        int value;

        IntegerHolder() {
        }

        @Override
        public int compareTo(IntegerHolder o) {
            return Integer.compare(this.value, o.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntegerHolder)) {
                return false;
            }
            IntegerHolder other = (IntegerHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        protected boolean canEqual(Object other) {
            return other instanceof IntegerHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }
    }

    private static class IntHashMap<K>
    extends HashMap<K, IntegerHolder> {
        IntHashMap() {
        }

        @Override
        public IntegerHolder get(Object k) {
            IntegerHolder integerHolder = (IntegerHolder)super.get(k);
            if (integerHolder == null) {
                integerHolder = new IntegerHolder();
                this.put(k, integerHolder);
            }
            return integerHolder;
        }
    }
}

