/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import org.minimallycorrect.tickprofiler.Log;
import org.minimallycorrect.tickprofiler.minecraft.commands.Command;
import org.minimallycorrect.tickprofiler.minecraft.commands.Parameters;
import org.minimallycorrect.tickprofiler.minecraft.commands.UsageException;
import org.minimallycorrect.tickprofiler.minecraft.profiling.AlreadyRunningException;
import org.minimallycorrect.tickprofiler.minecraft.profiling.ContentionProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.EntityCountingProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.EntityProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.LagSpikeProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.PacketProfiler;
import org.minimallycorrect.tickprofiler.minecraft.profiling.UtilisationProfiler;
import org.minimallycorrect.tickprofiler.util.TableFormatter;
import org.minimallycorrect.tickprofiler.util.stringfillers.StringFiller;

public abstract class Profile {
    @Nullable
    ICommandSender commandSender;
    List<ProfileTarget> targets;
    Parameters parameters;
    long startTime;
    int runTimeSeconds;
    private Thread thread;

    protected AtomicBoolean getRunning() {
        return null;
    }

    public abstract void start();

    public final void start(ICommandSender commandSender, List<ProfileTarget> targets, Parameters p) {
        this.commandSender = commandSender;
        this.targets = targets;
        this.parameters = p;
        this.startTime = System.nanoTime();
        if (p.has("time")) {
            this.runTimeSeconds = p.getInt("time");
            if (this.runTimeSeconds <= 0) {
                throw new UsageException("time must be > 0, got " + this.runTimeSeconds);
            }
        }
        this.start();
    }

    public void closeIfNeeded() {
        if (this.thread == null) {
            this.end();
        }
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }

    public void abort() {
        this.thread.interrupt();
    }

    void start(Runnable before, Runnable after, Runnable finally_, long interval, Runnable intervalRunnable) {
        AtomicBoolean running = this.getRunning();
        if (running != null && !running.compareAndSet(false, true)) {
            throw new AlreadyRunningException(this.getName() + " is already running");
        }
        this.thread = new Thread(() -> {
            if (before != null) {
                before.run();
            }
            try {
                this.targets.forEach(it -> it.sendMessage("Running " + this.getName() + " for " + this.runTimeSeconds + " seconds"));
                if (intervalRunnable == null) {
                    Thread.sleep((long)this.runTimeSeconds * 1000L);
                } else {
                    long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.runTimeSeconds);
                    while (System.nanoTime() < end) {
                        Thread.sleep(interval);
                        intervalRunnable.run();
                    }
                }
                if (after != null) {
                    after.run();
                }
            }
            catch (InterruptedException ignored) {
                this.targets.forEach(it -> it.sendMessage("Profiling aborted due to interrupt"));
            }
            finally {
                if (finally_ != null) {
                    finally_.run();
                }
                this.end();
            }
        }, this.getName());
        this.thread.start();
    }

    void start(Runnable before, Runnable after, Runnable finally_) {
        this.start(before, after, finally_, 0L, null);
    }

    private void end() {
        AtomicBoolean running = this.getRunning();
        if (running != null && !running.compareAndSet(true, false)) {
            throw new IllegalStateException(this.getName() + " is not already running");
        }
        for (ProfileTarget target : this.targets) {
            target.close();
        }
    }

    public static interface ProfileTarget
    extends AutoCloseable {
        public static ProfileTarget console() {
            return new ProfileTarget(){

                @Override
                public void sendMessage(String message) {
                    Log.info('\n' + message);
                }

                @Override
                public TableFormatter getTableFormatter() {
                    return new TableFormatter(StringFiller.FIXED_WIDTH, false);
                }
            };
        }

        public static ProfileTarget commandSender(final ICommandSender commandSender) {
            return new ProfileTarget(){

                @Override
                public void sendMessage(String message) {
                    Command.sendChat(commandSender, message);
                }

                @Override
                public TableFormatter getTableFormatter() {
                    return new TableFormatter(commandSender);
                }
            };
        }

        public static ProfileTarget json(File file) {
            final BufferedWriter w = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);
            return new ProfileTarget(){

                @Override
                public void sendMessage(String message) {
                    w.write(message + "\n");
                }

                @Override
                public TableFormatter getTableFormatter() {
                    return new TableFormatter(StringFiller.FIXED_WIDTH, true);
                }

                @Override
                public void close() {
                    w.close();
                }
            };
        }

        public void sendMessage(String var1);

        public TableFormatter getTableFormatter();

        default public void sendTables(TableFormatter tf) {
            this.sendMessage(tf.toString());
        }

        @Override
        default public void close() {
        }
    }

    public static enum Types {
        COUNT_ENTITIES("c", EntityCountingProfiler.class, Arrays.asList("worlds", "all", "elements", "10")),
        ENTITIES("e", EntityProfiler.class, Arrays.asList("time", "30", "worlds", "all", "elements", "5", "chunk", "all")),
        PACKETS("p", PacketProfiler.class, Arrays.asList("time", "30", "elements", "5")),
        UTILISATION("u", UtilisationProfiler.class, Arrays.asList("time", "30", "elements", "5")),
        LOCK_CONTENTION("l", ContentionProfiler.class, Arrays.asList("time", "30", "elements", "5", "interval_ms", "23")),
        LAG_SPIKE_DETECTOR("s", LagSpikeProfiler.class, Arrays.asList("time", "500"));

        private static final Map<String, Types> types;
        public final String shortName;
        final Class<? extends Profile> clazz;
        final List<String> orderWithDefaults;

        public static Types byName(String typeName) {
            return types.get(typeName.toLowerCase());
        }

        public void addParameters(Parameters p) {
            p.orderWithDefault(this.orderWithDefaults);
        }

        public Profile create() {
            return this.clazz.newInstance();
        }

        private Types(String shortName, Class<? extends Profile> clazz, List<String> orderWithDefaults) {
            this.shortName = shortName;
            this.clazz = clazz;
            this.orderWithDefaults = orderWithDefaults;
        }

        static {
            types = new HashMap<String, Types>();
            for (Types t : Types.values()) {
                types.put(t.shortName.toLowerCase(), t);
                types.put(t.name().toLowerCase(), t);
            }
        }
    }
}

